/*
 * Decompiled with CFR 0.152.
 */
package io.dogboy.serializationisbad.core;

import io.dogboy.serializationisbad.core.SerializationIsBad;
import io.dogboy.serializationisbad.core.config.PatchModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.HashSet;

public class ClassFilteringObjectInputStream
extends ObjectInputStream {
    private final PatchModule patchModule;
    private final ClassLoader parentClassLoader;
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);

    public ClassFilteringObjectInputStream(InputStream in, PatchModule patchModule, ClassLoader parentClassLoader) throws IOException {
        super(in);
        this.patchModule = patchModule;
        this.parentClassLoader = parentClassLoader;
    }

    public ClassFilteringObjectInputStream(InputStream in, PatchModule patchModule) throws IOException {
        this(in, patchModule, null);
    }

    private boolean isClassAllowed(String className) {
        while (className.startsWith("[")) {
            className = className.substring(1);
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            className = className.substring(1, className.length() - 1);
        }
        if (SerializationIsBad.getInstance().getConfig().getClassAllowlist().contains(className) || this.patchModule.getClassAllowlist().contains(className)) {
            return true;
        }
        HashSet<String> allowedPackages = new HashSet<String>(SerializationIsBad.getInstance().getConfig().getPackageAllowlist());
        allowedPackages.addAll(this.patchModule.getPackageAllowlist());
        for (String allowedPackage : allowedPackages) {
            if (!className.startsWith(allowedPackage + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        SerializationIsBad.logger.debug("Resolving class " + desc.getName());
        if (!this.isClassAllowed(desc.getName())) {
            SerializationIsBad.logger.warn("Tried to resolve class " + desc.getName() + ", which is not allowed to be deserialized");
            if (SerializationIsBad.getInstance().getConfig().isExecuteBlocking()) {
                throw new ClassNotFoundException("Class " + desc.getName() + " is not allowed to be deserialized");
            }
        }
        if (this.parentClassLoader == null) {
            return super.resolveClass(desc);
        }
        String name = desc.getName();
        try {
            return Class.forName(name, false, this.parentClassLoader);
        }
        catch (ClassNotFoundException ex) {
            Class<?> cl = primClasses.get(name);
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

