/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.interfaces;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.boss.BossStatus;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.IInterfaceLoader;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.Preset;
import xaero.common.interfaces.pushbox.BossHealthPushBox;
import xaero.common.interfaces.pushbox.BossHealthShiftPushBox;
import xaero.common.interfaces.pushbox.IBossHealthPushBox;
import xaero.common.interfaces.pushbox.PushBox;
import xaero.common.minimap.MinimapInterface;

public class InterfaceManager {
    private IXaeroMinimap modMain;
    private Minecraft mc;
    private ArrayList<Preset> presets;
    private ArrayList<Interface> list;
    public ArrayList<? extends PushBox> pushBoxes;
    private int actionTimer;
    private int selectedId;
    private int draggingId;
    private int draggingOffX;
    private int draggingOffY;
    private long lastFlip;
    private BossHealthPushBox normalBossHealthPushBox;
    private BossHealthShiftPushBox shiftBossHealthPushBox;

    public InterfaceManager(IXaeroMinimap modMain, IInterfaceLoader loader) {
        this.modMain = modMain;
        this.presets = new ArrayList();
        this.list = new ArrayList();
        this.mc = Minecraft.func_71410_x();
        this.selectedId = -1;
        this.draggingId = -1;
        this.normalBossHealthPushBox = new BossHealthPushBox();
        this.shiftBossHealthPushBox = new BossHealthShiftPushBox();
        this.pushBoxes = Lists.newArrayList((Object[])new PushBox[]{this.normalBossHealthPushBox, this.shiftBossHealthPushBox});
        loader.loadPresets(this);
        loader.load(modMain, this);
    }

    public IBossHealthPushBox getBossHealthPushBox() {
        int boxType = this.modMain.getSettings().bossHealthPushBox;
        return (IBossHealthPushBox)((Object)(boxType == 0 ? null : (boxType == 2 ? this.shiftBossHealthPushBox : this.normalBossHealthPushBox)));
    }

    public MinimapInterface getMinimapInterface() {
        return (MinimapInterface)this.list.get(4);
    }

    public boolean overAButton(int mouseX, int mouseY) {
        if (this.mc.field_71462_r instanceof GuiEditMode) {
            for (int k = 0; k < ((GuiEditMode)this.mc.field_71462_r).getButtons().size(); ++k) {
                GuiButton b = (GuiButton)((GuiEditMode)this.mc.field_71462_r).getButtons().get(k);
                if (mouseX < b.field_146128_h || mouseY < b.field_146129_i || mouseX >= b.field_146128_h + 150 || mouseY >= b.field_146129_i + 20) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateBlinkingOverridable() {
    }

    public void updateInterfaces(XaeroMinimapSession minimapSession, int mouseX, int mouseY, int width, int height, double scale) {
        IBossHealthPushBox bhpb;
        GuiScreen screen = (GuiScreen)this.modMain.getEvents().getLastGuiOpen();
        if (this.actionTimer <= 0) {
            this.updateBlinkingOverridable();
            if (screen instanceof GuiEditMode) {
                int i;
                if (Mouse.isButtonDown((int)1)) {
                    this.selectedId = -1;
                }
                if ((i = this.getInterfaceId(minimapSession, mouseX, mouseY, width, height, scale)) == -1) {
                    i = this.selectedId;
                }
                if (i != -1) {
                    if (Mouse.isButtonDown((int)0) && this.draggingId == -1) {
                        this.draggingId = i;
                        this.selectedId = i;
                        this.draggingOffX = this.list.get(i).getX() - mouseX;
                        this.draggingOffY = this.list.get(i).getY() - mouseY;
                    } else if (!Mouse.isButtonDown((int)0) && this.draggingId != -1) {
                        this.draggingId = -1;
                        this.draggingOffX = 0;
                        this.draggingOffY = 0;
                    }
                    if (this.selectedId != -1) {
                        i = this.selectedId;
                    }
                    if (Keyboard.isKeyDown((int)33) && System.currentTimeMillis() - this.lastFlip > 300L) {
                        this.lastFlip = System.currentTimeMillis();
                        this.list.get(i).setFlipped(!this.list.get(i).isFlipped());
                    }
                    if (Keyboard.isKeyDown((int)46) && System.currentTimeMillis() - this.lastFlip > 300L) {
                        this.lastFlip = System.currentTimeMillis();
                        this.list.get(i).setCentered(!this.list.get(i).isCentered());
                    }
                    if (Keyboard.isKeyDown((int)31)) {
                        this.selectedId = -1;
                        this.draggingId = -1;
                        this.modMain.getGuiHelper().openInterfaceSettings(i);
                    }
                }
                if (this.draggingId != -1) {
                    Interface interface_ = this.list.get(this.draggingId);
                    if (!interface_.isCentered()) {
                        interface_.setActualx(mouseX + this.draggingOffX);
                        if (interface_.isFromRight()) {
                            interface_.setActualx(width - interface_.getActualx());
                        }
                    }
                    int centerX = interface_.getActualx() + interface_.getW() / 2 * (interface_.isFromRight() ? -1 : 1);
                    if (interface_.isFromRight() && (width & 1) == 0) {
                        ++centerX;
                    }
                    if (centerX > width / 2) {
                        interface_.setFromRight(!interface_.isFromRight());
                        interface_.setActualx(width - interface_.getActualx());
                    }
                    interface_.setActualy(mouseY + this.draggingOffY);
                    if (interface_.isFromBottom()) {
                        interface_.setActualy(height - interface_.getActualy());
                    }
                    int centerY = interface_.getActualy() + interface_.getH() / 2 * (interface_.isFromBottom() ? -1 : 1);
                    if (interface_.isFromBottom() && (height & 1) == 0) {
                        ++centerY;
                    }
                    if (centerY > height / 2) {
                        interface_.setFromBottom(!interface_.isFromBottom());
                        interface_.setActualy(height - interface_.getActualy());
                    }
                }
            }
        } else {
            --this.actionTimer;
        }
        for (Interface interface_ : this.list) {
            InterfaceInstance ji = minimapSession.getInterfaceInstances().get(interface_);
            interface_.setX(interface_.getActualx());
            interface_.setY(interface_.getActualy());
            if (interface_.isFromRight()) {
                interface_.setX(width - interface_.getX());
            }
            if (interface_.isFromBottom()) {
                interface_.setY(height - interface_.getY());
            }
            if (interface_.isCentered()) {
                if (interface_.isMulti()) {
                    interface_.setW(ji.getWC(scale));
                    interface_.setH(ji.getHC(scale));
                }
                interface_.setX(width / 2 - ji.getW(scale) / 2);
            } else if (interface_.isMulti()) {
                interface_.setW(ji.getW0(scale));
                interface_.setH(ji.getH0(scale));
            }
            if (interface_.getX() < 5) {
                interface_.setX(0);
            }
            if (interface_.getY() < 5) {
                interface_.setY(0);
            }
            if (interface_.getX() + ji.getW(scale) > width - 5) {
                interface_.setX(width - ji.getW(scale));
            }
            if (interface_.getY() + ji.getH(scale) <= height - 5) continue;
            interface_.setY(height - ji.getH(scale));
        }
        if (BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0 && (bhpb = this.getBossHealthPushBox()) != null) {
            bhpb.setActive(true);
            bhpb.setLastBossHealthHeight(30);
        }
        for (PushBox pushBox : this.pushBoxes) {
            pushBox.update();
        }
    }

    public void pushInterface(Interface j, InterfaceInstance ji, double scale, int width, int height) {
        for (PushBox pushBox : this.pushBoxes) {
            boolean bottomBlocked;
            boolean rightBlocked;
            if (!pushBox.isActive()) continue;
            int interfaceX = j.getX();
            int interfaceY = j.getY();
            int interfaceW = ji.getW(scale);
            int interfaceH = ji.getH(scale);
            int pushBoxX = (int)((float)width * pushBox.getAnchorX()) + pushBox.getX(width, height);
            int pushBoxY = (int)((float)height * pushBox.getAnchorY()) + pushBox.getY(width, height);
            int pushBoxW = pushBox.getW(width, height);
            int pushBoxH = pushBox.getH(width, height);
            int minPushX = 0;
            int minPushY = 0;
            int overLeftSide = interfaceX + interfaceW - pushBoxX;
            int overRightSide = interfaceX - (pushBoxX + pushBoxW);
            int overTopSide = interfaceY + interfaceH - pushBoxY;
            int overBottomSide = interfaceY - (pushBoxY + pushBoxH);
            if (overLeftSide <= 0 || overRightSide >= 0 || overTopSide <= 0 || overBottomSide >= 0) continue;
            boolean leftBlocked = interfaceX - overLeftSide < 0;
            boolean bl = rightBlocked = interfaceX - overRightSide + interfaceW > width;
            minPushX = leftBlocked == rightBlocked ? (-overRightSide < overLeftSide ? overRightSide : overLeftSide) : (leftBlocked ? overRightSide : overLeftSide);
            boolean topBlocked = interfaceY - overTopSide < 0;
            boolean bl2 = bottomBlocked = interfaceY - overBottomSide + interfaceH > height;
            if (topBlocked == bottomBlocked) {
                minPushY = -overBottomSide < overTopSide ? overBottomSide : overTopSide;
            } else {
                int n = minPushY = topBlocked ? overBottomSide : overTopSide;
            }
            if ((!leftBlocked || !rightBlocked || topBlocked && bottomBlocked) && Math.abs(minPushX) < Math.abs(minPushY) - pushBox.getVerticalBias()) {
                pushBox.push(ji, j, interfaceX, interfaceY, interfaceW, interfaceH, -minPushX, 0, width, height);
                continue;
            }
            pushBox.push(ji, j, interfaceX, interfaceY, interfaceW, interfaceH, 0, -minPushY, width, height);
        }
    }

    public int getInterfaceId(XaeroMinimapSession minimapSession, int mouseX, int mouseY, int width, int height, double scale) {
        int toReturn = -1;
        int size = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            Interface l = this.list.get(i);
            if (!this.modMain.getSettings().getBooleanValue(l.getOption())) continue;
            InterfaceInstance li = minimapSession.getInterfaceInstances().get(l);
            int x = l.getX();
            int y = l.getY();
            int x2 = x + li.getW(scale);
            int y2 = y + li.getH(scale);
            int isize = li.getSize(scale);
            if (l.getIname().equals("dummy") || size != 0 && isize >= size || this.overAButton(mouseX, mouseY) || mouseX < x || mouseX >= x2 || mouseY < y || mouseY >= y2) continue;
            size = isize;
            toReturn = i;
        }
        return toReturn;
    }

    public void add(Interface i) {
        this.list.add(i);
    }

    public Preset getDefaultPreset() {
        return this.presets.get(0);
    }

    public Preset getPreset(int id) {
        return this.presets.get(id);
    }

    public int getNextId() {
        return this.list.size();
    }

    public void addPreset(Preset preset) {
        this.presets.add(preset);
    }

    public int getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
    }

    public int getDraggingId() {
        return this.draggingId;
    }

    public void setDraggingId(int draggingId) {
        this.draggingId = draggingId;
    }

    public Iterator<Interface> getInterfaceIterator() {
        return this.list.iterator();
    }

    public Iterator<Preset> getPresetsIterator() {
        return this.presets.iterator();
    }

    public int getActionTimer() {
        return this.actionTimer;
    }

    public void setActionTimer(int actionTimer) {
        this.actionTimer = actionTimer;
    }
}

