/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.util;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetDropItem;
import pneumaticCraft.common.progwidgets.ProgWidgetGoToLocation;
import pneumaticCraft.common.progwidgets.ProgWidgetInventoryExport;
import pneumaticCraft.common.progwidgets.ProgWidgetInventoryImport;
import pneumaticCraft.common.progwidgets.ProgWidgetItemFilter;
import pneumaticCraft.common.progwidgets.ProgWidgetLiquidExport;
import pneumaticCraft.common.progwidgets.ProgWidgetLiquidFilter;
import pneumaticCraft.common.progwidgets.ProgWidgetLiquidImport;
import pneumaticCraft.common.progwidgets.ProgWidgetStart;
import pneumaticCraft.common.progwidgets.ProgWidgetSuicide;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;

public class ProgrammedDroneUtils {
    private static EntityDrone getChargedDispenserUpgradeDrone(World world) {
        EntityDrone drone = new EntityDrone(world);
        NBTTagCompound tag = new NBTTagCompound();
        drone.func_70014_b(tag);
        NBTTagList upgradeList = new NBTTagList();
        NBTTagCompound slotEntry = new NBTTagCompound();
        slotEntry.func_74774_a("Slot", (byte)0);
        new ItemStack(Itemss.machineUpgrade, 64, 1).func_77955_b(slotEntry);
        upgradeList.func_74742_a((NBTBase)slotEntry);
        slotEntry = new NBTTagCompound();
        slotEntry.func_74774_a("Slot", (byte)1);
        new ItemStack(Itemss.machineUpgrade, 10, 5).func_77955_b(slotEntry);
        upgradeList.func_74742_a((NBTBase)slotEntry);
        NBTTagCompound inv = new NBTTagCompound();
        inv.func_74782_a("Items", (NBTBase)upgradeList);
        tag.func_74782_a("Inventory", (NBTBase)inv);
        tag.func_74776_a("currentAir", 100000.0f);
        drone.func_70037_a(tag);
        drone.func_94058_c(StatCollector.func_74838_a((String)"drone.amadronDeliveryDrone"));
        drone.naturallySpawned = true;
        return drone;
    }

    public static EntityCreature deliverItemsAmazonStyle(World world, int x, int y, int z, ItemStack ... deliveredStacks) {
        int i;
        if (world.field_72995_K) {
            return null;
        }
        if (deliveredStacks.length == 0) {
            throw new IllegalArgumentException("You need to deliver at least 1 stack!");
        }
        if (deliveredStacks.length > 65) {
            throw new IllegalArgumentException("You can only deliver up to 65 stacks at once!");
        }
        for (ItemStack stack : deliveredStacks) {
            if (stack == null) {
                throw new IllegalArgumentException("You can't supply a null stack to be delivered!");
            }
            if (stack.func_77973_b() != null) continue;
            throw new IllegalArgumentException("You can't supply a stack with a null item to be delivered!");
        }
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world);
        int startY = world.func_72976_f(x + 30, z) + 30;
        drone.func_70107_b(x + 30, startY, z);
        List<IProgWidget> widgets = drone.progWidgets;
        ProgWidgetStart start = new ProgWidgetStart();
        start.setX(92);
        start.setY(41);
        widgets.add(start);
        ProgWidgetInventoryExport export = new ProgWidgetInventoryExport();
        export.setX(92);
        export.setY(52);
        widgets.add(export);
        ProgWidgetDropItem drop = new ProgWidgetDropItem();
        drop.setX(92);
        drop.setY(74);
        widgets.add(drop);
        ProgWidgetGoToLocation gotoPiece = new ProgWidgetGoToLocation();
        gotoPiece.setX(92);
        gotoPiece.setY(96);
        widgets.add(gotoPiece);
        ProgWidgetSuicide suicide = new ProgWidgetSuicide();
        suicide.setX(92);
        suicide.setY(107);
        widgets.add(suicide);
        ProgWidgetArea area = new ProgWidgetArea();
        area.setX(107);
        area.setY(52);
        area.x1 = x;
        area.y1 = y;
        area.z1 = z;
        widgets.add(area);
        area = new ProgWidgetArea();
        area.setX(107);
        area.setY(74);
        area.x1 = x;
        area.z1 = z;
        if (drone.isBlockValidPathfindBlock(x, y, z)) {
            for (i = 0; i < 5 && drone.isBlockValidPathfindBlock(area.x1, i + y + 1, area.z1); ++i) {
                area.y1 = y + i;
            }
        } else {
            area.y1 = world.func_72976_f(x, z) + 10;
            if (!drone.isBlockValidPathfindBlock(area.x1, area.y1, area.z1)) {
                area.y1 = 260;
            }
        }
        widgets.add(area);
        area = new ProgWidgetArea();
        area.setX(107);
        area.setY(96);
        area.x1 = x + 30;
        area.y1 = startY;
        area.z1 = z;
        widgets.add(area);
        TileEntityProgrammer.updatePuzzleConnections(widgets);
        for (i = 0; i < deliveredStacks.length; ++i) {
            drone.getInventory().func_70299_a(i, deliveredStacks[i].func_77946_l());
        }
        world.func_72838_d((Entity)drone);
        return drone;
    }

    public static EntityCreature deliverFluidAmazonStyle(World world, int x, int y, int z, FluidStack deliveredFluid) {
        if (world.field_72995_K) {
            return null;
        }
        if (deliveredFluid == null) {
            throw new IllegalArgumentException("Can't deliver a null FluidStack");
        }
        if (deliveredFluid.amount <= 0) {
            throw new IllegalArgumentException("Can't deliver a FluidStack with an amount of <= 0");
        }
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world);
        int startY = world.func_72976_f(x + 30, z) + 30;
        drone.func_70107_b(x + 30, startY, z);
        List<IProgWidget> widgets = drone.progWidgets;
        ProgWidgetStart start = new ProgWidgetStart();
        start.setX(92);
        start.setY(41);
        widgets.add(start);
        ProgWidgetLiquidExport export = new ProgWidgetLiquidExport();
        export.setX(92);
        export.setY(52);
        widgets.add(export);
        ProgWidgetGoToLocation gotoPiece = new ProgWidgetGoToLocation();
        gotoPiece.setX(92);
        gotoPiece.setY(74);
        widgets.add(gotoPiece);
        ProgWidgetSuicide suicide = new ProgWidgetSuicide();
        suicide.setX(92);
        suicide.setY(85);
        widgets.add(suicide);
        ProgWidgetArea area = new ProgWidgetArea();
        area.setX(107);
        area.setY(52);
        area.x1 = x;
        area.y1 = y;
        area.z1 = z;
        widgets.add(area);
        area = new ProgWidgetArea();
        area.setX(107);
        area.setY(74);
        area.x1 = x + 30;
        area.y1 = startY;
        area.z1 = z;
        widgets.add(area);
        TileEntityProgrammer.updatePuzzleConnections(widgets);
        drone.getTank().fill(deliveredFluid, true);
        world.func_72838_d((Entity)drone);
        return drone;
    }

    public static EntityCreature retrieveItemsAmazonStyle(World world, int x, int y, int z, ItemStack ... queriedStacks) {
        if (world.field_72995_K) {
            return null;
        }
        if (queriedStacks.length == 0) {
            throw new IllegalArgumentException("You need to query at least 1 stack!");
        }
        if (queriedStacks.length > 65) {
            throw new IllegalArgumentException("You can only query up to 65 stacks at once!");
        }
        for (ItemStack stack : queriedStacks) {
            if (stack == null) {
                throw new IllegalArgumentException("You can't query a null stack!");
            }
            if (stack.func_77973_b() != null) continue;
            throw new IllegalArgumentException("You can't query a stack with a null item!");
        }
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world);
        int startY = world.func_72976_f(x + 30, z) + 30;
        drone.func_70107_b(x + 30, startY, z);
        List<IProgWidget> widgets = drone.progWidgets;
        ProgWidgetStart start = new ProgWidgetStart();
        start.setX(92);
        start.setY(41);
        widgets.add(start);
        int yBase = 52;
        for (ItemStack stack : queriedStacks) {
            ProgWidgetInventoryImport im = new ProgWidgetInventoryImport();
            im.setX(92);
            im.setY(yBase);
            im.setCount(stack.field_77994_a);
            im.setUseCount(true);
            widgets.add(im);
            ProgWidgetArea area = new ProgWidgetArea();
            area.setX(107);
            area.setY(yBase);
            area.x1 = x;
            area.y1 = y;
            area.z1 = z;
            widgets.add(area);
            ProgWidgetItemFilter filter = new ProgWidgetItemFilter();
            filter.setX(107);
            filter.setY(yBase + 11);
            filter.setFilter(stack);
            filter.useMetadata = true;
            filter.useNBT = true;
            widgets.add(filter);
            yBase += 22;
        }
        ProgWidgetGoToLocation gotoPiece = new ProgWidgetGoToLocation();
        gotoPiece.setX(92);
        gotoPiece.setY(yBase);
        widgets.add(gotoPiece);
        ProgWidgetArea area = new ProgWidgetArea();
        area.setX(107);
        area.setY(yBase);
        area.x1 = x + 30;
        area.y1 = startY;
        area.z1 = z;
        widgets.add(area);
        ProgWidgetSuicide suicide = new ProgWidgetSuicide();
        suicide.setX(92);
        suicide.setY(yBase + 11);
        widgets.add(suicide);
        TileEntityProgrammer.updatePuzzleConnections(widgets);
        world.func_72838_d((Entity)drone);
        return drone;
    }

    public static EntityCreature retrieveFluidAmazonStyle(World world, int x, int y, int z, FluidStack queriedFluid) {
        if (world.field_72995_K) {
            return null;
        }
        if (queriedFluid == null) {
            throw new IllegalArgumentException("Can't query a null FluidStack");
        }
        if (queriedFluid.amount <= 0) {
            throw new IllegalArgumentException("Can't query a FluidStack with an amount of <= 0");
        }
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world);
        int startY = world.func_72976_f(x + 30, z) + 30;
        drone.func_70107_b(x + 30, startY, z);
        List<IProgWidget> widgets = drone.progWidgets;
        ProgWidgetStart start = new ProgWidgetStart();
        start.setX(92);
        start.setY(41);
        widgets.add(start);
        int yBase = 52;
        ProgWidgetLiquidImport im = new ProgWidgetLiquidImport();
        im.setX(92);
        im.setY(yBase);
        im.setCount(queriedFluid.amount);
        im.setUseCount(true);
        widgets.add(im);
        ProgWidgetArea area = new ProgWidgetArea();
        area.setX(107);
        area.setY(yBase);
        area.x1 = x;
        area.y1 = y;
        area.z1 = z;
        widgets.add(area);
        ProgWidgetLiquidFilter filter = new ProgWidgetLiquidFilter();
        filter.setX(107);
        filter.setY(yBase + 11);
        filter.setFluid(queriedFluid.getFluid());
        widgets.add(filter);
        ProgWidgetGoToLocation gotoPiece = new ProgWidgetGoToLocation();
        gotoPiece.setX(92);
        gotoPiece.setY(yBase += 22);
        widgets.add(gotoPiece);
        area = new ProgWidgetArea();
        area.setX(107);
        area.setY(yBase);
        area.x1 = x + 30;
        area.y1 = startY;
        area.z1 = z;
        widgets.add(area);
        ProgWidgetSuicide suicide = new ProgWidgetSuicide();
        suicide.setX(92);
        suicide.setY(yBase + 11);
        widgets.add(suicide);
        TileEntityProgrammer.updatePuzzleConnections(widgets);
        world.func_72838_d((Entity)drone);
        return drone;
    }
}

