/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.FilteredSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityPressureChamberValve;
import pneumaticCraft.common.tileentity.TileEntityPressureChamberWall;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityPressureChamberInterface
extends TileEntityPressureChamberWall
implements ISidedInventory,
IGUITextFieldSensitive,
IRedstoneControlled {
    @DescSynced
    @FilteredSynced(index=0)
    private ItemStack[] inventory = new ItemStack[14];
    @DescSynced
    @LazySynced
    public int inputProgress;
    public int oldInputProgress;
    @DescSynced
    @LazySynced
    public int outputProgress;
    public int oldOutputProgress;
    public static final int MAX_PROGRESS = 40;
    private static final int UPGRADE_SLOT_START = 1;
    private static final int UPGRADE_SLOT_END = 4;
    @GuiSynced
    public EnumInterfaceMode interfaceMode = EnumInterfaceMode.NONE;
    @GuiSynced
    private boolean enoughAir = true;
    @DescSynced
    public EnumFilterMode filterMode = EnumFilterMode.ITEM;
    @GuiSynced
    public int creativeTabID;
    @DescSynced
    public String itemNameFilter = "";
    private boolean isOpeningI;
    private boolean isOpeningO;
    @DescSynced
    private boolean shouldOpenInput;
    @DescSynced
    private boolean shouldOpenOutput;
    @GuiSynced
    public int redstoneMode;
    private int inputTimeOut;
    private int oldItemCount;

    public TileEntityPressureChamberInterface() {
        this.setUpgradeSlots(1, 2, 3, 4);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean wasOpeningI = this.isOpeningI;
        boolean wasOpeningO = this.isOpeningO;
        this.oldInputProgress = this.inputProgress;
        this.oldOutputProgress = this.outputProgress;
        TileEntityPressureChamberValve core = this.getCore();
        if (!this.field_145850_b.field_72995_K) {
            int itemCount;
            int n = itemCount = this.inventory[0] != null ? this.inventory[0].field_77994_a : 0;
            if (this.oldItemCount != itemCount) {
                this.oldItemCount = itemCount;
                this.inputTimeOut = 0;
            }
            this.interfaceMode = this.getInterfaceMode(core);
            this.enoughAir = true;
            if (this.interfaceMode != EnumInterfaceMode.NONE) {
                if (this.inventory[0] != null && ++this.inputTimeOut > 10) {
                    this.shouldOpenInput = false;
                    if (this.inputProgress == 0) {
                        this.shouldOpenOutput = true;
                        if (this.outputProgress == 40) {
                            if (this.interfaceMode == EnumInterfaceMode.IMPORT) {
                                this.outputInChamber();
                            } else {
                                this.exportToInventory();
                            }
                        }
                    }
                } else {
                    this.shouldOpenOutput = false;
                    if (this.outputProgress == 0) {
                        this.shouldOpenInput = true;
                        if (this.interfaceMode == EnumInterfaceMode.EXPORT && this.inputProgress == 40 && this.redstoneAllows()) {
                            this.importFromChamber(core);
                        }
                    }
                }
            } else {
                this.shouldOpenInput = false;
                this.shouldOpenOutput = false;
            }
        }
        int speed = (int)this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots());
        if (this.shouldOpenInput) {
            this.inputProgress = Math.min(this.inputProgress + speed, 40);
            this.isOpeningI = true;
        } else {
            this.inputProgress = Math.max(this.inputProgress - speed, 0);
            this.isOpeningI = false;
        }
        if (this.shouldOpenOutput) {
            this.outputProgress = Math.min(this.outputProgress + speed, 40);
            this.isOpeningO = true;
        } else {
            this.outputProgress = Math.max(this.outputProgress - speed, 0);
            this.isOpeningO = false;
        }
        if (this.field_145850_b.field_72995_K && (wasOpeningI != this.isOpeningI || wasOpeningO != this.isOpeningO)) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "pneumaticcraft:interfaceDoor", 0.1f, 1.0f, true);
        }
    }

    private void exportToInventory() {
        ForgeDirection side;
        ItemStack leftoverStack;
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.func_145832_p());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + facing.offsetX, this.field_145848_d + facing.offsetY, this.field_145849_e + facing.offsetZ);
        if (te != null && ((leftoverStack = PneumaticCraftUtils.exportStackToInventory(te, this.inventory[0], side = facing.getOpposite())) == null || leftoverStack.field_77994_a == 0)) {
            this.inventory[0] = null;
        }
    }

    private void importFromChamber(TileEntityPressureChamberValve core) {
        ItemStack[] chamberStacks;
        for (ItemStack chamberStack : chamberStacks = core.getStacksInChamber()) {
            int maxAllowedItems;
            if (this.inventory[0] != null && !this.inventory[0].func_77969_a(chamberStack) || !this.func_94041_b(0, chamberStack) || (maxAllowedItems = Math.abs(core.currentAir) / 1000) <= 0) continue;
            if (this.inventory[0] != null) {
                maxAllowedItems = Math.min(maxAllowedItems, chamberStack.func_77976_d() - this.inventory[0].field_77994_a);
            }
            int transferedItems = Math.min(chamberStack.field_77994_a, maxAllowedItems);
            core.addAir((core.currentAir > 0 ? -1 : 1) * transferedItems * 1000, ForgeDirection.UNKNOWN);
            ItemStack transferedStack = chamberStack.func_77946_l().func_77979_a(transferedItems);
            ItemStack insertedStack = transferedStack.func_77946_l();
            if (this.inventory[0] != null) {
                insertedStack.field_77994_a += this.inventory[0].field_77994_a;
            }
            this.func_70299_a(0, insertedStack);
            core.clearStacksInChamber(transferedStack);
        }
    }

    private void outputInChamber() {
        TileEntityPressureChamberValve valve = this.getCore();
        if (valve != null) {
            for (int i = 0; i < 6; ++i) {
                int x = this.field_145851_c + Facing.field_71586_b[i];
                int y = this.field_145848_d + Facing.field_71587_c[i];
                int z = this.field_145849_e + Facing.field_71585_d[i];
                if (!valve.isCoordWithinChamber(this.field_145850_b, x, y, z)) continue;
                boolean bl = this.enoughAir = Math.abs(valve.currentAir) > this.inventory[0].field_77994_a * 1000;
                if (!this.enoughAir) continue;
                valve.addAir((valve.currentAir > 0 ? -1 : 1) * this.inventory[0].field_77994_a * 1000, ForgeDirection.UNKNOWN);
                EntityItem item = new EntityItem(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.inventory[0].func_77946_l());
                this.field_145850_b.func_72838_d((Entity)item);
                this.func_70299_a(0, null);
                break;
            }
        }
    }

    private EnumInterfaceMode getInterfaceMode(TileEntityPressureChamberValve core) {
        if (core != null) {
            boolean xMid = this.field_145851_c != core.multiBlockX && this.field_145851_c != core.multiBlockX + core.multiBlockSize - 1;
            boolean yMid = this.field_145848_d != core.multiBlockY && this.field_145848_d != core.multiBlockY + core.multiBlockSize - 1;
            boolean zMid = this.field_145849_e != core.multiBlockZ && this.field_145849_e != core.multiBlockZ + core.multiBlockSize - 1;
            int meta = this.func_145832_p();
            if (xMid && yMid && meta == 2 || xMid && zMid && meta == 0 || yMid && zMid && meta == 4) {
                if (this.field_145851_c == core.multiBlockX || this.field_145848_d == core.multiBlockY || this.field_145849_e == core.multiBlockZ) {
                    return EnumInterfaceMode.EXPORT;
                }
                return EnumInterfaceMode.IMPORT;
            }
            if (xMid && yMid && meta == 3 || xMid && zMid && meta == 1 || yMid && zMid && meta == 5) {
                if (this.field_145851_c == core.multiBlockX || this.field_145848_d == core.multiBlockY || this.field_145849_e == core.multiBlockZ) {
                    return EnumInterfaceMode.IMPORT;
                }
                return EnumInterfaceMode.EXPORT;
            }
        }
        return EnumInterfaceMode.NONE;
    }

    public List<String> getProblemStat() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.interfaceMode == EnumInterfaceMode.NONE) {
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a77The Interface can't work.", 26));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70-The Interface is not in a properly formed Pressure Chamber, and/or", 26));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70-The Interface is not adjacent to an air block of the Pressure Chamber, and/or", 26));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70-The Interface isn't orientated right.", 26));
        } else if (!this.redstoneAllows()) {
            textList.add("gui.tab.problems.redstoneDisallows");
        } else if (!this.enoughAir) {
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a77There's not enough pressure in the Pressure Chamber to move the items.", 26));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Apply more pressure to the Pressure Chamber. The required pressure is dependent on the amount of items being transported.", 26));
        }
        return textList;
    }

    public boolean hasEnoughPressure() {
        return this.enoughAir;
    }

    @Override
    public boolean redstoneAllows() {
        switch (this.redstoneMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 2: {
                return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.outputProgress = tag.func_74762_e("outputProgress");
        this.inputProgress = tag.func_74762_e("inputProgress");
        this.interfaceMode = EnumInterfaceMode.values()[tag.func_74762_e("interfaceMode")];
        this.filterMode = EnumFilterMode.values()[tag.func_74762_e("filterMode")];
        this.creativeTabID = tag.func_74762_e("creativeTabID");
        this.itemNameFilter = tag.func_74779_i("itemNameFilter");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        tag.func_74768_a("outputProgress", this.outputProgress);
        tag.func_74768_a("inputProgress", this.inputProgress);
        tag.func_74768_a("interfaceMode", this.interfaceMode.ordinal());
        tag.func_74768_a("filterMode", this.filterMode.ordinal());
        tag.func_74768_a("creativeTabID", this.creativeTabID);
        tag.func_74778_a("itemNameFilter", this.itemNameFilter);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
    }

    public int func_70302_i_() {
        return 14;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (!this.field_145850_b.field_72995_K && slot == 0) {
            this.sendDescriptionPacket();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return Blockss.pressureChamberInterface.func_149739_a();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack iStack) {
        if (iStack == null) {
            return false;
        }
        switch (this.filterMode) {
            case ITEM: {
                boolean filterEmpty = true;
                for (int i = 0; i < 9; ++i) {
                    ItemStack filterStack = this.func_70301_a(i + 5);
                    if (filterStack == null) continue;
                    filterEmpty = false;
                    if (!iStack.func_77969_a(filterStack)) continue;
                    return true;
                }
                return filterEmpty;
            }
            case CREATIVE_TAB: {
                try {
                    int itemCreativeTabIndex;
                    int n = itemCreativeTabIndex = iStack.func_77973_b().func_77640_w() != null ? iStack.func_77973_b().func_77640_w().func_78021_a() : -1;
                    if (itemCreativeTabIndex == this.creativeTabID) {
                        return true;
                    }
                }
                catch (Throwable e) {
                    this.filterMode = EnumFilterMode.NAME_BEGINS;
                }
                return false;
            }
            case NAME_BEGINS: {
                return iStack.func_82833_r().toLowerCase().startsWith(this.itemNameFilter.toLowerCase());
            }
            case NAME_CONTAINS: {
                return iStack.func_82833_r().toLowerCase().contains(this.itemNameFilter.toLowerCase());
            }
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public boolean isGuiUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.inputProgress == 40 && j == this.getRotation().getOpposite().ordinal() && this.redstoneAllows();
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.outputProgress == 40 && j == this.getRotation().ordinal();
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 1) {
            this.filterMode = this.filterMode.ordinal() >= EnumFilterMode.values().length - 1 ? EnumFilterMode.ITEM : EnumFilterMode.values()[this.filterMode.ordinal() + 1];
            this.func_94041_b(0, new ItemStack(Items.field_151055_y));
        } else if (guiID == 2) {
            ++this.creativeTabID;
            if (this.creativeTabID == 5 || this.creativeTabID == 11) {
                ++this.creativeTabID;
            }
            if (this.creativeTabID >= CreativeTabs.field_78032_a.length) {
                this.creativeTabID = 0;
            }
        } else if (guiID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.itemNameFilter = text;
    }

    @Override
    public String getText(int textFieldID) {
        return this.itemNameFilter;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public static enum EnumFilterMode {
        ITEM,
        CREATIVE_TAB,
        NAME_BEGINS,
        NAME_CONTAINS;

    }

    public static enum EnumInterfaceMode {
        NONE,
        IMPORT,
        EXPORT;

    }
}

