/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.inventory.SyncedField;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescPacketHandler;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.IDescSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.NetworkUtils;
import pneumaticCraft.common.network.PacketDescription;
import pneumaticCraft.common.thirdparty.computercraft.ILuaMethod;
import pneumaticCraft.common.thirdparty.computercraft.LuaMethod;
import pneumaticCraft.common.tileentity.IGUIButtonSensitive;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.common.util.TileEntityCache;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class TileEntityBase
extends TileEntity
implements IGUIButtonSensitive,
IDescSynced,
IPeripheral {
    protected boolean firstRun = true;
    private int[] upgradeSlots;
    private boolean descriptionPacketScheduled;
    private List<SyncedField> descriptionFields;
    protected int poweredRedstone;
    private TileEntityCache[] tileCache;
    protected List<ILuaMethod> luaMethods = new ArrayList<ILuaMethod>();

    public TileEntityBase() {
        this.addLuaMethods();
    }

    public TileEntityBase(int ... upgradeSlots) {
        this();
        this.upgradeSlots = upgradeSlots;
    }

    public Packet func_145844_m() {
        return DescPacketHandler.getPacket(new PacketDescription(this));
    }

    protected double getPacketDistance() {
        return 64.0;
    }

    @Override
    public List<SyncedField> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            for (SyncedField field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    public void sendDescriptionPacket() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void scheduleDescriptionPacket() {
        this.descriptionPacketScheduled = true;
    }

    public void sendDescPacket(double maxPacketDistance) {
        NetworkHandler.sendToAllAround((IMessage)new PacketDescription(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, maxPacketDistance));
    }

    public void func_145845_h() {
        if (this.firstRun && !this.field_145850_b.field_72995_K) {
            this.onFirstServerUpdate();
            this.onNeighborTileUpdate();
            this.onNeighborBlockUpdate();
        }
        this.firstRun = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this instanceof IHeatExchanger) {
                ((IHeatExchanger)((Object)this)).getHeatExchangerLogic(ForgeDirection.UNKNOWN).update();
            }
            if (this.descriptionFields == null) {
                this.descriptionPacketScheduled = true;
            }
            for (SyncedField field : this.getDescriptionFields()) {
                if (!field.update()) continue;
                this.descriptionPacketScheduled = true;
            }
            if (this.descriptionPacketScheduled) {
                this.descriptionPacketScheduled = false;
                this.sendDescriptionPacket();
            }
        }
    }

    protected void onFirstServerUpdate() {
        this.initializeIfHeatExchanger();
    }

    protected void updateNeighbours() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void onBlockRotated() {
    }

    protected void rerenderChunk() {
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return false;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeToPacket(tag);
        if (this instanceof IHeatExchanger) {
            ((IHeatExchanger)((Object)this)).getHeatExchangerLogic(ForgeDirection.UNKNOWN).writeToNBT(tag);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readFromPacket(tag);
        if (this instanceof IHeatExchanger) {
            ((IHeatExchanger)((Object)this)).getHeatExchangerLogic(ForgeDirection.UNKNOWN).readFromNBT(tag);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.scheduleDescriptionPacket();
    }

    @Override
    public void onDescUpdate() {
        if (this.shouldRerenderChunkOnDescUpdate()) {
            this.rerenderChunk();
        }
    }

    public void onGuiUpdate() {
    }

    public ForgeDirection getRotation() {
        return ForgeDirection.getOrientation((int)this.func_145832_p());
    }

    public int getUpgrades(int upgradeDamage) {
        return this.getUpgrades(upgradeDamage, this instanceof IPneumaticMachine ? ((IPneumaticMachine)((Object)this)).getAirHandler().getUpgradeSlots() : this.getUpgradeSlots());
    }

    protected int getUpgrades(int upgradeDamage, int ... upgradeSlots) {
        int upgrades = 0;
        IInventory inv = null;
        if (this instanceof IInventory) {
            inv = (IInventory)this;
        }
        if (inv == null && this instanceof TileEntityPneumaticBase && ((TileEntityPneumaticBase)this).parentTile instanceof IInventory) {
            inv = (IInventory)((TileEntityPneumaticBase)this).parentTile;
        }
        if (inv != null) {
            for (int i : upgradeSlots) {
                if (inv.func_70301_a(i) == null || inv.func_70301_a(i).func_77973_b() != Itemss.machineUpgrade || inv.func_70301_a(i).func_77960_j() != upgradeDamage) continue;
                upgrades += inv.func_70301_a((int)i).field_77994_a;
            }
        }
        return upgrades;
    }

    protected float getSpeedMultiplierFromUpgrades() {
        return this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots());
    }

    protected float getSpeedUsageMultiplierFromUpgrades() {
        return this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots());
    }

    public float getSpeedMultiplierFromUpgrades(int[] upgradeSlots) {
        return (float)Math.pow(1.5, Math.min(10, this.getUpgrades(5, upgradeSlots)));
    }

    protected float getSpeedUsageMultiplierFromUpgrades(int[] upgradeSlots) {
        return (float)Math.pow(1.8f, Math.min(10, this.getUpgrades(5, upgradeSlots)));
    }

    @Optional.Method(modid="IC2")
    protected int getIC2Upgrades(String ic2ItemKey, int[] upgradeSlots) {
        ItemStack itemStack = IC2Items.getItem((String)ic2ItemKey);
        if (itemStack == null) {
            return 0;
        }
        int upgrades = 0;
        if (this instanceof IInventory) {
            IInventory inv = (IInventory)this;
            for (int i : upgradeSlots) {
                if (inv.func_70301_a(i) == null || inv.func_70301_a(i).func_77973_b() != itemStack.func_77973_b()) continue;
                upgrades += inv.func_70301_a((int)i).field_77994_a;
            }
        }
        return upgrades;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
    }

    public boolean isGuiUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void setUpgradeSlots(int ... upgradeSlots) {
        this.upgradeSlots = upgradeSlots;
    }

    public int[] getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, ItemStack[] stacks) {
        TileEntityBase.writeInventoryToNBT(tag, stacks, "Items");
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, IInventory inventory, String tagName) {
        ItemStack[] stacks = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = inventory.func_70301_a(i);
        }
        TileEntityBase.writeInventoryToNBT(tag, stacks, tagName);
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, ItemStack[] stacks, String tagName) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            stacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, ItemStack[] stacks) {
        TileEntityBase.readInventoryFromNBT(tag, stacks, "Items");
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, IInventory inventory, String tagName) {
        ItemStack[] stacks = new ItemStack[inventory.func_70302_i_()];
        TileEntityBase.readInventoryFromNBT(tag, stacks, tagName);
        for (int i = 0; i < stacks.length; ++i) {
            inventory.func_70299_a(i, stacks[i]);
        }
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, ItemStack[] stacks, String tagName) {
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = null;
        }
        NBTTagList tagList = tag.func_150295_c(tagName, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= stacks.length) continue;
            stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
    }

    public void onNeighborTileUpdate() {
        this.initializeIfHeatExchanger();
        for (TileEntityCache cache : this.getTileCache()) {
            cache.update();
        }
    }

    public TileEntityCache[] getTileCache() {
        if (this.tileCache == null) {
            this.tileCache = TileEntityCache.getDefaultCache(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.tileCache;
    }

    public void onNeighborBlockUpdate() {
        this.poweredRedstone = PneumaticCraftUtils.getRedstoneLevel(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.initializeIfHeatExchanger();
    }

    public boolean redstoneAllows() {
        if (this.field_145850_b.field_72995_K) {
            this.onNeighborBlockUpdate();
        }
        switch (((IRedstoneControl)((Object)this)).getRedstoneMode()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.poweredRedstone > 0;
            }
            case 2: {
                return this.poweredRedstone == 0;
            }
        }
        return false;
    }

    protected void initializeIfHeatExchanger() {
        if (this instanceof IHeatExchanger) {
            this.initializeHeatExchanger(((IHeatExchanger)((Object)this)).getHeatExchangerLogic(ForgeDirection.UNKNOWN), this.getConnectedHeatExchangerSides());
        }
    }

    protected void initializeHeatExchanger(IHeatExchangerLogic heatExchanger, ForgeDirection ... connectedSides) {
        heatExchanger.initializeAsHull(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, connectedSides);
    }

    protected ForgeDirection[] getConnectedHeatExchangerSides() {
        return new ForgeDirection[0];
    }

    public void autoExportLiquid() {
        FluidStack extractedStack = ((IFluidHandler)this).drain(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, false);
        if (extractedStack != null) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te = this.getTileCache()[d.ordinal()].getTileEntity();
                if (!(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(d.getOpposite(), extractedStack.getFluid())) continue;
                int filledAmount = ((IFluidHandler)te).fill(d.getOpposite(), extractedStack, true);
                ((IFluidHandler)this).drain(ForgeDirection.UNKNOWN, filledAmount, true);
                extractedStack.amount -= filledAmount;
                if (extractedStack.amount <= 0) break;
            }
        }
    }

    @Override
    public IDescSynced.Type getSyncType() {
        return IDescSynced.Type.TILE_ENTITY;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    protected void processFluidItem(int inputSlot, int outputSlot) {
        IInventory inv = (IInventory)this;
        IFluidHandler fluidHandler = (IFluidHandler)this;
        FluidTankInfo tankInfo = fluidHandler.getTankInfo(ForgeDirection.UNKNOWN)[0];
        if (inv.func_70301_a(inputSlot) != null) {
            ItemStack fluidContainer = inv.func_70301_a(inputSlot);
            if (tankInfo.fluid == null || tankInfo.fluid.isFluidEqual(fluidContainer)) {
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fluidContainer);
                int amount = 1000;
                if (fluid == null) {
                    int availableSpace;
                    IFluidContainerItem containerItem;
                    if (fluidContainer.func_77973_b() instanceof IFluidContainerItem && (fluid = (containerItem = (IFluidContainerItem)fluidContainer.func_77973_b()).getFluid(fluidContainer)) != null && fluidHandler.canFill(ForgeDirection.UNKNOWN, fluid.getFluid()) && (availableSpace = tankInfo.capacity - (tankInfo.fluid != null ? tankInfo.fluid.amount : 0)) >= (amount = fluid != null ? fluid.amount : 0)) {
                        ItemStack singleFuelItem = fluidContainer.func_77946_l();
                        singleFuelItem.field_77994_a = 1;
                        FluidStack drainedStack = containerItem.drain(singleFuelItem, availableSpace, true);
                        if (fluidContainer.field_77994_a == 1 || inv.func_70301_a(outputSlot) == null || this.canStack(singleFuelItem, inv.func_70301_a(outputSlot))) {
                            fluidHandler.fill(ForgeDirection.UNKNOWN, drainedStack, true);
                            if (fluidContainer.field_77994_a == 1) {
                                inv.func_70299_a(inputSlot, singleFuelItem);
                            } else {
                                --inv.func_70301_a((int)inputSlot).field_77994_a;
                                if (inv.func_70301_a(outputSlot) == null) {
                                    inv.func_70299_a(outputSlot, singleFuelItem);
                                } else {
                                    ++inv.func_70301_a((int)outputSlot).field_77994_a;
                                }
                            }
                        }
                    }
                } else if (fluidHandler.canFill(ForgeDirection.UNKNOWN, fluid.getFluid()) && tankInfo.capacity - (tankInfo.fluid != null ? tankInfo.fluid.amount : 0) >= amount) {
                    FluidContainerRegistry.FluidContainerData[] allFluidData;
                    ItemStack returnedItem = null;
                    for (FluidContainerRegistry.FluidContainerData fluidData : allFluidData = FluidContainerRegistry.getRegisteredFluidContainerData()) {
                        if (!fluidData.filledContainer.func_77969_a(fluidContainer)) continue;
                        returnedItem = fluidData.emptyContainer;
                        break;
                    }
                    if (returnedItem == null || inv.func_70301_a(outputSlot) == null || this.canStack(returnedItem, inv.func_70301_a(outputSlot))) {
                        if (returnedItem != null) {
                            if (inv.func_70301_a(outputSlot) == null) {
                                inv.func_70299_a(outputSlot, returnedItem.func_77946_l());
                            } else {
                                inv.func_70301_a((int)outputSlot).field_77994_a += returnedItem.field_77994_a;
                            }
                        }
                        fluidHandler.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid.getFluid(), amount, fluid.tag), true);
                        --inv.func_70301_a((int)inputSlot).field_77994_a;
                        if (inv.func_70301_a((int)inputSlot).field_77994_a <= 0) {
                            inv.func_70299_a(inputSlot, null);
                        }
                    }
                }
            }
            if (fluidContainer.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)fluidContainer.func_77973_b()).getFluid(fluidContainer) == null && (inv.func_70301_a(outputSlot) == null || this.canStack(fluidContainer, inv.func_70301_a(outputSlot)))) {
                if (inv.func_70301_a(outputSlot) == null) {
                    inv.func_70299_a(outputSlot, fluidContainer);
                } else {
                    inv.func_70301_a((int)outputSlot).field_77994_a += fluidContainer.field_77994_a;
                }
                inv.func_70299_a(inputSlot, null);
            }
        }
    }

    private boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2) && stack1.field_77994_a + stack2.field_77994_a <= stack1.func_77976_d();
    }

    protected void addLuaMethods() {
        if (this instanceof IHeatExchanger) {
            final IHeatExchanger exchanger = (IHeatExchanger)((Object)this);
            this.luaMethods.add(new LuaMethod("getTemperature"){

                @Override
                public Object[] call(Object[] args) throws Exception {
                    if (args.length == 0) {
                        return new Object[]{exchanger.getHeatExchangerLogic(ForgeDirection.UNKNOWN).getTemperature()};
                    }
                    if (args.length == 1) {
                        IHeatExchangerLogic logic = exchanger.getHeatExchangerLogic(this.getDirForString((String)args[0]));
                        return new Object[]{logic != null ? logic.getTemperature() : 0.0};
                    }
                    throw new IllegalArgumentException("getTemperature method requires 0 or 1 argument (direction: up, down, east, west, north, south!");
                }
            });
        }
    }

    public String getType() {
        return this.func_145838_q().func_149739_a().substring(5);
    }

    public String[] getMethodNames() {
        String[] methodNames = new String[this.luaMethods.size()];
        for (int i = 0; i < methodNames.length; ++i) {
            methodNames[i] = this.luaMethods.get(i).getMethodName();
        }
        return methodNames;
    }

    public List<ILuaMethod> getLuaMethods() {
        return this.luaMethods;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            return this.luaMethods.get(method).call(arguments);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            return tother.func_145831_w().equals(this.field_145850_b) && tother.field_145851_c == this.field_145851_c && tother.field_145848_d == this.field_145848_d && tother.field_145849_e == this.field_145849_e;
        }
        return false;
    }
}

