/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.ItemAssemblyProgram;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.recipes.programs.AssemblyProgram;
import pneumaticCraft.common.tileentity.IAssemblyMachine;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IResettable;
import pneumaticCraft.common.tileentity.TileEntityAssemblyDrill;
import pneumaticCraft.common.tileentity.TileEntityAssemblyIOUnit;
import pneumaticCraft.common.tileentity.TileEntityAssemblyLaser;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityAssemblyController
extends TileEntityPneumaticBase
implements ISidedInventory,
IAssemblyMachine,
IMinWorkingPressure {
    private ItemStack[] inventory;
    @DescSynced
    public boolean[] sidesConnected = new boolean[6];
    public AssemblyProgram curProgram;
    private final int INVENTORY_SIZE = 5;
    @GuiSynced
    public boolean foundAllMachines;
    @GuiSynced
    private boolean foundDuplicateMachine;
    private boolean goingToHomePosition;
    @DescSynced
    public String displayedText = "";
    public static final int PROGRAM_INVENTORY_INDEX = 0;
    public static final int UPGRADE_SLOT_START = 1;
    public static final int UPGRADE_SLOT_END = 4;
    @DescSynced
    public boolean hasProblem;

    public TileEntityAssemblyController() {
        super(5.0f, 7.0f, 2000);
        this.inventory = new ItemStack[5];
        this.setUpgradeSlots(1, 2, 3, 4);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.firstRun) {
            this.updateConnections();
        }
        if (this.curProgram == null && !this.goingToHomePosition && this.inventory[0] != null && this.inventory[0].func_77973_b() == Itemss.assemblyProgram) {
            AssemblyProgram program;
            this.curProgram = program = ItemAssemblyProgram.getProgramFromItem(this.inventory[0].func_77960_j());
        } else if (this.curProgram != null && (this.inventory[0] == null || this.curProgram.getClass() != ItemAssemblyProgram.getProgramFromItem(this.inventory[0].func_77960_j()).getClass())) {
            this.curProgram = null;
            if (!this.field_145850_b.field_72995_K) {
                this.goingToHomePosition = true;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.displayedText = "Standby";
            if (this.getPressure(ForgeDirection.UNKNOWN) >= 3.5f && (this.curProgram != null || this.goingToHomePosition)) {
                List<IAssemblyMachine> machineList = this.getMachines();
                AssemblyProgram.EnumMachine[] requiredMachines = this.curProgram != null ? this.curProgram.getRequiredMachines() : AssemblyProgram.EnumMachine.values();
                TileEntityAssemblyDrill drill = null;
                TileEntityAssemblyLaser laser = null;
                TileEntityAssemblyIOUnit ioUnitImport = null;
                TileEntityAssemblyIOUnit ioUnitExport = null;
                TileEntityAssemblyPlatform platform = null;
                this.foundDuplicateMachine = false;
                boolean[] foundMachines = new boolean[requiredMachines.length];
                for (IAssemblyMachine machine : machineList) {
                    if (machine != this && machine instanceof TileEntityAssemblyController) {
                        this.foundDuplicateMachine = true;
                    }
                    block8: for (int i = 0; i < requiredMachines.length; ++i) {
                        switch (requiredMachines[i]) {
                            case DRILL: {
                                if (!(machine instanceof TileEntityAssemblyDrill)) continue block8;
                                if (drill != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                drill = (TileEntityAssemblyDrill)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case LASER: {
                                if (!(machine instanceof TileEntityAssemblyLaser)) continue block8;
                                if (laser != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                laser = (TileEntityAssemblyLaser)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case IO_UNIT_IMPORT: {
                                if (!(machine instanceof TileEntityAssemblyIOUnit) || ((TileEntityAssemblyIOUnit)machine).func_145832_p() != 0) continue block8;
                                if (ioUnitImport != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                ioUnitImport = (TileEntityAssemblyIOUnit)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case IO_UNIT_EXPORT: {
                                if (!(machine instanceof TileEntityAssemblyIOUnit) || ((TileEntityAssemblyIOUnit)machine).func_145832_p() != 1) continue block8;
                                if (ioUnitExport != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                ioUnitExport = (TileEntityAssemblyIOUnit)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case PLATFORM: {
                                if (!(machine instanceof TileEntityAssemblyPlatform)) continue block8;
                                if (platform != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                platform = (TileEntityAssemblyPlatform)machine;
                                foundMachines[i] = true;
                            }
                        }
                    }
                }
                this.foundAllMachines = true;
                for (Object foundMachine : (Object)foundMachines) {
                    if (foundMachine != false) continue;
                    this.foundAllMachines = false;
                    break;
                }
                if ((this.foundAllMachines || this.curProgram == null) && !this.foundDuplicateMachine) {
                    boolean useAir;
                    if (this.curProgram != null) {
                        useAir = this.curProgram.executeStep(this, platform, ioUnitImport, ioUnitExport, drill, laser);
                        if (useAir) {
                            this.displayedText = "Running...";
                        }
                    } else {
                        useAir = true;
                        this.goToHomePosition(platform, ioUnitImport, ioUnitExport, drill, laser);
                        this.displayedText = "Resetting...";
                    }
                    if (useAir) {
                        this.addAir(-((int)(2.0f * this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots()))), ForgeDirection.UNKNOWN);
                    }
                    float speedMultiplier = this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots());
                    for (IAssemblyMachine machine : machineList) {
                        machine.setSpeed(speedMultiplier);
                    }
                }
            }
            this.hasProblem = this.hasProblem();
        }
        super.func_145845_h();
    }

    private void goToHomePosition(TileEntityAssemblyPlatform platform, TileEntityAssemblyIOUnit ioUnitImport, TileEntityAssemblyIOUnit ioUnitExport, TileEntityAssemblyDrill drill, TileEntityAssemblyLaser laser) {
        boolean resetDone = true;
        for (IResettable machine : new IResettable[]{drill, laser, ioUnitImport, platform, ioUnitExport}) {
            if (machine == null || machine.reset()) continue;
            resetDone = false;
            if (machine != platform || ioUnitExport == null) break;
            ioUnitExport.pickupItem(null);
            break;
        }
        this.goingToHomePosition = !this.foundAllMachines || !resetDone;
    }

    public void addProblems(List<String> problemList) {
        if (this.getPressure(ForgeDirection.UNKNOWN) < 3.5f) {
            problemList.add(EnumChatFormatting.GRAY + "No sufficient pressure.");
            problemList.add(EnumChatFormatting.BLACK + "Add pressure.");
        }
        if (this.curProgram == null) {
            problemList.add(EnumChatFormatting.GRAY + "There's no program to run.");
            problemList.add(EnumChatFormatting.BLACK + "Insert an Assembly Program.");
        } else if (this.foundDuplicateMachine) {
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.GRAY + "Controller found a duplicate machine!", 26));
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.BLACK + "Remove it so there is one machine of each type.", 26));
        } else if (this.foundAllMachines) {
            this.curProgram.addProgramProblem(problemList);
        } else {
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.GRAY + "Not all machines required for this program are available.", 26));
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.BLACK + "Connect up the other required machines.", 26));
        }
    }

    public boolean hasProblem() {
        ArrayList<String> textList = null;
        if (this.curProgram != null) {
            textList = new ArrayList<String>();
            this.curProgram.addProgramProblem(textList);
        }
        return !this.foundAllMachines || this.foundDuplicateMachine || this.getPressure(ForgeDirection.UNKNOWN) < 3.5f || this.curProgram == null || textList.size() > 0;
    }

    public List<IAssemblyMachine> getMachines() {
        ArrayList<IAssemblyMachine> machineList = new ArrayList<IAssemblyMachine>();
        this.getMachines(machineList, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return machineList;
    }

    public boolean areAllMachinesDone(List<IAssemblyMachine> machineList) {
        for (IAssemblyMachine machine : machineList) {
            if (machine.isIdle()) continue;
            return false;
        }
        return true;
    }

    private void getMachines(List<IAssemblyMachine> machineList, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te;
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || !((te = this.field_145850_b.func_147438_o(x + dir.offsetX, y, z + dir.offsetZ)) instanceof IAssemblyMachine) || machineList.contains(te)) continue;
            machineList.add((IAssemblyMachine)te);
            this.getMachines(machineList, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
    }

    public void updateConnections() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            this.sidesConnected[direction.ordinal()] = te instanceof IPneumaticMachine ? ((IPneumaticMachine)te).isConnectedTo(direction.getOpposite()) : false;
        }
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return Blockss.assemblyController.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.goingToHomePosition = tag.func_74767_n("goingToHomePosition");
        this.foundAllMachines = tag.func_74767_n("foundAllMachines");
        this.foundDuplicateMachine = tag.func_74767_n("foundDuplicate");
        this.displayedText = tag.func_74779_i("displayedText");
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = tag.func_74767_n("sideConnected" + i);
        }
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        if (this.inventory[0] != null) {
            this.curProgram = ItemAssemblyProgram.getProgramFromItem(this.inventory[0].func_77960_j());
            if (this.curProgram != null) {
                this.curProgram.readFromNBT(tag);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("goingToHomePosition", this.goingToHomePosition);
        tag.func_74757_a("foundAllMachines", this.foundAllMachines);
        tag.func_74757_a("foundDuplicate", this.foundDuplicateMachine);
        tag.func_74778_a("displayedText", this.displayedText);
        if (this.curProgram != null) {
            this.curProgram.writeToNBT(tag);
        }
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i > 0) {
            return itemstack != null && itemstack.func_77973_b() == Itemss.machineUpgrade;
        }
        return itemstack != null && itemstack.func_77973_b() == Itemss.assemblyProgram;
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{1, 2, 3, 4};
        }
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean isIdle() {
        return true;
    }

    @Override
    public void setSpeed(float speed) {
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.5f;
    }
}

