/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.semiblock;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import pneumaticCraft.common.inventory.SyncedField;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.IDescSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.NetworkUtils;
import pneumaticCraft.common.network.PacketDescription;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockManager;
import pneumaticCraft.common.tileentity.IGUIButtonSensitive;

public class SemiBlockBasic
implements ISemiBlock,
IDescSynced,
IGUIButtonSensitive {
    protected World world;
    protected ChunkPosition pos;
    private boolean isInvalid;
    private TileEntity cachedTE;
    private List<SyncedField> descriptionFields;
    private boolean descriptionPacketScheduled;

    @Override
    public void initialize(World world, ChunkPosition pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void update() {
        if (!this.world.field_72995_K && !this.canStay()) {
            this.drop();
        }
        if (!this.world.field_72995_K) {
            if (this.descriptionFields == null) {
                this.descriptionPacketScheduled = true;
            }
            for (SyncedField field : this.getDescriptionFields()) {
                if (!field.update()) continue;
                this.descriptionPacketScheduled = true;
            }
            if (this.descriptionPacketScheduled) {
                this.descriptionPacketScheduled = false;
                this.sendDescriptionPacket();
            }
        }
    }

    private void sendDescriptionPacket() {
        NetworkHandler.sendToAllAround(this.getDescriptionPacket(), this.world);
    }

    @Override
    public PacketDescription getDescriptionPacket() {
        return new PacketDescription(this);
    }

    protected void drop() {
        SemiBlockManager.getInstance(this.world).breakSemiBlock(this.world, this.pos.field_151329_a, this.pos.field_151327_b, this.pos.field_151328_c);
    }

    protected boolean isAirBlock() {
        return this.world.func_147437_c(this.pos.field_151329_a, this.pos.field_151327_b, this.pos.field_151328_c);
    }

    public Block getBlock() {
        return this.world.func_147439_a(this.pos.field_151329_a, this.pos.field_151327_b, this.pos.field_151328_c);
    }

    public TileEntity getTileEntity() {
        if (this.cachedTE == null || this.cachedTE.func_145837_r()) {
            this.cachedTE = this.world.func_147438_o(this.pos.field_151329_a, this.pos.field_151327_b, this.pos.field_151328_c);
        }
        return this.cachedTE;
    }

    @Override
    public void invalidate() {
        this.isInvalid = true;
    }

    @Override
    public boolean isInvalid() {
        return this.isInvalid;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public ChunkPosition getPos() {
        return this.pos;
    }

    @Override
    public void addDrops(List<ItemStack> drops) {
        Item item = SemiBlockManager.getItemForSemiBlock(this);
        if (item != null) {
            drops.add(new ItemStack(item));
        }
    }

    @Override
    public boolean canPlace() {
        return true;
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack) {
    }

    public boolean canStay() {
        return this.canPlace();
    }

    @Override
    public boolean onRightClickWithConfigurator(EntityPlayer player) {
        return false;
    }

    public void addWailaTooltip(List<String> curInfo, NBTTagCompound tag) {
        curInfo.add(EnumChatFormatting.YELLOW + "[" + StatCollector.func_74838_a((String)(SemiBlockManager.getItemForSemiBlock(this).func_77658_a() + ".name")) + "]");
    }

    public void addWailaInfoToTag(NBTTagCompound tag) {
    }

    @Override
    public IDescSynced.Type getSyncType() {
        return IDescSynced.Type.SEMI_BLOCK;
    }

    @Override
    public List<SyncedField> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            for (SyncedField field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
    }

    @Override
    public int getX() {
        return this.pos.field_151329_a;
    }

    @Override
    public int getY() {
        return this.pos.field_151327_b;
    }

    @Override
    public int getZ() {
        return this.pos.field_151328_c;
    }

    @Override
    public void onDescUpdate() {
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
    }
}

