/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetAreaShow;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.ai.StringFilterEntitySelector;
import pneumaticCraft.common.progwidgets.IAreaProvider;
import pneumaticCraft.common.progwidgets.IEntityProvider;
import pneumaticCraft.common.progwidgets.IItemFiltering;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetItemFilter;
import pneumaticCraft.common.progwidgets.ProgWidgetString;

public abstract class ProgWidgetAreaItemBase
extends ProgWidget
implements IAreaProvider,
IEntityProvider,
IItemFiltering,
IVariableWidget {
    private List<ChunkPosition> areaListCache;
    private Set<ChunkPosition> areaSetCache;
    private Map<String, ChunkPosition> areaVariableStates;
    protected DroneAIManager aiManager;
    private boolean canCache = true;

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetItemFilter.class};
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add("gui.progWidget.area.error.noArea");
        }
    }

    public static IBlockAccess getCache(Collection<ChunkPosition> area, World world) {
        int maxZ;
        int maxY;
        int maxX;
        if (area.size() == 0) {
            return world;
        }
        Iterator<ChunkPosition> iterator = area.iterator();
        ChunkPosition p = iterator.next();
        int minX = maxX = p.field_151329_a;
        int minY = maxY = p.field_151327_b;
        int minZ = maxZ = p.field_151328_c;
        while (iterator.hasNext()) {
            p = iterator.next();
            minX = Math.min(minX, p.field_151329_a);
            minY = Math.min(minY, p.field_151327_b);
            minZ = Math.min(minZ, p.field_151328_c);
            maxX = Math.max(maxX, p.field_151329_a);
            maxY = Math.max(maxY, p.field_151327_b);
            maxZ = Math.max(maxZ, p.field_151328_c);
        }
        return new ChunkCache(world, minX, minY, minZ, maxX, maxY, maxZ, 0);
    }

    public List<ChunkPosition> getCachedAreaList() {
        if (this.areaListCache != null) {
            if (!this.canCache || this.updateVariables()) {
                this.areaSetCache = new HashSet<ChunkPosition>(this.areaListCache.size());
                this.getArea(this.areaSetCache);
                this.areaListCache = new ArrayList<ChunkPosition>(this.areaSetCache.size());
                this.areaListCache.addAll(this.areaSetCache);
            }
        } else {
            this.areaSetCache = new HashSet<ChunkPosition>();
            this.getArea(this.areaSetCache);
            this.areaListCache = new ArrayList<ChunkPosition>(this.areaSetCache.size());
            this.areaListCache.addAll(this.areaSetCache);
            this.initializeVariableCache();
        }
        return this.areaListCache;
    }

    public Set<ChunkPosition> getCachedAreaSet() {
        this.getCachedAreaList();
        return this.areaSetCache;
    }

    private void initializeVariableCache() {
        this.areaVariableStates = new HashMap<String, ChunkPosition>();
        ProgWidgetArea whitelistWidget = (ProgWidgetArea)this.getConnectedParameters()[0];
        ProgWidgetArea blacklistWidget = (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length];
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            if (widget.type == ProgWidgetArea.EnumAreaType.RANDOM) {
                this.canCache = false;
            }
            if (!widget.getCoord1Variable().equals("")) {
                this.areaVariableStates.put(widget.getCoord1Variable(), this.aiManager.getCoordinate(widget.getCoord1Variable()));
            }
            if (!widget.getCoord2Variable().equals("")) {
                this.areaVariableStates.put(widget.getCoord2Variable(), this.aiManager.getCoordinate(widget.getCoord2Variable()));
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            if (widget.type == ProgWidgetArea.EnumAreaType.RANDOM) {
                this.canCache = false;
            }
            if (!widget.getCoord1Variable().equals("")) {
                this.areaVariableStates.put(widget.getCoord1Variable(), this.aiManager.getCoordinate(widget.getCoord1Variable()));
            }
            if (!widget.getCoord2Variable().equals("")) {
                this.areaVariableStates.put(widget.getCoord2Variable(), this.aiManager.getCoordinate(widget.getCoord2Variable()));
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
    }

    private boolean updateVariables() {
        boolean varChanged = false;
        for (Map.Entry<String, ChunkPosition> entry : this.areaVariableStates.entrySet()) {
            ChunkPosition newValue = this.aiManager.getCoordinate(entry.getKey());
            if (newValue.equals((Object)entry.getValue())) continue;
            varChanged = true;
            entry.setValue(newValue);
        }
        return varChanged;
    }

    @Override
    public void getArea(Set<ChunkPosition> area) {
        ProgWidgetAreaItemBase.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length]);
    }

    public static void getArea(Set<ChunkPosition> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            widget.getArea(area);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        HashSet<ChunkPosition> blacklistedArea = new HashSet<ChunkPosition>();
        while (widget != null) {
            widget.getArea(blacklistedArea);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        area.removeAll(blacklistedArea);
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return this.isItemValidForFilters(item, -1);
    }

    public boolean isItemValidForFilters(ItemStack item, int blockMetadata) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidget.getConnectedWidgetList(this, 1), ProgWidget.getConnectedWidgetList(this, this.getParameters().length + 1), blockMetadata);
    }

    public boolean isItemFilterEmpty() {
        return this.getConnectedParameters()[1] == null && this.getConnectedParameters()[3] == null;
    }

    public List<Entity> getEntitiesInArea(World world, IEntitySelector filter) {
        return ProgWidgetAreaItemBase.getEntitiesInArea((ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length], world, filter, null);
    }

    public static List<Entity> getValidEntities(World world, IProgWidget widget) {
        StringFilterEntitySelector whitelistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[1], true);
        StringFilterEntitySelector blacklistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[widget.getParameters().length + 1], false);
        return ProgWidgetAreaItemBase.getEntitiesInArea((ProgWidgetArea)widget.getConnectedParameters()[0], (ProgWidgetArea)widget.getConnectedParameters()[widget.getParameters().length], world, whitelistFilter, blacklistFilter);
    }

    @Override
    public List<Entity> getValidEntities(World world) {
        return ProgWidgetAreaItemBase.getValidEntities(world, this);
    }

    public static boolean isEntityValid(Entity entity, IProgWidget widget) {
        StringFilterEntitySelector whitelistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[1], true);
        StringFilterEntitySelector blacklistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[widget.getParameters().length + 1], false);
        return whitelistFilter.func_82704_a(entity) && !blacklistFilter.func_82704_a(entity);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        return ProgWidgetAreaItemBase.isEntityValid(entity, this);
    }

    public static StringFilterEntitySelector getEntityFilter(ProgWidgetString widget, boolean allowEntityIfNoFilter) {
        StringFilterEntitySelector filter = new StringFilterEntitySelector();
        if (widget != null) {
            while (widget != null) {
                filter.addEntry(widget.string);
                widget = (ProgWidgetString)widget.getConnectedParameters()[0];
            }
        } else if (allowEntityIfNoFilter) {
            filter.setFilter("");
        }
        return filter;
    }

    public static List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, World world, IEntitySelector whitelistFilter, IEntitySelector blacklistFilter) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, whitelistFilter));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            entities.removeAll(widget.getEntitiesWithinArea(world, whitelistFilter));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (blacklistFilter != null) {
            Entity[] entArray;
            for (Entity entity : entArray = entities.toArray(new Entity[entities.size()])) {
                if (!blacklistFilter.func_82704_a(entity)) continue;
                entities.remove(entity);
            }
        }
        return new ArrayList<Entity>(entities);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetAreaShow<ProgWidgetAreaItemBase>(this, guiProgrammer);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
    }
}

