/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import pneumaticCraft.client.gui.widget.WidgetAmadronOffer;
import pneumaticCraft.common.config.AmadronOfferSettings;
import pneumaticCraft.common.network.PacketAbstractAmadronTrade;
import pneumaticCraft.common.recipes.AmadronOfferCustom;

public class PacketAmadronTradeNotifyDeal
extends PacketAbstractAmadronTrade<PacketAmadronTradeNotifyDeal> {
    private int offerAmount;
    private String buyingPlayer;

    public PacketAmadronTradeNotifyDeal() {
    }

    public PacketAmadronTradeNotifyDeal(AmadronOfferCustom offer, int offerAmount, String buyingPlayer) {
        super(offer);
        this.offerAmount = offerAmount;
        this.buyingPlayer = buyingPlayer;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.offerAmount = buf.readInt();
        this.buyingPlayer = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.offerAmount);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.buyingPlayer);
    }

    @Override
    public void handleClientSide(PacketAmadronTradeNotifyDeal message, EntityPlayer player) {
        if (AmadronOfferSettings.notifyOfDealMade) {
            player.func_145747_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"message.amadron.playerBought", (Object[])new Object[]{message.buyingPlayer, WidgetAmadronOffer.getStringForObject(message.getOffer().getOutput(), message.offerAmount), WidgetAmadronOffer.getStringForObject(message.getOffer().getInput(), message.offerAmount)})));
        }
    }

    @Override
    public void handleServerSide(PacketAmadronTradeNotifyDeal message, EntityPlayer player) {
    }
}

