/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.entity.living;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.client.C15PacketClientSettings;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.block.IPneumaticWrenchable;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableEntity;
import pneumaticCraft.api.drone.IPathNavigator;
import pneumaticCraft.api.drone.IPathfindHandler;
import pneumaticCraft.api.tileentity.IManoMeasurable;
import pneumaticCraft.client.render.RenderProgressingLine;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.ai.DroneGoToChargingStation;
import pneumaticCraft.common.ai.DroneGoToOwner;
import pneumaticCraft.common.ai.DroneMoveHelper;
import pneumaticCraft.common.ai.EntityPathNavigateDrone;
import pneumaticCraft.common.ai.FakePlayerItemInWorldManager;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.entity.living.DebugEntry;
import pneumaticCraft.common.entity.living.EntityDroneBase;
import pneumaticCraft.common.entity.living.IInventoryHolder;
import pneumaticCraft.common.item.ItemGPSTool;
import pneumaticCraft.common.item.ItemProgrammingPuzzle;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.minigun.Minigun;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSendDroneDebugEntry;
import pneumaticCraft.common.network.PacketShowWireframe;
import pneumaticCraft.common.network.PacketSyncDroneEntityProgWidgets;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetGoToLocation;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;
import pneumaticCraft.common.tileentity.TileEntityPlasticMixer;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class EntityDrone
extends EntityDroneBase
implements IManoMeasurable,
IInventoryHolder,
IPneumaticWrenchable,
IEntityAdditionalSpawnData,
IHackableEntity,
IDroneBase {
    private static final HashMap<String, Integer> colorMap = new HashMap();
    public boolean isChangingCurrentStack;
    private IInventory inventory = new InventoryDrone("Drone Inventory", true, 0);
    private final FluidTank tank = new FluidTank(Integer.MAX_VALUE);
    private ItemStack[] upgradeInventory = new ItemStack[9];
    private final int[] emittingRedstoneValues = new int[6];
    private float propSpeed;
    private static final float LASER_EXTEND_SPEED = 0.05f;
    protected float currentAir;
    private float volume;
    private RenderProgressingLine targetLine;
    private RenderProgressingLine oldTargetLine;
    public List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private DroneFakePlayer fakePlayer;
    public String playerName = "Drone";
    private String playerUUID;
    public DroneGoToChargingStation chargeAI;
    public DroneGoToOwner gotoOwnerAI;
    private final DroneAIManager aiManager = new DroneAIManager(this);
    private boolean firstTick = true;
    public boolean naturallySpawned = true;
    public boolean hasLiquidImmunity;
    private double speed;
    private int lifeUpgrades;
    private int suffocationCounter = 40;
    private boolean isSuffocating;
    private boolean disabledByHacking;
    private boolean standby;
    private Minigun minigun;
    private AmadronOffer handlingOffer;
    private int offerTimes;
    private ItemStack usedTablet;
    private String buyingPlayer;
    private final SortedSet<DebugEntry> debugEntries = new TreeSet<DebugEntry>();
    private final Set<EntityPlayerMP> syncedPlayers = new HashSet<EntityPlayerMP>();

    public EntityDrone(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.35f);
        ReflectionHelper.setPrivateValue(EntityLiving.class, (Object)this, (Object)new EntityPathNavigateDrone(this, world), (String[])new String[]{"navigator", "field_70699_by"});
        ReflectionHelper.setPrivateValue(EntityLiving.class, (Object)this, (Object)((Object)new DroneMoveHelper(this)), (String[])new String[]{"moveHelper", "field_70765_h"});
        this.chargeAI = new DroneGoToChargingStation(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.chargeAI);
    }

    public EntityDrone(World world, EntityPlayer player) {
        this(world);
        this.playerUUID = player.func_146103_bH().getId().toString();
        this.playerName = player.func_70005_c_();
    }

    private void initializeFakePlayer() {
        this.fakePlayer = new DroneFakePlayer((WorldServer)this.field_70170_p, new GameProfile(this.playerUUID != null ? UUID.fromString(this.playerUUID) : null, this.playerName), new FakePlayerItemInWorldManager(this.field_70170_p, this.fakePlayer, this), this);
        this.fakePlayer.field_71135_a = new NetHandlerPlayServer(MinecraftServer.func_71276_C(), new NetworkManager(false), (EntityPlayerMP)this.fakePlayer);
        this.fakePlayer.field_71071_by = new InventoryFakePlayer((EntityPlayer)this.fakePlayer);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_82709_a(25, 5);
        this.field_70180_af.func_75682_a(26, (Object)"Main");
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getRange());
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.getFakePlayer().func_70005_c_());
    }

    public void readSpawnData(ByteBuf data) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)data);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    protected String func_70621_aR() {
        return "pneumaticcraft:drone.hurt";
    }

    protected String func_70673_aS() {
        return "pneumaticcraft:drone.death";
    }

    public void func_70071_h_() {
        int z;
        boolean enabled;
        if (this.firstTick) {
            this.firstTick = false;
            this.volume = 12000 + this.getUpgrades(0) * 5000;
            boolean bl = this.hasLiquidImmunity = this.getUpgrades(9) > 0;
            if (this.hasLiquidImmunity) {
                ((EntityPathNavigateDrone)this.getPathNavigator()).pathThroughLiquid = true;
            }
            this.speed = 0.1 + (double)Math.min(10, this.getUpgrades(5)) * 0.01;
            this.lifeUpgrades = this.getUpgrades(2);
            if (!this.field_70170_p.field_72995_K) {
                this.setHasMinigun(this.getUpgrades(3) > 0);
            }
            this.aiManager.setWidgets(this.progWidgets);
        }
        boolean bl = enabled = !this.disabledByHacking && this.getPressure(null) > 0.01f;
        if (!this.field_70170_p.field_72995_K) {
            int interval;
            this.setAccelerating(!this.standby && enabled);
            if (this.isAccelerating()) {
                this.field_70143_R = 0.0f;
            }
            if (this.lifeUpgrades > 0 && ((interval = 10 / this.lifeUpgrades) == 0 || this.field_70173_aa % interval == 0)) {
                this.func_70691_i(1.0f);
            }
            if (!this.isSuffocating) {
                this.suffocationCounter = 40;
            }
            this.isSuffocating = false;
            PathEntity path = this.func_70661_as().func_75505_d();
            if (path != null) {
                PathPoint target = path.func_75870_c();
                if (target != null) {
                    this.setTargetedBlock(target.field_75839_a, target.field_75837_b, target.field_75838_c);
                } else {
                    this.setTargetedBlock(0, 0, 0);
                }
            } else {
                this.setTargetedBlock(0, 0, 0);
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L) {
                this.updateSyncedPlayers();
            }
        } else {
            if (this.digLaser != null) {
                this.digLaser.update();
            }
            this.oldLaserExtension = this.laserExtension;
            this.laserExtension = this.getActiveProgramKey().equals("dig") ? Math.min(1.0f, this.laserExtension + 0.05f) : Math.max(0.0f, this.laserExtension - 0.05f);
            if (this.isAccelerating()) {
                int x = (int)Math.floor(this.field_70165_t);
                int y = (int)Math.floor(this.field_70163_u - 1.0);
                z = (int)Math.floor(this.field_70161_v);
                Block block = null;
                for (int i = 0; i < 3 && (block = this.field_70170_p.func_147439_a(x, y, z)).func_149688_o() == Material.field_151579_a; ++i) {
                    --y;
                }
                if (block.func_149688_o() != Material.field_151579_a) {
                    Vec3 vec = Vec3.func_72443_a((double)(this.field_70163_u - (double)y), (double)0.0, (double)0.0);
                    vec.func_72442_b((float)((double)this.field_70146_Z.nextFloat() * Math.PI * 2.0));
                    this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(x, y, z), this.field_70165_t + vec.field_72450_a, (double)(y + 1), this.field_70161_v + vec.field_72449_c, vec.field_72450_a, 0.0, vec.field_72449_c);
                }
            }
        }
        if (this.hasLiquidImmunity) {
            for (int x = (int)this.field_70165_t - 1; x <= (int)(this.field_70165_t + (double)this.field_70130_N); ++x) {
                for (int y = (int)this.field_70163_u - 1; y <= (int)(this.field_70163_u + (double)this.field_70131_O + 1.0); ++y) {
                    for (z = (int)this.field_70161_v - 2; z <= (int)(this.field_70161_v + (double)this.field_70130_N); ++z) {
                        if (!PneumaticCraftUtils.isBlockLiquid(this.field_70170_p.func_147439_a(x, y, z))) continue;
                        this.field_70170_p.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                    }
                }
            }
        }
        if (this.isAccelerating()) {
            this.field_70159_w *= 0.3;
            this.field_70181_x *= 0.3;
            this.field_70179_y *= 0.3;
            this.propSpeed = Math.min(1.0f, this.propSpeed + 0.04f);
            this.addAir(null, -1);
        } else {
            this.propSpeed = Math.max(0.0f, this.propSpeed - 0.04f);
        }
        this.oldPropRotation = this.propRotation;
        this.propRotation += this.propSpeed;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            for (int i = 0; i < 4; ++i) {
                this.getFakePlayer().field_71134_c.func_73075_a();
            }
        }
        super.func_70071_h_();
        if (this.hasMinigun()) {
            this.getMinigun().setAttackTarget(this.func_70638_az()).update(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (enabled) {
                this.aiManager.onUpdateTasks();
            }
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (this.getEmittingRedstone(d) <= 0) continue;
                if (!this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t + (double)(this.field_70130_N / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.field_70130_N / 2.0f)))) break;
                this.field_70170_p.func_147449_b((int)Math.floor(this.field_70165_t + (double)(this.field_70130_N / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.field_70130_N / 2.0f)), Blockss.droneRedstoneEmitter);
                break;
            }
        }
    }

    public ChunkPosition getTargetedBlock() {
        int x = this.field_70180_af.func_75679_c(14);
        int y = this.field_70180_af.func_75679_c(15);
        int z = this.field_70180_af.func_75679_c(16);
        return x != 0 || y != 0 || z != 0 ? new ChunkPosition(x, y, z) : null;
    }

    private void setTargetedBlock(int x, int y, int z) {
        this.field_70180_af.func_75692_b(14, (Object)x);
        this.field_70180_af.func_75692_b(15, (Object)y);
        this.field_70180_af.func_75692_b(16, (Object)z);
    }

    @Override
    public int getLaserColor() {
        if (colorMap.containsKey(this.func_94057_bL().toLowerCase())) {
            return colorMap.get(this.func_94057_bL().toLowerCase());
        }
        if (colorMap.containsKey(this.playerName.toLowerCase())) {
            return colorMap.get(this.playerName.toLowerCase());
        }
        return super.getLaserColor();
    }

    @Override
    protected ChunkPosition getDugBlock() {
        int x = this.field_70180_af.func_75679_c(18);
        int y = this.field_70180_af.func_75679_c(19);
        int z = this.field_70180_af.func_75679_c(20);
        return x != 0 || y != 0 || z != 0 ? new ChunkPosition(x, y, z) : null;
    }

    @Override
    public void setDugBlock(int x, int y, int z) {
        this.field_70180_af.func_75692_b(18, (Object)x);
        this.field_70180_af.func_75692_b(19, (Object)y);
        this.field_70180_af.func_75692_b(20, (Object)z);
    }

    public List<DroneAIManager.EntityAITaskEntry> getRunningTasks() {
        return this.aiManager.getRunningTasks();
    }

    public EntityAIBase getRunningTargetAI() {
        return this.aiManager.getTargetAI();
    }

    public void setVariable(String varName, ChunkPosition pos) {
        this.aiManager.setCoordinate(varName, pos);
    }

    public ChunkPosition getVariable(String varName) {
        return this.aiManager.getCoordinate(varName);
    }

    public ItemStack getActiveProgram() {
        String key = this.getActiveProgramKey();
        if (key.equals("")) {
            return null;
        }
        return ItemProgrammingPuzzle.getStackForWidgetKey(key);
    }

    private String getActiveProgramKey() {
        return this.field_70180_af.func_75681_e(17);
    }

    public IProgWidget getActiveWidget() {
        int index = this.getActiveWidgetIndex();
        if (index >= 0 && index < this.progWidgets.size()) {
            return this.progWidgets.get(index);
        }
        return null;
    }

    private int getActiveWidgetIndex() {
        return this.field_70180_af.func_75679_c(27);
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.field_70180_af.func_75692_b(17, (Object)widget.getWidgetString());
        this.field_70180_af.func_75692_b(27, (Object)this.progWidgets.indexOf(widget));
    }

    private void setAccelerating(boolean accelerating) {
        this.field_70180_af.func_75692_b(13, (Object)((byte)(accelerating ? 1 : 0)));
    }

    @Override
    public boolean isAccelerating() {
        return this.field_70180_af.func_75683_a(13) == 1;
    }

    private void setDroneColor(int color) {
        this.field_70180_af.func_75692_b(22, (Object)color);
    }

    @Override
    public int getDroneColor() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setMinigunActivated(boolean activated) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)(activated ? 1 : 0)));
    }

    public boolean isMinigunActivated() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setHasMinigun(boolean hasMinigun) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)(hasMinigun ? 1 : 0)));
    }

    public boolean hasMinigun() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public int getAmmoColor() {
        ItemStack ammo = this.field_70180_af.func_82710_f(25);
        return ammo != null ? ammo.func_77973_b().func_82790_a(ammo, 1) : -13553359;
    }

    public void setAmmoColor(ItemStack color) {
        this.field_70180_af.func_75692_b(25, (Object)color);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected int func_70682_h(int par1) {
        return -20;
    }

    public void func_70612_e(float par1, float par2) {
        if (this.field_70170_p.field_72995_K) {
            EntityLivingBase targetEntity = this.func_70638_az();
            if (targetEntity != null) {
                if (this.targetLine == null) {
                    this.targetLine = new RenderProgressingLine(0.0, -this.field_70131_O / 2.0f, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.oldTargetLine == null) {
                    this.oldTargetLine = new RenderProgressingLine(0.0, -this.field_70131_O / 2.0f, 0.0, 0.0, 0.0, 0.0);
                }
                this.targetLine.endX = targetEntity.field_70165_t - this.field_70165_t;
                this.targetLine.endY = targetEntity.field_70163_u + (double)(targetEntity.field_70131_O / 2.0f) - this.field_70163_u;
                this.targetLine.endZ = targetEntity.field_70161_v - this.field_70161_v;
                this.oldTargetLine.endX = targetEntity.field_70169_q - this.field_70169_q;
                this.oldTargetLine.endY = targetEntity.field_70167_r + (double)(targetEntity.field_70131_O / 2.0f) - this.field_70167_r;
                this.oldTargetLine.endZ = targetEntity.field_70166_s - this.field_70166_s;
                this.oldTargetLine.setProgress(this.targetLine.getProgress());
                this.targetLine.incProgressByDistance(0.3);
                this.field_70158_ak = true;
            } else {
                this.field_70158_ak = false;
            }
        }
        if (this.field_70154_o == null && this.isAccelerating()) {
            double d3 = this.field_70181_x;
            super.func_70612_e(par1, par2);
            this.field_70181_x = d3 * 0.6;
        } else {
            super.func_70612_e(par1, par2);
        }
        this.field_70122_E = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderExtras(double transX, double transY, double transZ, float partialTicks) {
        if (this.targetLine != null && this.oldTargetLine != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)-1.0, (double)1.0);
            GL11.glDisable((int)3553);
            GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)1.0);
            this.targetLine.renderInterpolated(this.oldTargetLine, partialTicks);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }
        double x = this.field_70142_S + (this.field_70165_t - this.field_70142_S) * (double)partialTicks;
        double y = this.field_70137_T + (this.field_70163_u - this.field_70137_T) * (double)partialTicks;
        double z = this.field_70136_U + (this.field_70161_v - this.field_70136_U) * (double)partialTicks;
        this.getMinigun().render(x, y, z, 0.6);
    }

    public double getRange() {
        return 75.0;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack equippedItem = player.func_71045_bC();
        if (!this.field_70170_p.field_72995_K && equippedItem != null) {
            if (equippedItem.func_77973_b() == Itemss.GPSTool) {
                ChunkPosition gpsLoc = ItemGPSTool.getGPSLocation(equippedItem);
                if (gpsLoc != null) {
                    this.func_70661_as().func_75492_a((double)gpsLoc.field_151329_a, (double)gpsLoc.field_151327_b, (double)gpsLoc.field_151328_c, 0.1);
                }
            } else {
                int dyeIndex = TileEntityPlasticMixer.getDyeIndex(equippedItem);
                if (dyeIndex >= 0) {
                    this.setDroneColor(ItemDye.field_150922_c[dyeIndex]);
                    --equippedItem.field_77994_a;
                    if (equippedItem.field_77994_a <= 0) {
                        player.func_70062_b(0, null);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, int x, int y, int z, ForgeDirection side) {
        if (!this.naturallySpawned) {
            if (player.field_71075_bZ.field_75098_d) {
                this.naturallySpawned = true;
            }
            this.func_70097_a(DamageSource.field_76380_i, 2000.0f);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            this.func_70099_a(this.inventory.func_70301_a(i), 0.0f);
            this.inventory.func_70299_a(i, null);
        }
        if (!this.naturallySpawned) {
            EntityPlayer owner;
            ItemStack drone = this.getDroppedStack();
            if (this.func_94056_bM()) {
                drone.func_151001_c(this.func_94057_bL());
            }
            this.func_70099_a(drone, 0.0f);
            if (!this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
                int x = (int)Math.floor(this.field_70165_t);
                int y = (int)Math.floor(this.field_70163_u);
                int z = (int)Math.floor(this.field_70161_v);
                if (this.func_94056_bM()) {
                    owner.func_146105_b((IChatComponent)new ChatComponentTranslation("death.drone.named", new Object[]{this.func_94057_bL(), x, y, z}));
                } else {
                    owner.func_146105_b((IChatComponent)new ChatComponentTranslation("death.drone", new Object[]{x, y, z}));
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            ((FakePlayerItemInWorldManager)this.getFakePlayer().field_71134_c).cancelDigging();
        }
        super.func_70645_a(par1DamageSource);
    }

    protected ItemStack getDroppedStack() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        tag.func_74782_a("UpgradeInventory", tag.func_74781_a("Inventory"));
        tag.func_82580_o("Inventory");
        ItemStack drone = new ItemStack(Itemss.drone);
        drone.func_77982_d(tag);
        return drone;
    }

    public void func_70624_b(EntityLivingBase entity) {
        super.func_70624_b(entity);
        if (this.field_70170_p.field_72995_K && this.targetLine != null && this.oldTargetLine != null) {
            this.targetLine.setProgress(0.0f);
            this.oldTargetLine.setProgress(0.0f);
        }
    }

    @Override
    public float getPressure(ItemStack iStack) {
        return this.field_70180_af.func_111145_d(12);
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.currentAir += (float)amount;
            this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(this.currentAir / this.volume));
        }
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 10.0f;
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        if (this.func_94056_bM()) {
            curInfo.add(EnumChatFormatting.AQUA + this.func_94057_bL());
        }
        curInfo.add("Owner: " + this.getFakePlayer().func_70005_c_());
        curInfo.add("Current pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(null), 1) + " bar.");
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        TileEntityProgrammer.setWidgetsToNBT(this.progWidgets, tag);
        tag.func_74757_a("naturallySpawned", this.naturallySpawned);
        tag.func_74776_a("currentAir", this.currentAir);
        tag.func_74776_a("propSpeed", this.propSpeed);
        tag.func_74757_a("disabledByHacking", this.disabledByHacking);
        tag.func_74757_a("hackedByOwner", this.gotoOwnerAI != null);
        tag.func_74768_a("color", this.getDroneColor());
        tag.func_74757_a("standby", this.standby);
        tag.func_74776_a("volume", this.volume);
        NBTTagCompound variableTag = new NBTTagCompound();
        this.aiManager.writeToNBT(variableTag);
        tag.func_74782_a("variables", (NBTBase)variableTag);
        NBTTagCompound inv = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.func_70302_i_(); ++currentIndex) {
            if (this.inventory.func_70301_a(currentIndex) == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory.func_70301_a(currentIndex).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        inv.func_74782_a("Inv", (NBTBase)tagList);
        NBTTagList upgradeList = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            if (this.upgradeInventory[i] == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            this.upgradeInventory[i].func_77955_b(slotEntry);
            upgradeList.func_74742_a((NBTBase)slotEntry);
        }
        inv.func_74782_a("Items", (NBTBase)upgradeList);
        tag.func_74782_a("Inventory", (NBTBase)inv);
        this.tank.writeToNBT(tag);
        if (this.handlingOffer != null) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74757_a("isCustom", this.handlingOffer instanceof AmadronOfferCustom);
            this.handlingOffer.writeToNBT(subTag);
            tag.func_74782_a("amadronOffer", (NBTBase)subTag);
            tag.func_74768_a("offerTimes", this.offerTimes);
            if (this.usedTablet != null) {
                this.usedTablet.func_77955_b(subTag);
            }
            tag.func_74778_a("buyingPlayer", this.buyingPlayer);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.progWidgets = TileEntityProgrammer.getWidgetsFromNBT(tag);
        this.naturallySpawned = tag.func_74767_n("naturallySpawned");
        this.currentAir = tag.func_74760_g("currentAir");
        this.volume = tag.func_74760_g("volume");
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(this.currentAir / this.volume));
        this.propSpeed = tag.func_74760_g("propSpeed");
        this.disabledByHacking = tag.func_74767_n("disabledByHacking");
        this.setGoingToOwner(tag.func_74767_n("hackedByOwner"));
        this.setDroneColor(tag.func_74762_e("color"));
        this.aiManager.readFromNBT(tag.func_74775_l("variables"));
        this.standby = tag.func_74767_n("standby");
        NBTTagCompound inv = tag.func_74775_l("Inventory");
        if (inv != null) {
            int i;
            NBTTagList tagList = inv.func_150295_c("Inv", 10);
            this.upgradeInventory = new ItemStack[9];
            NBTTagList upgradeList = inv.func_150295_c("Items", 10);
            for (i = 0; i < upgradeList.func_74745_c(); ++i) {
                NBTTagCompound slotEntry = upgradeList.func_150305_b(i);
                byte j = slotEntry.func_74771_c("Slot");
                if (j < 0 || j >= 9) continue;
                this.upgradeInventory[j] = ItemStack.func_77949_a((NBTTagCompound)slotEntry);
            }
            this.inventory = new InventoryDrone("Drone Inventory", true, 1 + this.getUpgrades(1));
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slot = tagCompound.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a((int)slot, ItemStack.func_77949_a((NBTTagCompound)tagCompound));
            }
        }
        this.tank.setCapacity(16000 * (1 + this.getUpgrades(1)));
        this.tank.readFromNBT(tag);
        if (tag.func_74764_b("amadronOffer")) {
            NBTTagCompound subTag = tag.func_74775_l("amadronOffer");
            this.handlingOffer = subTag.func_74767_n("isCustom") ? AmadronOffer.loadFromNBT(subTag) : AmadronOfferCustom.loadFromNBT(subTag);
            this.usedTablet = subTag.func_74764_b("id") ? ItemStack.func_77949_a((NBTTagCompound)subTag) : null;
            this.buyingPlayer = subTag.func_74779_i("buyingPlayer");
        } else {
            this.handlingOffer = null;
            this.usedTablet = null;
            this.buyingPlayer = null;
        }
        this.offerTimes = tag.func_74762_e("offerTimes");
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        if (this.fakePlayer != null) {
            tag.func_74778_a("owner", this.fakePlayer.func_70005_c_());
            if (this.fakePlayer.func_146103_bH().getId() != null) {
                tag.func_74778_a("ownerUUID", this.fakePlayer.func_146103_bH().getId().toString());
            }
        }
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        if (tag.func_74764_b("owner")) {
            this.playerName = tag.func_74779_i("owner");
            this.playerUUID = tag.func_74764_b("ownerUUID") ? tag.func_74779_i("ownerUUID") : null;
        }
    }

    @Override
    public int getUpgrades(int upgradeDamage) {
        int upgrades = 0;
        for (ItemStack stack : this.upgradeInventory) {
            if (stack == null || stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != upgradeDamage) continue;
            upgrades += stack.field_77994_a;
        }
        return upgrades;
    }

    @Override
    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null && !this.field_70170_p.field_72995_K) {
            this.initializeFakePlayer();
        }
        return this.fakePlayer;
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunDrone().setPlayer((EntityPlayer)this.getFakePlayer()).setWorld(this.field_70170_p).setPressurizable(this, 200);
        }
        return this.minigun;
    }

    public boolean func_70652_k(Entity entity) {
        this.getFakePlayer().func_71059_n(entity);
        this.addAir(null, -200);
        return true;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource == DamageSource.field_76368_d) {
            this.isSuffocating = true;
            if (this.suffocationCounter-- > 0 || !Config.enableDroneSuffocationDamage) {
                return false;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getEmittingRedstone(ForgeDirection side) {
        return this.emittingRedstoneValues[side.ordinal()];
    }

    @Override
    public void setEmittingRedstone(ForgeDirection side, int value) {
        if (this.emittingRedstoneValues[side.ordinal()] != value) {
            this.emittingRedstoneValues[side.ordinal()] = value;
            this.field_70170_p.func_147459_d((int)Math.floor(this.field_70165_t + (double)(this.field_70130_N / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.field_70130_N / 2.0f)), Blockss.droneRedstoneEmitter);
        }
    }

    @Override
    public boolean isBlockValidPathfindBlock(int x, int y, int z) {
        if (this.field_70170_p.func_147437_c(x, y, z)) {
            return true;
        }
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (PneumaticCraftUtils.isBlockLiquid(block)) {
            return this.hasLiquidImmunity;
        }
        if (block.func_149655_b((IBlockAccess)this.field_70170_p, x, y, z) && block != Blocks.field_150468_ap) {
            return true;
        }
        if (PneumaticCraftAPIHandler.getInstance().pathfindableBlocks.containsKey(block)) {
            IPathfindHandler pathfindHandler = PneumaticCraftAPIHandler.getInstance().pathfindableBlocks.get(block);
            return pathfindHandler == null || pathfindHandler.canPathfindThrough(this.field_70170_p, x, y, z);
        }
        return false;
    }

    @Override
    public void sendWireframeToClient(int x, int y, int z) {
        NetworkHandler.sendToAllAround(new PacketShowWireframe(this, x, y, z), this.field_70170_p);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public boolean canHack(Entity entity, EntityPlayer player) {
        return this.isAccelerating();
    }

    @Override
    public void addInfo(Entity entity, List<String> curInfo, EntityPlayer player) {
        if (this.playerName.equals(player.func_70005_c_())) {
            if (this.isGoingToOwner()) {
                curInfo.add("pneumaticHelmet.hacking.result.resumeTasks");
            } else {
                curInfo.add("pneumaticHelmet.hacking.result.callBack");
            }
        } else {
            curInfo.add("pneumaticHelmet.hacking.result.disable");
        }
    }

    @Override
    public void addPostHackInfo(Entity entity, List<String> curInfo, EntityPlayer player) {
        if (this.playerName.equals(player.func_70005_c_())) {
            if (this.isGoingToOwner()) {
                curInfo.add("pneumaticHelmet.hacking.finished.calledBack");
            } else {
                curInfo.add("pneumaticHelmet.hacking.finished.resumedTasks");
            }
        } else {
            curInfo.add("pneumaticHelmet.hacking.finished.disabled");
        }
    }

    @Override
    public int getHackTime(Entity entity, EntityPlayer player) {
        return this.playerName.equals(player.func_70005_c_()) ? 20 : 100;
    }

    @Override
    public void onHackFinished(Entity entity, EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && player.func_146103_bH().equals((Object)this.getFakePlayer().func_146103_bH())) {
            this.setGoingToOwner(this.gotoOwnerAI == null);
        } else {
            this.disabledByHacking = true;
        }
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return false;
    }

    private void setGoingToOwner(boolean state) {
        if (state && this.gotoOwnerAI == null) {
            this.gotoOwnerAI = new DroneGoToOwner(this);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.gotoOwnerAI);
            this.field_70180_af.func_75692_b(21, (Object)1);
            this.setActiveProgram(new ProgWidgetGoToLocation());
        } else if (!state && this.gotoOwnerAI != null) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.gotoOwnerAI);
            this.gotoOwnerAI = null;
            this.field_70180_af.func_75692_b(21, (Object)0);
        }
    }

    private boolean isGoingToOwner() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    @Override
    public IFluidTank getTank() {
        return this.tank;
    }

    public EntityPlayer getOwner() {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.playerName);
    }

    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public Vec3 getPosition() {
        return Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
    }

    @Override
    public void dropItem(ItemStack stack) {
        this.func_70099_a(stack, 0.0f);
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public EntityAITasks getTargetAI() {
        return this.field_70715_bh;
    }

    @Override
    public boolean isProgramApplicable(IProgWidget widget) {
        return true;
    }

    @Override
    public IExtendedEntityProperties getProperty(String key) {
        return this.getExtendedProperties(key);
    }

    @Override
    public void setProperty(String key, IExtendedEntityProperties property) {
        this.registerExtendedProperties(key, property);
    }

    @Override
    public void setName(String string) {
        this.func_94058_c(string);
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        if (entity == null) {
            if (this.getCarryingEntity() != null) {
                this.getCarryingEntity().func_70078_a(null);
            }
        } else {
            entity.func_70078_a((Entity)this);
        }
    }

    @Override
    public Entity getCarryingEntity() {
        return this.field_70153_n;
    }

    @Override
    public boolean isAIOverriden() {
        return this.chargeAI.isExecuting || this.gotoOwnerAI != null;
    }

    @Override
    public void onItemPickupEvent(EntityItem curPickingUpEntity, int stackSize) {
        this.func_71001_a((Entity)curPickingUpEntity, stackSize);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return (IPathNavigator)this.func_70661_as();
    }

    public void tryFireMinigun(EntityLivingBase target) {
        ItemStack ammo = this.getAmmo();
        if (this.getMinigun().setAmmo(ammo).tryFireMinigun(target)) {
            for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
                if (this.getInventory().func_70301_a(i) != ammo) continue;
                this.getInventory().func_70299_a(i, null);
            }
        }
    }

    public ItemStack getAmmo() {
        for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
            ItemStack stack = this.getInventory().func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Itemss.gunAmmo) continue;
            return stack;
        }
        return null;
    }

    public void setHandlingOffer(AmadronOffer offer, int times, ItemStack usedTablet, String buyingPlayer) {
        this.handlingOffer = offer;
        this.offerTimes = times;
        this.usedTablet = usedTablet != null ? usedTablet.func_77946_l() : null;
        this.buyingPlayer = buyingPlayer;
    }

    public AmadronOffer getHandlingOffer() {
        return this.handlingOffer;
    }

    public int getOfferTimes() {
        return this.offerTimes;
    }

    public ItemStack getUsedTablet() {
        return this.usedTablet;
    }

    public String getBuyingPlayer() {
        return this.buyingPlayer;
    }

    @Override
    public void overload() {
        this.func_70097_a(DamageSource.field_76380_i, 2000.0f);
    }

    @Override
    public DroneAIManager getAIManager() {
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
        this.field_70180_af.func_75692_b(26, (Object)(this.getAIManager() != null ? this.getAIManager().getLabel() : "Main"));
    }

    public String getLabel() {
        return this.field_70180_af.func_75681_e(26);
    }

    public SortedSet<DebugEntry> getDebugEntries() {
        return this.debugEntries;
    }

    @Override
    public void addDebugEntry(String message) {
        this.addDebugEntry(message, null);
    }

    @Override
    public void addDebugEntry(String message, ChunkPosition pos) {
        DebugEntry entry = new DebugEntry(message, this.getActiveWidgetIndex(), pos);
        this.addDebugEntry(entry);
        PacketSendDroneDebugEntry packet = new PacketSendDroneDebugEntry(entry, this);
        for (EntityPlayerMP player : this.syncedPlayers) {
            NetworkHandler.sendTo(packet, player);
        }
    }

    public void addDebugEntry(DebugEntry entry) {
        DebugEntry previous;
        if (!this.debugEntries.isEmpty() && (previous = this.debugEntries.last()).getProgWidgetId() != entry.getProgWidgetId()) {
            Iterator iterator = this.debugEntries.iterator();
            while (iterator.hasNext()) {
                if (((DebugEntry)iterator.next()).getProgWidgetId() != entry.getProgWidgetId()) continue;
                iterator.remove();
            }
        }
        this.debugEntries.add(entry);
    }

    public void trackAsDebugged(EntityPlayerMP player) {
        NetworkHandler.sendTo(new PacketSyncDroneEntityProgWidgets(this), player);
        for (DebugEntry entry : this.debugEntries) {
            NetworkHandler.sendTo(new PacketSendDroneDebugEntry(entry, this), player);
        }
        this.syncedPlayers.add(player);
    }

    public void updateSyncedPlayers() {
        Iterator<EntityPlayerMP> iterator = this.syncedPlayers.iterator();
        while (iterator.hasNext()) {
            EntityPlayerMP player = iterator.next();
            if (!player.field_70128_L && player.func_82169_q(3) != null && NBTUtil.getInteger(player.func_82169_q(3), "debuggingDrone") == this.func_145782_y()) continue;
            iterator.remove();
        }
    }

    static {
        colorMap.put("aureylian", 16738740);
        colorMap.put("loneztar", 41120);
        colorMap.put("jadedcat", 10494192);
    }

    private class MinigunDrone
    extends Minigun {
        public MinigunDrone() {
            super(true);
        }

        @Override
        public boolean isMinigunActivated() {
            return EntityDrone.this.isMinigunActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            EntityDrone.this.setMinigunActivated(activated);
        }

        @Override
        public void setAmmoColorStack(ItemStack ammo) {
            EntityDrone.this.setAmmoColor(ammo);
        }

        @Override
        public int getAmmoColor() {
            return EntityDrone.this.getAmmoColor();
        }

        @Override
        public void playSound(String soundName, float volume, float pitch) {
            EntityDrone.this.field_70170_p.func_72956_a((Entity)EntityDrone.this, soundName, volume, pitch);
        }
    }

    public static class DroneFakePlayer
    extends EntityPlayerMP {
        private final IDroneBase drone;
        private boolean sneaking;

        public DroneFakePlayer(WorldServer world, GameProfile name, ItemInWorldManager itemManager, IDroneBase drone) {
            super(FMLCommonHandler.instance().getMinecraftServerInstance(), world, name, itemManager);
            this.drone = drone;
        }

        public void func_71023_q(int amount) {
            Vec3 pos = this.drone.getPosition();
            EntityXPOrb orb = new EntityXPOrb(this.drone.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, amount);
            this.drone.getWorld().func_72838_d((Entity)orb);
        }

        public void func_70062_b(int p_70062_1_, ItemStack p_70062_2_) {
            if (p_70062_1_ == 0) {
                this.field_71071_by.func_70299_a(this.field_71071_by.field_70461_c, p_70062_2_);
            } else {
                this.field_71071_by.field_70460_b[p_70062_1_ - 1] = p_70062_2_;
            }
        }

        public boolean func_70003_b(int i, String s) {
            return false;
        }

        public ChunkCoordinates func_82114_b() {
            return new ChunkCoordinates(0, 0, 0);
        }

        public void func_146105_b(IChatComponent chatmessagecomponent) {
        }

        public void func_71064_a(StatBase par1StatBase, int par2) {
        }

        public void openGui(Object mod, int modGuiId, World world, int x, int y, int z) {
        }

        public boolean func_85032_ar() {
            return true;
        }

        public boolean func_96122_a(EntityPlayer player) {
            return false;
        }

        public void func_70645_a(DamageSource source) {
        }

        public void func_70071_h_() {
        }

        public void func_71027_c(int dim) {
        }

        public void func_147100_a(C15PacketClientSettings pkt) {
        }

        public boolean func_70093_af() {
            return this.sneaking;
        }

        public void func_70095_a(boolean sneaking) {
            this.sneaking = sneaking;
        }
    }

    private class InventoryFakePlayer
    extends InventoryPlayer {
        public InventoryFakePlayer(EntityPlayer par1EntityPlayer) {
            super(par1EntityPlayer);
        }

        public void func_70299_a(int slot, ItemStack stack) {
            super.func_70299_a(slot, stack);
            if (slot == 0 && !EntityDrone.this.isChangingCurrentStack) {
                EntityDrone.this.isChangingCurrentStack = true;
                EntityDrone.this.getInventory().func_70299_a(slot, stack);
                EntityDrone.this.isChangingCurrentStack = false;
            }
        }
    }

    private class InventoryDrone
    extends InventoryBasic {
        ItemStack oldStack;

        public InventoryDrone(String inventoryName, boolean isNameLocalized, int slots) {
            super(inventoryName, isNameLocalized, slots);
        }

        public void func_70299_a(int slot, ItemStack stack) {
            super.func_70299_a(slot, stack);
            if (slot == 0 && !EntityDrone.this.isChangingCurrentStack) {
                EntityDrone.this.isChangingCurrentStack = true;
                EntityDrone.this.getFakePlayer().field_71071_by.func_70299_a(slot, stack);
                EntityDrone.this.isChangingCurrentStack = false;
                if (this.oldStack != null) {
                    EntityDrone.this.getFakePlayer().func_110140_aT().func_111148_a(this.oldStack.func_111283_C());
                }
                if (stack != null) {
                    EntityDrone.this.getFakePlayer().func_110140_aT().func_111147_b(stack.func_111283_C());
                }
                this.oldStack = stack;
            }
        }
    }
}

