/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.util;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class RenderUtils
extends Render {
    public static RenderUtils INSTANCE = new RenderUtils();
    public RenderBlocks renderBlocks;

    private RenderUtils() {
        this.renderBlocks = this.field_147909_c;
    }

    public void renderLiquid(FluidTankInfo info, RenderInfo renderInfo, World worldObj) {
        renderInfo.baseBlock = info.fluid.getFluid().getBlock() != null ? info.fluid.getFluid().getBlock() : Blocks.field_150355_j;
        renderInfo.texture = info.fluid.getFluid().getIcon(info.fluid);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int color = info.fluid.getFluid().getColor(info.fluid);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        GL11.glColor4ub((byte)((byte)red), (byte)((byte)green), (byte)((byte)blue), (byte)-1);
        INSTANCE.renderBlock(renderInfo, (IBlockAccess)worldObj, 0, 0, 0, false, true);
    }

    public void renderBlock(RenderInfo info, IBlockAccess blockAccess, int x, int y, int z, boolean doLight, boolean doTessellating) {
        this.renderBlock(info, blockAccess, x, y, z, x, y, z, doLight, doTessellating);
    }

    public void renderBlock(RenderInfo info, IBlockAccess blockAccess, double x, double y, double z, int lightX, int lightY, int lightZ, boolean doLight, boolean doTessellating) {
        float lightBottom = 0.5f;
        float lightTop = 1.0f;
        float lightEastWest = 0.8f;
        float lightNorthSouth = 0.6f;
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean realDoLight = doLight;
        if (blockAccess == null) {
            realDoLight = false;
        }
        boolean ambientOcclusion = this.renderBlocks.field_147863_w;
        if (!realDoLight) {
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            this.renderBlocks.field_147863_w = false;
        }
        if (doTessellating) {
            tessellator.func_78382_b();
        }
        float light = 0.0f;
        if (realDoLight) {
            if (info.light < 0.0f) {
                light = info.baseBlock.func_149677_c(blockAccess, lightX, lightY, lightZ);
                light += (1.0f - light) * 0.4f;
            } else {
                light = info.light;
            }
            int brightness = 0;
            brightness = info.brightness < 0 ? info.baseBlock.func_149677_c(blockAccess, lightX, lightY, lightZ) : info.brightness;
            tessellator.func_78380_c(brightness);
            tessellator.func_78386_a(lightBottom * light, lightBottom * light, lightBottom * light);
        } else if (info.brightness >= 0) {
            tessellator.func_78380_c(info.brightness);
        }
        this.renderBlocks.func_147782_a(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
        if (info.renderSide[0]) {
            this.renderBlocks.func_147768_a(info.baseBlock, x, y, z, info.getBlockTextureFromSide(0));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightTop * light, lightTop * light, lightTop * light);
        }
        if (info.renderSide[1]) {
            this.renderBlocks.func_147806_b(info.baseBlock, x, y, z, info.getBlockTextureFromSide(1));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[2]) {
            this.renderBlocks.func_147761_c(info.baseBlock, x, y, z, info.getBlockTextureFromSide(2));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[3]) {
            this.renderBlocks.func_147734_d(info.baseBlock, x, y, z, info.getBlockTextureFromSide(3));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[4]) {
            this.renderBlocks.func_147798_e(info.baseBlock, x, y, z, info.getBlockTextureFromSide(4));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[5]) {
            this.renderBlocks.func_147764_f(info.baseBlock, x, y, z, info.getBlockTextureFromSide(5));
        }
        this.renderBlocks.field_147863_w = ambientOcclusion;
        if (doTessellating) {
            tessellator.func_78381_a();
        }
    }

    public void func_76986_a(Entity p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return null;
    }

    public static void glColorHex(int color) {
        double alpha = (double)(color >> 24 & 0xFF) / 255.0;
        double red = (double)(color >> 16 & 0xFF) / 255.0;
        double green = (double)(color >> 8 & 0xFF) / 255.0;
        double blue = (double)(color & 0xFF) / 255.0;
        GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
    }

    public static void render3DArrow() {
        double cos;
        double sin;
        int i;
        GL11.glDisable((int)3553);
        double arrowTipLength = 0.2;
        double arrowTipRadius = 0.25;
        double baseLength = 0.3;
        double baseRadius = 0.15;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78371_b(9);
        for (i = PneumaticCraftUtils.sin.length - 1; i >= 0; --i) {
            sin = PneumaticCraftUtils.sin[i] * baseRadius;
            cos = PneumaticCraftUtils.cos[i] * baseRadius;
            t.func_78377_a(sin, 0.0, cos);
        }
        t.func_78381_a();
        t.func_78371_b(9);
        for (i = PneumaticCraftUtils.sin.length - 1; i >= 0; --i) {
            sin = PneumaticCraftUtils.sin[i] * arrowTipRadius;
            cos = PneumaticCraftUtils.cos[i] * arrowTipRadius;
            t.func_78377_a(sin, baseLength, cos);
        }
        t.func_78381_a();
        t.func_78371_b(8);
        for (i = PneumaticCraftUtils.sin.length - 1; i >= 0; --i) {
            sin = PneumaticCraftUtils.sin[i] * baseRadius;
            cos = PneumaticCraftUtils.cos[i] * baseRadius;
            t.func_78377_a(sin, 0.0, cos);
            t.func_78377_a(sin, baseLength, cos);
        }
        t.func_78381_a();
        t.func_78371_b(6);
        t.func_78377_a(0.0, baseLength + arrowTipLength, 0.0);
        for (i = 0; i < PneumaticCraftUtils.sin.length; ++i) {
            sin = PneumaticCraftUtils.sin[i] * arrowTipRadius;
            cos = PneumaticCraftUtils.cos[i] * arrowTipRadius;
            t.func_78377_a(sin, baseLength, cos);
        }
        t.func_78377_a(0.0, baseLength, arrowTipRadius);
        t.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static class RenderInfo {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public Block baseBlock = Blocks.field_150354_m;
        public IIcon texture = null;
        public IIcon[] textureArray = null;
        public boolean[] renderSide = new boolean[6];
        public float light = -1.0f;
        public int brightness = -1;
        private int meta;

        public RenderInfo() {
            this.setRenderAllSides();
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.baseBlock = template;
            this.textureArray = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
            return this.baseBlock.func_149677_c(iblockaccess, i, j, k);
        }

        public RenderInfo setMeta(int meta) {
            this.meta = meta;
            return this;
        }

        public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            double temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            double temp = this.minX;
            this.minX = 1.0 - this.maxX;
            this.maxX = 1.0 - temp;
        }

        public void reverseZ() {
            double temp = this.minZ;
            this.minZ = 1.0 - this.maxZ;
            this.maxZ = 1.0 - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.texture != null) {
                return this.texture;
            }
            int index = i;
            if (this.textureArray == null || this.textureArray.length == 0) {
                return this.baseBlock.func_149691_a(index, this.meta);
            }
            if (index >= this.textureArray.length) {
                index = 0;
            }
            return this.textureArray[index];
        }
    }
}

