/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.render.RenderProgressingLine;
import pneumaticCraft.client.util.RenderUtils;

public class RenderRangeLines {
    private final List<RenderProgressingLine> rangeLines = new ArrayList<RenderProgressingLine>();
    private int rangeLinesTimer = 0;
    private static Random rand = new Random();
    private final int color;

    public RenderRangeLines(int color) {
        this.color = color;
    }

    public void resetRendering(double range) {
        this.rangeLinesTimer = 200;
        this.rangeLines.clear();
        double renderRange = range + 0.5;
        int i = 0;
        while ((double)i < range * 16.0 + 8.0) {
            this.rangeLines.add(new RenderProgressingLine(-renderRange + (double)i / 8.0, -renderRange + 1.0, -renderRange, -renderRange + (double)i / 8.0, renderRange + 1.0, -renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange - (double)i / 8.0, -renderRange + 1.0, renderRange, renderRange - (double)i / 8.0, renderRange + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + 1.0, renderRange - (double)i / 8.0, -renderRange, renderRange + 1.0, renderRange - (double)i / 8.0));
            this.rangeLines.add(new RenderProgressingLine(renderRange, -renderRange + 1.0, -renderRange + (double)i / 8.0, renderRange, renderRange + 1.0, -renderRange + (double)i / 8.0));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + (double)i / 8.0 + 1.0, -renderRange, -renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange, -renderRange + (double)i / 8.0 + 1.0, -renderRange, renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, renderRange - (double)i / 8.0 + 1.0, -renderRange, renderRange, renderRange - (double)i / 8.0 + 1.0, -renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange, renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange - (double)i / 8.0, -renderRange + 1.0, -renderRange, renderRange - (double)i / 8.0, -renderRange + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange - (double)i / 8.0, renderRange + 1.0, -renderRange, renderRange - (double)i / 8.0, renderRange + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + 1.0, -renderRange + (double)i / 8.0, renderRange, -renderRange + 1.0, -renderRange + (double)i / 8.0));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, renderRange + 1.0, -renderRange + (double)i / 8.0, renderRange, renderRange + 1.0, -renderRange + (double)i / 8.0));
            ++i;
        }
    }

    public boolean isCurrentlyRendering() {
        return this.rangeLines.size() > 0;
    }

    public void update() {
        if (this.rangeLinesTimer > 0) {
            --this.rangeLinesTimer;
            for (RenderProgressingLine line : this.rangeLines) {
                if (!(line.getProgress() > 0.005f) && rand.nextInt(60) != 0) continue;
                line.incProgress(0.01f);
            }
        } else {
            Iterator<RenderProgressingLine> iterator = this.rangeLines.iterator();
            while (iterator.hasNext()) {
                RenderProgressingLine line = iterator.next();
                if (line.getProgress() > 0.005f) {
                    line.incProgress(0.01f);
                }
                if (rand.nextInt(10) != 0) continue;
                iterator.remove();
            }
        }
    }

    public void render() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.glColorHex(this.color);
        GL11.glLineWidth((float)1.0f);
        for (RenderProgressingLine line : this.rangeLines) {
            line.render();
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }
}

