/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.semiblock;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Mouse;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.GuiSearcher;
import pneumaticCraft.client.gui.semiblock.GuiLogisticsLiquidFilter;
import pneumaticCraft.client.gui.widget.GuiCheckBox;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.WidgetFluidStack;
import pneumaticCraft.client.gui.widget.WidgetLabel;
import pneumaticCraft.common.inventory.ContainerLogistics;
import pneumaticCraft.common.inventory.SlotPhantom;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSetLogisticsFilterStack;
import pneumaticCraft.common.network.PacketSetLogisticsFluidFilterStack;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.semiblock.SemiBlockManager;

public class GuiLogisticsBase<Logistics extends SemiBlockLogistics>
extends GuiPneumaticContainerBase {
    protected final Logistics logistics;
    private GuiSearcher searchGui;
    private GuiLogisticsLiquidFilter fluidSearchGui;
    private int editingSlot;
    private GuiCheckBox invisible;

    public GuiLogisticsBase(InventoryPlayer invPlayer, Logistics requester) {
        super(new ContainerLogistics(invPlayer, (SemiBlockLogistics)requester), null, "pneumaticcraft:textures/gui/GuiLogisticsRequester.png");
        this.logistics = ((ContainerLogistics)this.field_147002_h).logistics;
        this.field_147000_g = 216;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.searchGui != null) {
            this.field_147002_h.func_75139_a(this.editingSlot).func_75215_d(this.searchGui.getSearchStack());
            NetworkHandler.sendToServer(new PacketSetLogisticsFilterStack((SemiBlockLogistics)this.logistics, this.searchGui.getSearchStack(), this.editingSlot));
            this.searchGui = null;
        }
        if (this.fluidSearchGui != null && this.fluidSearchGui.getFilter() != null) {
            FluidStack filter = new FluidStack(this.fluidSearchGui.getFilter(), 1000);
            ((SemiBlockLogistics)this.logistics).setFilter(this.editingSlot, filter);
            NetworkHandler.sendToServer(new PacketSetLogisticsFluidFilterStack((SemiBlockLogistics)this.logistics, filter, this.editingSlot));
            this.fluidSearchGui = null;
        }
        String invisibleText = I18n.func_135052_a((String)"gui.logisticFrame.invisible", (Object[])new Object[0]);
        this.invisible = new GuiCheckBox(9, this.field_147003_i + this.field_146999_f - 15 - this.field_146289_q.func_78256_a(invisibleText), this.field_147009_r + 7, -16777216, invisibleText);
        this.addWidget(this.invisible);
        this.invisible.setTooltip(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.logisticFrame.invisible.tooltip", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
        this.addWidget(new WidgetLabel(this.field_147003_i + 8, this.field_147009_r + 18, I18n.func_135052_a((String)String.format("gui.%s.filters", SemiBlockManager.getKeyForSemiBlock(this.logistics)), (Object[])new Object[0])));
        this.addWidget(new WidgetLabel(this.field_147003_i + 8, this.field_147009_r + 90, I18n.func_135052_a((String)"gui.logisticFrame.liquid", (Object[])new Object[0])));
        for (int i = 0; i < 9; ++i) {
            this.addWidget(new WidgetFluidStack(i, this.field_147003_i + i * 18 + 8, this.field_147009_r + 101, ((SemiBlockLogistics)this.logistics).getTankFilter(i)));
        }
        this.addInfoTab(I18n.func_135052_a((String)("gui.tab.info." + SemiBlockManager.getKeyForSemiBlock(this.logistics)), (Object[])new Object[0]));
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.invisible.checked = ((SemiBlockLogistics)this.logistics).isInvisible();
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
        if (widget instanceof WidgetFluidStack) {
            boolean leftClick = Mouse.isButtonDown((int)0);
            boolean middleClick = Mouse.isButtonDown((int)2);
            boolean shift = PneumaticCraft.proxy.isSneakingInGui();
            IFluidTank tank = ((SemiBlockLogistics)this.logistics).getTankFilter(widget.getID());
            if (tank.getFluidAmount() > 0) {
                if (middleClick) {
                    ((SemiBlockLogistics)this.logistics).setFilter(widget.getID(), null);
                } else if (leftClick) {
                    tank.drain(shift ? tank.getFluidAmount() / 2 : 1000, true);
                    if (tank.getFluidAmount() < 1000) {
                        tank.drain(1000, true);
                    }
                } else {
                    tank.fill(new FluidStack(tank.getFluid().getFluid(), shift ? tank.getFluidAmount() : 1000), true);
                }
                NetworkHandler.sendToServer(new PacketSetLogisticsFluidFilterStack((SemiBlockLogistics)this.logistics, tank.getFluid(), widget.getID()));
            } else {
                this.fluidSearchGui = new GuiLogisticsLiquidFilter((GuiScreen)this);
                this.editingSlot = widget.getID();
                this.field_146297_k.func_147108_a((GuiScreen)this.fluidSearchGui);
            }
        }
    }

    protected void func_146984_a(Slot slot, int x, int mouse, int y) {
        if (slot instanceof SlotPhantom && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null && !slot.func_75216_d() && mouse == 1) {
            this.editingSlot = slot.getSlotIndex();
            this.searchGui = new GuiSearcher((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.searchGui);
        } else {
            super.func_146984_a(slot, x, mouse, y);
        }
    }
}

