/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import mekanism.api.Coord4D;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTurbineVent
extends TileEntityTurbineCasing
implements IFluidHandler {
    public FluidTankInfo fakeInfo = new FluidTankInfo(null, 1000);

    public TileEntityTurbineVent() {
        super("TurbineVent");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.structure != null && ((SynchronizedTurbineData)this.structure).flowRemaining > 0) {
            FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, ((SynchronizedTurbineData)this.structure).flowRemaining);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(tile instanceof IFluidHandler) || !((IFluidHandler)tile).canFill(side.getOpposite(), fluidStack.getFluid())) continue;
                ((SynchronizedTurbineData)this.structure).flowRemaining -= ((IFluidHandler)tile).fill(side.getOpposite(), fluidStack, true);
            }
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fakeInfo;
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }
}

