/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.reactor.IReactorBlock;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.CableUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityReactorPort
extends TileEntityReactorBlock
implements IFluidHandler,
IGasHandler,
ITubeConnection,
IHeatTransfer,
IConfigurable {
    public boolean fluidEject;

    public TileEntityReactorPort() {
        super("name", 1.0);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.fluidEject = nbtTags.func_74767_n("fluidEject");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("fluidEject", this.fluidEject);
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.changed) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            CableUtils.emit(this);
            if (this.fluidEject && this.getReactor() != null && this.getReactor().getSteamTank().getFluid() != null) {
                FluidTank tank = this.getReactor().getSteamTank();
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (!(tile instanceof IFluidHandler) || tile instanceof TileEntityReactorPort || !((IFluidHandler)tile).canFill(side.getOpposite(), tank.getFluid().getFluid())) continue;
                    tank.drain(((IFluidHandler)tile).fill(side.getOpposite(), tank.getFluid(), true), true);
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER && this.getReactor() != null && !this.fluidEject) {
            return this.getReactor().getWaterTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() == FluidRegistry.getFluid((String)"steam") && this.getReactor() != null) {
            this.getReactor().getSteamTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getReactor() != null) {
            return this.getReactor().getSteamTank().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getReactor() != null && fluid == FluidRegistry.WATER && !this.fluidEject;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getReactor() != null && fluid == FluidRegistry.getFluid((String)"steam");
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getReactor() == null) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getReactor().getWaterTank().getInfo(), this.getReactor().getSteamTank().getInfo()};
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.getReactor() != null) {
            if (stack.getGas() == GasRegistry.getGas("deuterium")) {
                return this.getReactor().getDeuteriumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == GasRegistry.getGas("tritium")) {
                return this.getReactor().getTritiumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == GasRegistry.getGas("fusionFuelDT")) {
                return this.getReactor().getFuelTank().receive(stack, doTransfer);
            }
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (this.getReactor() != null && this.getReactor().getSteamTank().getFluidAmount() > 0) {
            return new GasStack(GasRegistry.getGas("steam"), this.getReactor().getSteamTank().drain((int)amount, (boolean)doTransfer).amount);
        }
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas("deuterium") || type == GasRegistry.getGas("tritium") || type == GasRegistry.getGas("fusionFuelDT");
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas("steam");
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.getReactor() != null;
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return true;
    }

    @Override
    public double getEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferedEnergy();
    }

    @Override
    public void setEnergy(double energy) {
        if (this.getReactor() != null) {
            this.getReactor().setBufferedEnergy(energy);
        }
    }

    @Override
    public double getMaxEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferSize();
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.remove(ForgeDirection.UNKNOWN);
        return set;
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public double getMaxOutput() {
        return 1.0E9;
    }

    @Override
    public double getTemp() {
        if (this.getReactor() != null) {
            return this.getReactor().getTemp();
        }
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        if (this.getReactor() != null) {
            return this.getReactor().getInsulationCoefficient(side);
        }
        return 0.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        if (this.getReactor() != null) {
            this.getReactor().transferHeatTo(heat);
        }
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        if (this.getReactor() != null) {
            return this.getReactor().applyTemperatureChange();
        }
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return this.getReactor() != null;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (adj instanceof IHeatTransfer && !(adj instanceof IReactorBlock)) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    @Override
    public ItemStack func_70301_a(int slotID) {
        return this.getReactor() != null && this.getReactor().isFormed() ? this.getReactor().getInventory()[slotID] : null;
    }

    @Override
    public int func_70302_i_() {
        return this.getReactor() != null && this.getReactor().isFormed() ? 1 : 0;
    }

    @Override
    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            this.getReactor().getInventory()[slotID] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = InventoryUtils.EMPTY;
        }
        return nArray;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed() && itemstack.func_77973_b() instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)itemstack.func_77973_b();
            return hohlraum.getGas(itemstack) != null && hohlraum.getGas((ItemStack)itemstack).amount == hohlraum.getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.getReactor() != null && this.getReactor().isFormed() && itemstack.func_77973_b() instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)itemstack.func_77973_b();
            return hohlraum.getGas(itemstack) == null;
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.fluidEject = dataStream.readBoolean();
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.fluidEject);
        return data;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        if (!this.field_145850_b.field_72995_K) {
            this.fluidEject = !this.fluidEject;
            String modeText = " " + (Object)((Object)(this.fluidEject ? EnumColor.DARK_RED : EnumColor.DARK_GREEN)) + LangUtils.transOutputInput(this.fluidEject) + ".";
            player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.reactorPortEject") + modeText));
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.func_70296_d();
        }
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }
}

