/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.reactor.IFusionReactor;
import mekanism.api.reactor.IReactorBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityReactorBlock
extends TileEntityElectricBlock
implements IReactorBlock {
    public IFusionReactor fusionReactor;
    public boolean attempted;
    public boolean changed;

    public TileEntityReactorBlock() {
        super("ReactorBlock", 0.0);
        this.inventory = new ItemStack[0];
    }

    public TileEntityReactorBlock(String name, double maxEnergy) {
        super(name, maxEnergy);
    }

    @Override
    public void setReactor(IFusionReactor reactor) {
        if (reactor != this.fusionReactor) {
            this.changed = true;
        }
        this.fusionReactor = reactor;
    }

    @Override
    public IFusionReactor getReactor() {
        return this.fusionReactor;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.getReactor() != null) {
            this.getReactor().formMultiblock(false);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.changed) {
            this.changed = false;
        }
        if (!(this.field_145850_b.field_72995_K || this.ticker != 5 || this.attempted || this.getReactor() != null && this.getReactor().isFormed())) {
            this.updateController();
        }
        this.attempted = false;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!(this instanceof TileEntityReactorController) && this.getReactor() != null) {
            this.getReactor().formMultiblock(true);
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            if (this.getReactor() != null) {
                this.getReactor().formMultiblock(true);
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        TileEntityReactorController found;
        if (!(this instanceof TileEntityReactorController || (found = new ControllerFinder().find()) == null || found.getReactor() != null && found.getReactor().isFormed())) {
            found.formMultiblock(true);
        }
    }

    public class ControllerFinder {
        public TileEntityReactorController found;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D coord = pos.getFromSide(side);
                if (this.iterated.contains(coord) || !(coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b) instanceof TileEntityReactorBlock)) continue;
                ((TileEntityReactorBlock)coord.getTileEntity((IBlockAccess)((TileEntityReactorBlock)TileEntityReactorBlock.this).field_145850_b)).attempted = true;
                if (coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b) instanceof TileEntityReactorController) {
                    this.found = (TileEntityReactorController)coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b);
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntityReactorController find() {
            this.loop(Coord4D.get(TileEntityReactorBlock.this));
            return this.found;
        }
    }
}

