/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import java.util.HashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.BlockGenerator;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TurbineUpdateProtocol
extends UpdateProtocol<SynchronizedTurbineData> {
    public static final int FLUID_PER_TANK = 64000;
    public static final int MAX_BLADES = 28;

    public TurbineUpdateProtocol(TileEntityTurbineCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return this.pointer.func_145831_w().func_147439_a(x, y, z) == GeneratorsBlocks.Generator && BlockGenerator.GeneratorType.getFromMetadata(this.pointer.func_145831_w().func_72805_g(x, y, z)) == BlockGenerator.GeneratorType.TURBINE_CASING;
    }

    @Override
    protected boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = this.pointer.func_145831_w().func_147438_o(x, y, z);
        return tile instanceof TileEntityTurbineRotor || tile instanceof TileEntityRotationalComplex || tile instanceof TileEntityPressureDisperser || tile instanceof TileEntityElectromagneticCoil || tile instanceof TileEntitySaturatingCondenser;
    }

    @Override
    protected boolean canForm(SynchronizedTurbineData structure) {
        int innerRadius;
        if (structure.volLength % 2 == 1 && structure.volWidth % 2 == 1 && (double)(innerRadius = (Math.min(structure.volLength, structure.volWidth) - 3) / 2) >= Math.ceil((structure.volHeight - 2) / 4)) {
            TileEntity tile;
            int centerX = structure.minLocation.xCoord + (structure.volLength - 1) / 2;
            int centerZ = structure.minLocation.zCoord + (structure.volWidth - 1) / 2;
            Coord4D complex = null;
            HashSet<Coord4D> turbines = new HashSet<Coord4D>();
            HashSet<Coord4D> dispersers = new HashSet<Coord4D>();
            HashSet<Coord4D> coils = new HashSet<Coord4D>();
            HashSet<Coord4D> condensers = new HashSet<Coord4D>();
            for (Coord4D coord : this.innerNodes) {
                tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tile instanceof TileEntityRotationalComplex) {
                    if (complex != null) {
                        return false;
                    }
                    if (coord.xCoord != centerX || coord.zCoord != centerZ) {
                        return false;
                    }
                    structure.internalLocations.add(coord);
                    complex = coord;
                    continue;
                }
                if (tile instanceof TileEntityTurbineRotor) {
                    if (coord.xCoord != centerX || coord.zCoord != centerZ) {
                        return false;
                    }
                    turbines.add(coord);
                    continue;
                }
                if (tile instanceof TileEntityPressureDisperser) {
                    dispersers.add(coord);
                    continue;
                }
                if (tile instanceof TileEntityElectromagneticCoil) {
                    coils.add(coord);
                    continue;
                }
                if (!(tile instanceof TileEntitySaturatingCondenser)) continue;
                condensers.add(coord);
            }
            if (complex == null) {
                return false;
            }
            for (int x = complex.xCoord - innerRadius; x <= complex.xCoord + innerRadius; ++x) {
                for (int z = complex.zCoord - innerRadius; z <= complex.zCoord + innerRadius; ++z) {
                    if (x == centerX && z == centerZ) continue;
                    tile = this.pointer.func_145831_w().func_147438_o(x, complex.yCoord, z);
                    if (!(tile instanceof TileEntityPressureDisperser)) {
                        return false;
                    }
                    dispersers.remove(new Coord4D(x, complex.yCoord, z, this.pointer.func_145831_w().field_73011_w.field_76574_g));
                }
            }
            if (dispersers.size() > 0) {
                return false;
            }
            for (Coord4D coord : condensers) {
                if (coord.yCoord > complex.yCoord) continue;
                return false;
            }
            structure.condensers = condensers.size();
            int turbineHeight = 0;
            for (int y = complex.yCoord - 1; y > structure.minLocation.yCoord; --y) {
                tile = this.pointer.func_145831_w().func_147438_o(centerX, y, centerZ);
                if (!(tile instanceof TileEntityTurbineRotor)) {
                    return false;
                }
                ++turbineHeight;
                turbines.remove(new Coord4D(centerX, y, centerZ, this.pointer.func_145831_w().field_73011_w.field_76574_g));
            }
            if (turbines.size() > 0) {
                return false;
            }
            Coord4D startCoord = complex.getFromSide(ForgeDirection.UP);
            if (startCoord.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityElectromagneticCoil) {
                structure.coils = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

                    @Override
                    public boolean isValid(Coord4D coord) {
                        return coord.getTileEntity((IBlockAccess)TurbineUpdateProtocol.this.pointer.func_145831_w()) instanceof TileEntityElectromagneticCoil;
                    }
                }).calculate(startCoord);
            }
            if (coils.size() > structure.coils) {
                return false;
            }
            Coord4D turbineCoord = complex.getFromSide(ForgeDirection.DOWN);
            TileEntity turbineTile = turbineCoord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (turbineTile instanceof TileEntityTurbineRotor) {
                structure.blades = ((TileEntityTurbineRotor)turbineTile).blades;
            }
            for (Coord4D coord : structure.locations) {
                if (!(coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityTurbineVent)) continue;
                if (coord.yCoord >= complex.yCoord) {
                    ++structure.vents;
                    continue;
                }
                return false;
            }
            structure.lowerVolume = structure.volLength * structure.volWidth * turbineHeight;
            structure.complex = complex;
            return true;
        }
        return false;
    }

    @Override
    protected MultiblockCache<SynchronizedTurbineData> getNewCache() {
        return new TurbineCache();
    }

    @Override
    protected SynchronizedTurbineData getNewStructure() {
        return new SynchronizedTurbineData();
    }

    @Override
    protected MultiblockManager<SynchronizedTurbineData> getManager() {
        return MekanismGenerators.turbineManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedTurbineData> cache, MultiblockCache<SynchronizedTurbineData> merge) {
        if (((TurbineCache)cache).fluid == null) {
            ((TurbineCache)cache).fluid = ((TurbineCache)merge).fluid;
        } else if (((TurbineCache)merge).fluid != null && ((TurbineCache)cache).fluid.isFluidEqual(((TurbineCache)merge).fluid)) {
            ((TurbineCache)cache).fluid.amount += ((TurbineCache)merge).fluid.amount;
        }
        ((TurbineCache)cache).electricity += ((TurbineCache)merge).electricity;
        ((TurbineCache)cache).dumpMode = ((TurbineCache)merge).dumpMode;
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (((SynchronizedTurbineData)this.structureFound).fluidStored != null) {
            ((SynchronizedTurbineData)this.structureFound).fluidStored.amount = Math.min(((SynchronizedTurbineData)this.structureFound).fluidStored.amount, ((SynchronizedTurbineData)this.structureFound).getFluidCapacity());
        }
        ((SynchronizedTurbineData)this.structureFound).electricityStored = Math.min(((SynchronizedTurbineData)this.structureFound).electricityStored, ((SynchronizedTurbineData)this.structureFound).getEnergyCapacity());
    }
}

