/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.reactor.IFusionReactor;
import mekanism.api.reactor.INeutronCapture;
import mekanism.api.reactor.IReactorBlock;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FusionReactor
implements IFusionReactor {
    public TileEntityReactorController controller;
    public Set<IReactorBlock> reactorBlocks = new HashSet<IReactorBlock>();
    public Set<INeutronCapture> neutronCaptors = new HashSet<INeutronCapture>();
    public Set<IHeatTransfer> heatTransfers = new HashSet<IHeatTransfer>();
    public double plasmaTemperature;
    public double caseTemperature;
    public double lastPlasmaTemperature;
    public double lastCaseTemperature;
    public double heatToAbsorb = 0.0;
    public static double burnTemperature = UnitDisplayUtils.TemperatureUnit.AMBIENT.convertFromK(1.0E8, true);
    public static double burnRatio = 1.0;
    public static double energyPerFuel = 5000000.0;
    public int injectionRate = 0;
    public static double plasmaHeatCapacity = 100.0;
    public static double caseHeatCapacity = 1.0;
    public static double enthalpyOfVaporization = 10.0;
    public static double thermocoupleEfficiency = 0.05;
    public static double steamTransferEfficiency = 0.1;
    public static double plasmaCaseConductivity = 0.2;
    public static double caseWaterConductivity = 0.3;
    public static double caseAirConductivity = 0.1;
    public boolean burning = false;
    public boolean activelyCooled = true;
    public boolean updatedThisTick;
    public boolean formed = false;

    public FusionReactor(TileEntityReactorController c) {
        this.controller = c;
    }

    @Override
    public void addTemperatureFromEnergyInput(double energyAdded) {
        this.plasmaTemperature += energyAdded / plasmaHeatCapacity * (double)(this.isBurning() ? 1 : 10);
    }

    public boolean hasHohlraum() {
        ItemStack hohlraum;
        if (this.controller != null && (hohlraum = this.controller.inventory[0]) != null && hohlraum.func_77973_b() instanceof ItemHohlraum) {
            GasStack gasStack = ((ItemHohlraum)hohlraum.func_77973_b()).getGas(hohlraum);
            return gasStack != null && gasStack.getGas() == GasRegistry.getGas("fusionFuelDT") && gasStack.amount == 10;
        }
        return false;
    }

    @Override
    public void simulate() {
        if (this.controller.func_145831_w().field_72995_K) {
            this.lastPlasmaTemperature = this.plasmaTemperature;
            this.lastCaseTemperature = this.caseTemperature;
            return;
        }
        this.updatedThisTick = false;
        if (this.plasmaTemperature >= burnTemperature) {
            if (!this.burning && this.hasHohlraum()) {
                this.vaporiseHohlraum();
            }
            if (this.burning) {
                this.injectFuel();
                int fuelBurned = this.burnFuel();
                this.neutronFlux(fuelBurned);
                if (fuelBurned == 0) {
                    this.burning = false;
                }
            }
        } else {
            this.burning = false;
        }
        this.transferHeat();
        if (this.burning) {
            this.kill();
        }
        this.updateTemperatures();
    }

    @Override
    public void updateTemperatures() {
        this.lastPlasmaTemperature = this.plasmaTemperature < 0.1 ? 0.0 : this.plasmaTemperature;
        this.lastCaseTemperature = this.caseTemperature < 0.1 ? 0.0 : this.caseTemperature;
    }

    public void vaporiseHohlraum() {
        this.getFuelTank().receive(((ItemHohlraum)this.controller.inventory[0].func_77973_b()).getGas(this.controller.inventory[0]), true);
        this.lastPlasmaTemperature = this.plasmaTemperature;
        this.controller.inventory[0] = null;
        this.burning = true;
    }

    public void injectFuel() {
        int amountNeeded = this.getFuelTank().getNeeded();
        int amountAvailable = 2 * Math.min(this.getDeuteriumTank().getStored(), this.getTritiumTank().getStored());
        int amountToInject = Math.min(amountNeeded, Math.min(amountAvailable, this.injectionRate));
        amountToInject -= amountToInject % 2;
        this.getDeuteriumTank().draw(amountToInject / 2, true);
        this.getTritiumTank().draw(amountToInject / 2, true);
        this.getFuelTank().receive(new GasStack(GasRegistry.getGas("fusionFuelDT"), amountToInject), true);
    }

    public int burnFuel() {
        int fuelBurned = (int)Math.min((double)this.getFuelTank().getStored(), Math.max(0.0, this.lastPlasmaTemperature - burnTemperature) * burnRatio);
        this.getFuelTank().draw(fuelBurned, true);
        this.plasmaTemperature += energyPerFuel * (double)fuelBurned / plasmaHeatCapacity;
        return fuelBurned;
    }

    public void neutronFlux(int fuelBurned) {
        int neutronsRemaining = fuelBurned;
        ArrayList<INeutronCapture> list = new ArrayList<INeutronCapture>(this.neutronCaptors);
        Collections.shuffle(list);
        for (INeutronCapture captor : this.neutronCaptors) {
            if (neutronsRemaining <= 0) break;
            neutronsRemaining = captor.absorbNeutrons(neutronsRemaining);
        }
        this.controller.radiateNeutrons(neutronsRemaining);
    }

    public void transferHeat() {
        double plasmaCaseHeat = plasmaCaseConductivity * (this.lastPlasmaTemperature - this.lastCaseTemperature);
        this.plasmaTemperature -= plasmaCaseHeat / plasmaHeatCapacity;
        this.caseTemperature += plasmaCaseHeat / caseHeatCapacity;
        if (this.activelyCooled) {
            double caseWaterHeat = caseWaterConductivity * this.lastCaseTemperature;
            int waterToVaporize = (int)(steamTransferEfficiency * caseWaterHeat / enthalpyOfVaporization);
            if ((waterToVaporize = Math.min(waterToVaporize, Math.min(this.getWaterTank().getFluidAmount(), this.getSteamTank().getCapacity() - this.getSteamTank().getFluidAmount()))) > 0) {
                this.getWaterTank().drain(waterToVaporize, true);
                this.getSteamTank().fill(new FluidStack(FluidRegistry.getFluid((String)"steam"), waterToVaporize), true);
            }
            caseWaterHeat = (double)waterToVaporize * enthalpyOfVaporization / steamTransferEfficiency;
            this.caseTemperature -= caseWaterHeat / caseHeatCapacity;
            for (IHeatTransfer source : this.heatTransfers) {
                source.simulateHeat();
            }
            this.applyTemperatureChange();
        }
        double caseAirHeat = caseAirConductivity * this.lastCaseTemperature;
        this.caseTemperature -= caseAirHeat / caseHeatCapacity;
        this.setBufferedEnergy(this.getBufferedEnergy() + caseAirHeat * thermocoupleEfficiency);
    }

    @Override
    public FluidTank getWaterTank() {
        return this.controller != null ? this.controller.waterTank : null;
    }

    @Override
    public FluidTank getSteamTank() {
        return this.controller.steamTank;
    }

    @Override
    public GasTank getDeuteriumTank() {
        return this.controller.deuteriumTank;
    }

    @Override
    public GasTank getTritiumTank() {
        return this.controller.tritiumTank;
    }

    @Override
    public GasTank getFuelTank() {
        return this.controller.fuelTank;
    }

    @Override
    public double getBufferedEnergy() {
        return this.controller.getEnergy();
    }

    @Override
    public void setBufferedEnergy(double energy) {
        this.controller.setEnergy(energy);
    }

    @Override
    public double getPlasmaTemp() {
        return this.lastPlasmaTemperature;
    }

    @Override
    public void setPlasmaTemp(double temp) {
        this.plasmaTemperature = temp;
    }

    @Override
    public double getCaseTemp() {
        return this.lastCaseTemperature;
    }

    @Override
    public void setCaseTemp(double temp) {
        this.caseTemperature = temp;
    }

    @Override
    public double getBufferSize() {
        return this.controller.getMaxEnergy();
    }

    public void kill() {
        AxisAlignedBB death_zone = AxisAlignedBB.func_72330_a((double)(this.controller.field_145851_c - 1), (double)(this.controller.field_145848_d - 3), (double)(this.controller.field_145849_e - 1), (double)(this.controller.field_145851_c + 2), (double)this.controller.field_145848_d, (double)(this.controller.field_145849_e + 2));
        List entitiesToDie = this.controller.func_145831_w().func_72872_a(Entity.class, death_zone);
        for (Entity entity : entitiesToDie) {
            entity.func_70097_a(DamageSource.field_76376_m, 50000.0f);
        }
    }

    public void unformMultiblock(boolean keepBurning) {
        for (IReactorBlock block : this.reactorBlocks) {
            block.setReactor(null);
        }
        this.controller.setReactor(this);
        this.reactorBlocks.clear();
        this.neutronCaptors.clear();
        this.formed = false;
        boolean bl = this.burning = this.burning && keepBurning;
        if (!this.controller.func_145831_w().field_72995_K) {
            Mekanism.packetHandler.sendToDimension(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.controller), this.controller.getNetworkedData(new ArrayList())), this.controller.func_145831_w().field_73011_w.field_76574_g);
        }
    }

    @Override
    public void formMultiblock(boolean keepBurning) {
        this.updatedThisTick = true;
        Coord4D controllerPosition = Coord4D.get(this.controller);
        Coord4D centreOfReactor = controllerPosition.getFromSide(ForgeDirection.DOWN, 2);
        this.unformMultiblock(true);
        this.reactorBlocks.add(this.controller);
        if (!this.createFrame(centreOfReactor)) {
            this.unformMultiblock(keepBurning);
            return;
        }
        if (!this.addSides(centreOfReactor)) {
            this.unformMultiblock(keepBurning);
            return;
        }
        if (!this.centreIsClear(centreOfReactor)) {
            this.unformMultiblock(keepBurning);
            return;
        }
        this.formed = true;
        if (!this.controller.func_145831_w().field_72995_K) {
            Mekanism.packetHandler.sendToDimension(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.controller), this.controller.getNetworkedData(new ArrayList())), this.controller.func_145831_w().field_73011_w.field_76574_g);
        }
    }

    public boolean createFrame(Coord4D centre) {
        int[][] positions;
        for (int[] coords : positions = new int[][]{{2, 2, 0}, {2, 1, 1}, {2, 0, 2}, {2, -1, 1}, {2, -2, 0}, {2, -1, -1}, {2, 0, -2}, {2, 1, -1}, {1, 2, 1}, {1, 1, 2}, {1, -1, 2}, {1, -2, 1}, {1, -2, -1}, {1, -1, -2}, {1, 1, -2}, {1, 2, -1}, {0, 2, 2}, {0, -2, 2}, {0, -2, -2}, {0, 2, -2}, {-1, 2, 1}, {-1, 1, 2}, {-1, -1, 2}, {-1, -2, 1}, {-1, -2, -1}, {-1, -1, -2}, {-1, 1, -2}, {-1, 2, -1}, {-2, 2, 0}, {-2, 1, 1}, {-2, 0, 2}, {-2, -1, 1}, {-2, -2, 0}, {-2, -1, -1}, {-2, 0, -2}, {-2, 1, -1}}) {
            TileEntity tile = centre.clone().translate(coords[0], coords[1], coords[2]).getTileEntity((IBlockAccess)this.controller.func_145831_w());
            if (!(tile instanceof IReactorBlock) || !((IReactorBlock)tile).isFrame()) {
                return false;
            }
            this.reactorBlocks.add((IReactorBlock)tile);
            ((IReactorBlock)tile).setReactor(this);
        }
        return true;
    }

    public boolean addSides(Coord4D centre) {
        int[][] positions;
        for (int[] coords : positions = new int[][]{{2, 0, 0}, {2, 1, 0}, {2, 0, 1}, {2, -1, 0}, {2, 0, -1}, {-2, 0, 0}, {-2, 1, 0}, {-2, 0, 1}, {-2, -1, 0}, {-2, 0, -1}, {0, 2, 0}, {1, 2, 0}, {0, 2, 1}, {-1, 2, 0}, {0, 2, -1}, {0, -2, 0}, {1, -2, 0}, {0, -2, 1}, {-1, -2, 0}, {0, -2, -1}, {0, 0, 2}, {1, 0, 2}, {0, 1, 2}, {-1, 0, 2}, {0, -1, 2}, {0, 0, -2}, {1, 0, -2}, {0, 1, -2}, {-1, 0, -2}, {0, -1, -2}}) {
            TileEntity tile = centre.clone().translate(coords[0], coords[1], coords[2]).getTileEntity((IBlockAccess)this.controller.func_145831_w());
            if (tile instanceof ILaserReceptor && (coords[1] != 0 || coords[0] != 0 && coords[2] != 0)) {
                return false;
            }
            if (tile instanceof IReactorBlock) {
                this.reactorBlocks.add((IReactorBlock)tile);
                ((IReactorBlock)tile).setReactor(this);
                if (tile instanceof INeutronCapture) {
                    this.neutronCaptors.add((INeutronCapture)tile);
                }
                if (!(tile instanceof IHeatTransfer)) continue;
                this.heatTransfers.add((IHeatTransfer)tile);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean centreIsClear(Coord4D centre) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Coord4D trans = centre.clone().translate(x, y, z);
                    if (trans.isAirBlock((IBlockAccess)this.controller.func_145831_w())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isFormed() {
        return this.formed;
    }

    @Override
    public void setInjectionRate(int rate) {
        this.injectionRate = rate;
        int capRate = Math.max(1, rate);
        this.controller.waterTank.setCapacity(100000 * capRate);
        this.controller.steamTank.setCapacity(10000000 * capRate);
        if (this.controller.waterTank.getFluid() != null) {
            this.controller.waterTank.getFluid().amount = Math.min(this.controller.waterTank.getFluid().amount, this.controller.waterTank.getCapacity());
        }
        if (this.controller.steamTank.getFluid() != null) {
            this.controller.steamTank.getFluid().amount = Math.min(this.controller.steamTank.getFluid().amount, this.controller.steamTank.getCapacity());
        }
    }

    @Override
    public int getInjectionRate() {
        return this.injectionRate;
    }

    @Override
    public boolean isBurning() {
        return this.burning;
    }

    @Override
    public void setBurning(boolean burn) {
        this.burning = burn;
    }

    @Override
    public int getMinInjectionRate(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        double aMin = burnTemperature * burnRatio * plasmaCaseConductivity * (k + caseAirConductivity) / (energyPerFuel * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) - plasmaCaseConductivity * (k + caseAirConductivity));
        return (int)(2.0 * Math.ceil(aMin / 2.0));
    }

    @Override
    public double getMaxPlasmaTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return (double)this.injectionRate * energyPerFuel / plasmaCaseConductivity * (plasmaCaseConductivity + k + caseAirConductivity) / (k + caseAirConductivity);
    }

    @Override
    public double getMaxCasingTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return (double)this.injectionRate * energyPerFuel / (k + caseAirConductivity);
    }

    @Override
    public double getIgnitionTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return burnTemperature * energyPerFuel * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) / (energyPerFuel * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) - plasmaCaseConductivity * (k + caseAirConductivity));
    }

    @Override
    public double getPassiveGeneration(boolean active, boolean current) {
        double temperature = current ? this.caseTemperature : this.getMaxCasingTemperature(active);
        return thermocoupleEfficiency * caseAirConductivity * temperature;
    }

    @Override
    public int getSteamPerTick(boolean current) {
        double temperature = current ? this.caseTemperature : this.getMaxCasingTemperature(true);
        return (int)(steamTransferEfficiency * caseWaterConductivity * temperature / enthalpyOfVaporization);
    }

    @Override
    public double getTemp() {
        return this.lastCaseTemperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0 / caseAirConductivity;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 100000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return null;
    }

    @Override
    public double applyTemperatureChange() {
        this.caseTemperature += this.heatToAbsorb / caseHeatCapacity;
        this.heatToAbsorb = 0.0;
        return this.caseTemperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return false;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        return null;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.isFormed() ? this.controller.inventory : null;
    }
}

