/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.util.ListUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.inventory.container.ContainerWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiWindGenerator
extends GuiMekanism {
    public TileEntityWindGenerator tileEntity;
    private DecimalFormat powerFormat = new DecimalFormat("0.##");

    public GuiWindGenerator(InventoryPlayer inventory, TileEntityWindGenerator tentity) {
        super(new ContainerWindGenerator(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiWindTurbine.png")));
        this.guiElements.add(new GuiSecurityTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiWindTurbine.png")));
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                return ListUtils.asList(LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(GuiWindGenerator.this.tileEntity.isActive ? MekanismConfig.generators.windGenerationMin * (double)GuiWindGenerator.this.tileEntity.currentMultiplier : 0.0) + "/t", LangUtils.localize("gui.maxOutput") + ": " + MekanismUtils.getEnergyDisplay(GuiWindGenerator.this.tileEntity.getMaxOutput()) + "/t");
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiWindTurbine.png")));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiWindTurbine.png"), 164, 15));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiWindTurbine.png"), 142, 34).with(GuiSlot.SlotOverlay.POWER));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.tileEntity.func_145825_b(), 45, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy()), 51, 26, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.power") + ": " + this.powerFormat.format(MekanismUtils.convertToDisplay(MekanismConfig.generators.windGenerationMin * (double)this.tileEntity.currentMultiplier)), 51, 35, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.out") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getMaxOutput()) + "/t", 51, 44, 52480);
        int size = 44;
        if (!this.tileEntity.getActive()) {
            this.field_146289_q.func_78276_b((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.skyBlocked"), 51, size += 9, 52480);
        }
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiWindTurbine.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(guiWidth + 20, guiHeight + 37, 176, this.tileEntity.getActive() ? 52 : 64, 12, 12);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }
}

