/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.util.ListUtils;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiFuelTab;
import mekanism.generators.client.gui.element.GuiHeatTab;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiReactorStats
extends GuiMekanism {
    public TileEntityReactorController tileEntity;
    public static NumberFormat nf = NumberFormat.getIntegerInstance();

    public GuiReactorStats(InventoryPlayer inventory, TileEntityReactorController tentity) {
        super(new ContainerNull(inventory.field_70458_d, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                return GuiReactorStats.this.tileEntity.isFormed() ? ListUtils.asList(LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(GuiReactorStats.this.tileEntity.getEnergy()), LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(GuiReactorStats.this.tileEntity.getReactor().getPassiveGeneration(false, true)) + "/t") : new ArrayList<String>();
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTall.png")));
        this.guiElements.add(new GuiHeatTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTall.png")));
        this.guiElements.add(new GuiFuelTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTall.png")));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tileEntity.func_145825_b(), 46, 6, 0x404040);
        if (this.tileEntity.isFormed()) {
            this.field_146289_q.func_78276_b((Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.passive"), 6, 26, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.minInject") + ": " + this.tileEntity.getReactor().getMinInjectionRate(false), 16, 36, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.ignition") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.getReactor().getIgnitionTemperature(false), UnitDisplayUtils.TemperatureUnit.AMBIENT), 16, 46, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxPlasma") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.getReactor().getMaxPlasmaTemperature(false), UnitDisplayUtils.TemperatureUnit.AMBIENT), 16, 56, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxCasing") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.getReactor().getMaxCasingTemperature(false), UnitDisplayUtils.TemperatureUnit.AMBIENT), 16, 66, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.passiveGeneration") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getReactor().getPassiveGeneration(false, false)) + "/t", 16, 76, 0x404040);
            this.field_146289_q.func_78276_b((Object)((Object)EnumColor.DARK_BLUE) + LangUtils.localize("gui.active"), 6, 92, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.minInject") + ": " + this.tileEntity.getReactor().getMinInjectionRate(true), 16, 102, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.ignition") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.getReactor().getIgnitionTemperature(true), UnitDisplayUtils.TemperatureUnit.AMBIENT), 16, 112, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxPlasma") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.getReactor().getMaxPlasmaTemperature(true), UnitDisplayUtils.TemperatureUnit.AMBIENT), 16, 122, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxCasing") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.getReactor().getMaxCasingTemperature(true), UnitDisplayUtils.TemperatureUnit.AMBIENT), 16, 132, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.passiveGeneration") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getReactor().getPassiveGeneration(true, false)) + "/t", 16, 142, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.steamProduction") + ": " + nf.format(this.tileEntity.getReactor().getSteamPerTick(false)) + "mB/t", 16, 152, 0x404040);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTall.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, 14, 14, 14);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0 && xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
            SoundHandler.playSound("gui.button.press");
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(this.tileEntity), 1, 10));
        }
    }
}

