/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITileComponent;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileComponentSecurity
implements ITileComponent {
    public TileEntityContainerBlock tileEntity;
    private String owner;
    private ISecurityTile.SecurityMode securityMode = ISecurityTile.SecurityMode.PUBLIC;
    private SecurityFrequency frequency;

    public TileComponentSecurity(TileEntityContainerBlock tile) {
        this.tileEntity = tile;
        tile.components.add(this);
    }

    public void readFrom(TileComponentSecurity security) {
        this.owner = security.owner;
        this.securityMode = security.securityMode;
    }

    public SecurityFrequency getFrequency() {
        return this.frequency;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String o) {
        this.frequency = null;
        this.owner = o;
    }

    public ISecurityTile.SecurityMode getMode() {
        if (MekanismConfig.general.allowProtection) {
            return this.securityMode;
        }
        return ISecurityTile.SecurityMode.PUBLIC;
    }

    public void setMode(ISecurityTile.SecurityMode mode) {
        this.securityMode = mode;
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.owner == null || freq == null) {
            return null;
        }
        return Mekanism.securityFrequencies;
    }

    public void setFrequency(String owner) {
        FrequencyManager manager = Mekanism.securityFrequencies;
        manager.deactivate(Coord4D.get(this.tileEntity));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.owner.equals(owner)) continue;
            this.frequency = (SecurityFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this.tileEntity));
            return;
        }
        Frequency freq = new SecurityFrequency(owner).setAccess(ISecurityTile.SecurityMode.PUBLIC);
        freq.activeCoords.add(Coord4D.get(this.tileEntity));
        manager.addFrequency(freq);
        this.frequency = (SecurityFrequency)freq;
        MekanismUtils.saveChunk(this.tileEntity);
        this.tileEntity.func_70296_d();
    }

    @Override
    public void tick() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            FrequencyManager manager;
            if (this.frequency == null && this.owner != null) {
                this.setFrequency(this.owner);
            }
            if ((manager = this.getManager(this.frequency)) != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (SecurityFrequency)manager.validateFrequency(this.owner, Coord4D.get(this.tileEntity), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = (SecurityFrequency)manager.update(this.owner, Coord4D.get(this.tileEntity), this.frequency);
                }
            } else {
                this.frequency = null;
            }
        }
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.securityMode = ISecurityTile.SecurityMode.values()[nbtTags.func_74762_e("securityMode")];
        if (nbtTags.func_74764_b("owner")) {
            this.owner = nbtTags.func_74779_i("owner");
        }
        if (nbtTags.func_74764_b("securityFreq")) {
            this.frequency = new SecurityFrequency(nbtTags.func_74775_l("securityFreq"));
            this.frequency.valid = false;
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.securityMode = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
        this.owner = dataStream.readBoolean() ? PacketHandler.readString(dataStream) : null;
        this.frequency = dataStream.readBoolean() ? new SecurityFrequency(dataStream) : null;
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("securityMode", this.securityMode.ordinal());
        if (this.owner != null) {
            nbtTags.func_74778_a("owner", this.owner);
        }
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("securityFreq", (NBTBase)frequencyTag);
        }
    }

    @Override
    public void write(ArrayList data) {
        data.add(this.securityMode.ordinal());
        if (this.owner != null) {
            data.add(true);
            data.add(this.owner);
        } else {
            data.add(false);
        }
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
    }

    @Override
    public void invalidate() {
        FrequencyManager manager;
        if (!this.tileEntity.func_145831_w().field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this.tileEntity));
        }
    }
}

