/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITankManager;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.CableUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityQuantumEntangloporter
extends TileEntityElectricBlock
implements ISideConfiguration,
ITankManager,
IFluidHandler,
IFrequencyHandler,
IGasHandler,
IHeatTransfer,
ITubeConnection,
IComputerIntegration,
ISecurityTile {
    public InventoryFrequency frequency;
    public double heatToAbsorb = 0.0;
    public double lastTransferLoss;
    public double lastEnvironmentLoss;
    public List<Frequency> publicCache = new ArrayList<Frequency>();
    public List<Frequency> protectedCache = new ArrayList<Frequency>();
    public List<Frequency> privateCache = new ArrayList<Frequency>();
    public static final EnumSet<ForgeDirection> nothing = EnumSet.noneOf(ForgeDirection.class);
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.ENERGY, TransmissionType.HEAT);
    public TileComponentSecurity securityComponent;
    private static final String[] methods = new String[]{"setFrequency"};

    public TileEntityQuantumEntangloporter() {
        super("QuantumEntangloporter", 0.0);
        for (TransmissionType type : TransmissionType.values()) {
            if (type != TransmissionType.HEAT) {
                this.configComponent.setIOConfig(type);
                continue;
            }
            this.configComponent.setInputConfig(type);
        }
        this.inventory = new ItemStack[0];
        this.configComponent.getOutputs((TransmissionType)TransmissionType.ITEM).get((int)2).availableSlots = new int[]{0};
        this.configComponent.getOutputs((TransmissionType)TransmissionType.FLUID).get((int)2).availableSlots = new int[]{0};
        this.configComponent.getOutputs((TransmissionType)TransmissionType.GAS).get((int)2).availableSlots = new int[]{1};
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setOutputData(TransmissionType.FLUID, this.configComponent.getOutputs(TransmissionType.FLUID).get(2));
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.configComponent.isEjecting(TransmissionType.ENERGY)) {
                CableUtils.emit(this);
            }
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastTransferLoss = loss[0];
            this.lastEnvironmentLoss = loss[1];
            FrequencyManager manager = this.getManager(this.frequency);
            InventoryFrequency lastFreq = this.frequency;
            if (manager != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (InventoryFrequency)manager.validateFrequency(this.getSecurity().getOwner(), Coord4D.get(this), this.frequency);
                    this.func_70296_d();
                }
                if (this.frequency != null) {
                    this.frequency = (InventoryFrequency)manager.update(this.getSecurity().getOwner(), Coord4D.get(this), this.frequency);
                    if (this.frequency == null) {
                        this.func_70296_d();
                    }
                }
            } else {
                this.frequency = null;
                if (lastFreq != null) {
                    this.func_70296_d();
                }
            }
        }
    }

    private boolean hasFrequency() {
        return this.frequency != null && this.frequency.valid;
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.getSecurity().getFrequency();
        }
        return this.frequency;
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.getSecurity().getOwner() == null || freq == null) {
            return null;
        }
        if (freq.isPublic()) {
            return Mekanism.publicEntangloporters;
        }
        if (freq.isPrivate()) {
            if (!Mekanism.privateEntangloporters.containsKey(this.getSecurity().getOwner())) {
                FrequencyManager manager = new FrequencyManager(InventoryFrequency.class, "Entangloporter", this.getSecurity().getOwner());
                Mekanism.privateEntangloporters.put(this.getSecurity().getOwner(), manager);
                manager.createOrLoad(this.field_145850_b);
            }
            return Mekanism.privateEntangloporters.get(this.getSecurity().getOwner());
        }
        if (!Mekanism.protectedEntangloporters.containsKey(this.getSecurity().getOwner())) {
            FrequencyManager manager = new FrequencyManager(InventoryFrequency.class, "Entangloporter#protected", this.getSecurity().getOwner());
            Mekanism.protectedEntangloporters.put(this.getSecurity().getOwner(), manager);
            manager.createOrLoad(this.field_145850_b);
        }
        return Mekanism.protectedEntangloporters.get(this.getSecurity().getOwner());
    }

    public void setFrequency(String name, ISecurityTile.SecurityMode access) {
        FrequencyManager manager = this.getManager(new InventoryFrequency(name, null).setAccess(access));
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            this.frequency = (InventoryFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            this.func_70296_d();
            return;
        }
        Frequency freq = new InventoryFrequency(name, this.getSecurity().getOwner()).setAccess(access);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = (InventoryFrequency)freq;
        MekanismUtils.saveChunk(this);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("frequency")) {
            this.frequency = new InventoryFrequency(nbtTags.func_74775_l("frequency"));
            this.frequency.valid = false;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("frequency", (NBTBase)frequencyTag);
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            String freq;
            FrequencyManager manager;
            int type = dataStream.readInt();
            if (type == 0) {
                String name = PacketHandler.readString(dataStream);
                this.setFrequency(name, ISecurityTile.SecurityMode.values()[dataStream.readInt()]);
            } else if (type == 1 && (manager = this.getManager(new InventoryFrequency(freq = PacketHandler.readString(dataStream), null).setAccess(ISecurityTile.SecurityMode.values()[dataStream.readInt()]))) != null) {
                manager.remove(freq, this.getSecurity().getOwner());
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            int i;
            this.lastTransferLoss = dataStream.readDouble();
            this.lastEnvironmentLoss = dataStream.readDouble();
            this.frequency = dataStream.readBoolean() ? new InventoryFrequency(dataStream) : null;
            this.publicCache.clear();
            this.privateCache.clear();
            this.protectedCache.clear();
            int amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.publicCache.add(new InventoryFrequency(dataStream));
            }
            amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.privateCache.add(new InventoryFrequency(dataStream));
            }
            amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.protectedCache.add(new InventoryFrequency(dataStream));
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.lastTransferLoss);
        data.add(this.lastEnvironmentLoss);
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
        data.add(Mekanism.publicEntangloporters.getFrequencies().size());
        for (Frequency frequency : Mekanism.publicEntangloporters.getFrequencies()) {
            frequency.write(data);
        }
        FrequencyManager manager = this.getManager(new InventoryFrequency(null, null).setAccess(ISecurityTile.SecurityMode.PRIVATE));
        if (manager != null) {
            data.add(manager.getFrequencies().size());
            for (Frequency freq : manager.getFrequencies()) {
                freq.write(data);
            }
        } else {
            data.add(0);
        }
        ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
        for (Frequency frequency : Mekanism.securityFrequencies.getFrequencies()) {
            FrequencyManager protected_;
            SecurityFrequency secure = (SecurityFrequency)frequency;
            if (!secure.trusted.contains(this.getSecurity().getOwner()) || (protected_ = Mekanism.protectedEntangloporters.get(secure.owner)) == null) continue;
            arrayList.addAll(protected_.getFrequencies());
        }
        if (this.getSecurity().getOwner() != null) {
            arrayList.addAll(this.getManager(new Frequency(null, null).setAccess(ISecurityTile.SecurityMode.TRUSTED)).getFrequencies());
        }
        data.add(arrayList.size());
        for (Frequency freq : arrayList) {
            freq.write(data);
        }
        return data;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return !this.hasFrequency() ? nothing : this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 2);
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return !this.hasFrequency() ? nothing : this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 1);
    }

    @Override
    public double getMaxOutput() {
        return !this.hasFrequency() ? 0.0 : 1.0E9;
    }

    @Override
    public double getEnergy() {
        return !this.hasFrequency() ? 0.0 : this.frequency.storedEnergy;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.hasFrequency()) {
            this.frequency.storedEnergy = Math.min(1.0E9, energy);
        }
    }

    @Override
    public double getMaxEnergy() {
        return !this.hasFrequency() ? 0.0 : 1.0E9;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return !this.hasFrequency() ? 0 : this.frequency.storedFluid.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.hasFrequency() && resource.isFluidEqual(this.frequency.storedFluid.getFluid())) {
            return this.frequency.storedFluid.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.hasFrequency()) {
            return this.frequency.storedFluid.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (int)from.ordinal(), (int)this.facing).ioState == SideData.IOState.INPUT) {
            return this.frequency.storedFluid.getFluid() == null || fluid == this.frequency.storedFluid.getFluid().getFluid();
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (int)from.ordinal(), (int)this.facing).ioState == SideData.IOState.OUTPUT) {
            return this.frequency.storedFluid.getFluid() == null || fluid == this.frequency.storedFluid.getFluid().getFluid();
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (int)from.ordinal(), (int)this.facing).ioState != SideData.IOState.OFF) {
            return new FluidTankInfo[]{this.frequency.storedFluid.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return !this.hasFrequency() ? 0 : this.frequency.storedGas.receive(stack, doTransfer);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return !this.hasFrequency() ? null : this.frequency.storedGas.draw(amount, doTransfer);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (int)side.ordinal(), (int)this.facing).ioState == SideData.IOState.INPUT) {
            return this.frequency.storedGas.getGasType() == null || type == this.frequency.storedGas.getGasType();
        }
        return false;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (int)side.ordinal(), (int)this.facing).ioState == SideData.IOState.OUTPUT) {
            return this.frequency.storedGas.getGasType() == null || type == this.frequency.storedGas.getGasType();
        }
        return false;
    }

    @Override
    public boolean handleInventory() {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ItemStack func_70301_a(int slotID) {
        return this.hasFrequency() && slotID == 0 ? this.frequency.storedItem : null;
    }

    @Override
    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.hasFrequency() && slotID == 0) {
            this.frequency.storedItem = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    @Override
    public double getTemp() {
        return this.hasFrequency() ? this.frequency.temperature : 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 1000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        if (this.hasFrequency()) {
            this.frequency.temperature += this.heatToAbsorb;
        }
        this.heatToAbsorb = 0.0;
        return this.hasFrequency() ? this.frequency.temperature : 0.0;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.HEAT, (int)side.ordinal(), (int)this.facing).ioState != SideData.IOState.OFF;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.HEAT, (int)side.ordinal(), (int)this.facing).ioState == SideData.IOState.INPUT && adj instanceof IHeatTransfer) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    @Override
    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (int)side, (int)this.facing).ioState == SideData.IOState.INPUT;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (int)side, (int)this.facing).ioState != SideData.IOState.OFF) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (int)side, (int)this.facing).ioState == SideData.IOState.OUTPUT;
    }

    @Override
    public Object[] getTanks() {
        if (!this.hasFrequency()) {
            return null;
        }
        return new Object[]{this.frequency.storedFluid, this.frequency.storedGas};
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (int)side.ordinal(), (int)this.facing).ioState != SideData.IOState.OFF;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (!(arguments[0] instanceof String) || !(arguments[1] instanceof Integer)) {
                    return new Object[]{"Invalid parameters."};
                }
                String freq = ((String)arguments[0]).trim();
                int access = (Integer)arguments[1];
                this.setFrequency(freq, ISecurityTile.SecurityMode.values()[access]);
                return new Object[]{"Frequency set."};
            }
        }
        throw new NoSuchMethodException();
    }
}

