/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import mekanism.common.base.ISustainedInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryPersonalChest
extends InventoryBasic {
    public EntityPlayer entityPlayer;
    public ItemStack itemStack;
    public boolean reading;

    public InventoryPersonalChest(EntityPlayer player) {
        super("PersonalChest", false, 55);
        this.entityPlayer = player;
        this.read();
    }

    public InventoryPersonalChest(ItemStack stack) {
        super("PersonalChest", false, 55);
        this.itemStack = stack;
        this.read();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.write();
        }
    }

    public void func_70295_k_() {
        this.read();
    }

    public void func_70305_f() {
        this.write();
    }

    public void write() {
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < this.func_70302_i_(); ++slotCount) {
            if (this.func_70301_a(slotCount) == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            this.func_70301_a(slotCount).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        if (this.getStack() != null) {
            if (this.getStack().func_77973_b() instanceof ISustainedInventory) {
                ((ISustainedInventory)this.getStack().func_77973_b()).setInventory(tagList, this.getStack());
            } else {
                System.out.println("Avoiding a server crash as : " + this.getStack().func_77973_b().getClass().getName() + " is not a sustained inventory.");
            }
        }
    }

    public void read() {
        if (this.reading) {
            return;
        }
        if (this.getStack() != null && !(this.getStack().func_77973_b() instanceof ISustainedInventory)) {
            return;
        }
        this.reading = true;
        NBTTagList tagList = ((ISustainedInventory)this.getStack().func_77973_b()).getInventory(this.getStack());
        if (tagList != null) {
            for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
                NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
                byte slotID = tagCompound.func_74771_c("Slot");
                if (slotID < 0 || slotID >= this.func_70302_i_()) continue;
                this.func_70299_a(slotID, ItemStack.func_77949_a((NBTTagCompound)tagCompound));
            }
        }
        this.reading = false;
    }

    public ItemStack getStack() {
        return this.itemStack != null ? this.itemStack : this.entityPlayer.func_71045_bC();
    }
}

