/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.frequency;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.security.ISecurityTile;
import net.minecraft.nbt.NBTTagCompound;

public class Frequency {
    public static final String TELEPORTER = "Teleporter";
    public String name;
    public String owner;
    public boolean valid = true;
    public ISecurityTile.SecurityMode access = ISecurityTile.SecurityMode.PUBLIC;
    public Set<Coord4D> activeCoords = new HashSet<Coord4D>();

    public Frequency(String n, String o) {
        this.name = n;
        this.owner = o;
    }

    public Frequency(NBTTagCompound nbtTags) {
        this.read(nbtTags);
    }

    public Frequency(ByteBuf dataStream) {
        this.read(dataStream);
    }

    public Frequency setAccess(ISecurityTile.SecurityMode access) {
        this.access = access;
        return this;
    }

    public boolean isPublic() {
        return this.access == ISecurityTile.SecurityMode.PUBLIC;
    }

    public boolean isPrivate() {
        return this.access == ISecurityTile.SecurityMode.PRIVATE;
    }

    public boolean isProtected() {
        return this.access == ISecurityTile.SecurityMode.TRUSTED;
    }

    public Coord4D getClosestCoords(Coord4D coord) {
        Coord4D closest = null;
        for (Coord4D iterCoord : this.activeCoords) {
            if (iterCoord.equals(coord)) continue;
            if (closest == null) {
                closest = iterCoord;
                continue;
            }
            if (coord.dimensionId != closest.dimensionId && coord.dimensionId == iterCoord.dimensionId) {
                closest = iterCoord;
                continue;
            }
            if (coord.dimensionId == closest.dimensionId && coord.dimensionId != iterCoord.dimensionId || coord.distanceTo(closest) <= coord.distanceTo(iterCoord)) continue;
            closest = iterCoord;
        }
        return closest;
    }

    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74778_a("name", this.name);
        nbtTags.func_74778_a("owner", this.owner);
        nbtTags.func_74768_a("access", this.access.ordinal());
    }

    protected void read(NBTTagCompound nbtTags) {
        boolean isPublic;
        this.name = nbtTags.func_74779_i("name");
        this.owner = nbtTags.func_74779_i("owner");
        this.access = nbtTags.func_74764_b("access") ? ISecurityTile.SecurityMode.values()[nbtTags.func_74762_e("access")] : ((isPublic = nbtTags.func_74767_n("publicFreq")) ? ISecurityTile.SecurityMode.PUBLIC : ISecurityTile.SecurityMode.PRIVATE);
    }

    public void write(ArrayList data) {
        data.add(this.name);
        data.add(this.owner);
        data.add(this.access.ordinal());
    }

    protected void read(ByteBuf dataStream) {
        this.name = PacketHandler.readString(dataStream);
        this.owner = PacketHandler.readString(dataStream);
        this.access = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.name.hashCode();
        code = 31 * code + this.owner.hashCode();
        code = 31 * code + this.access.hashCode();
        return code;
    }

    public boolean equals(Object obj) {
        return obj instanceof Frequency && ((Frequency)obj).name.equals(this.name) && ((Frequency)obj).owner.equals(this.owner) && ((Frequency)obj).access == this.access;
    }
}

