/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.bugfixmod.coremod.patchers;

import java.util.Iterator;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.foamfix.bugfixmod.coremod.BugfixModClassTransformer;
import pl.asie.foamfix.bugfixmod.coremod.patchers.GlobalModificationPatcher;
import pl.asie.foamfix.bugfixmod.coremod.patchers.ModificationPatcher;

public abstract class AbstractPatcher {
    public String patcherName;
    protected String targetClassName;
    protected String targetMethodName;
    protected String targetMethodDesc;
    protected boolean successful;

    public AbstractPatcher(String name, String targetClassName, String targetMethodName, String targetMethodDesc) {
        this.patcherName = name;
        this.targetClassName = targetClassName.replace('/', '.');
        this.targetMethodName = targetMethodName;
        this.targetMethodDesc = targetMethodDesc;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    protected void patchMethodNode(MethodNode method) {
        if (this instanceof GlobalModificationPatcher) {
            ((GlobalModificationPatcher)((Object)this)).modifyInsnsGlobal(method.instructions);
        } else {
            ListIterator instructionSet = method.instructions.iterator();
            if (this instanceof ModificationPatcher) {
                while (instructionSet.hasNext()) {
                    AbstractInsnNode currentInstruction = (AbstractInsnNode)instructionSet.next();
                    ((ModificationPatcher)((Object)this)).modifyInsns(currentInstruction, instructionSet, method.instructions);
                }
            } else {
                while (instructionSet.hasNext()) {
                    AbstractInsnNode currentInstruction = (AbstractInsnNode)instructionSet.next();
                    InsnList toInject = this.buildNewInsns(currentInstruction, instructionSet);
                    if (toInject == null || toInject.size() <= 0) continue;
                    method.instructions.insert(currentInstruction, toInject);
                }
            }
        }
    }

    protected void patchClassNode(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (this.targetMethodName != null && !method.name.equals(this.targetMethodName) || this.targetMethodDesc != null && !method.desc.equals(this.targetMethodDesc)) continue;
            if (this.targetMethodName != null) {
                this.printMessage("Found target method");
            }
            this.patchMethodNode(method);
        }
    }

    public byte[] patch(String transformedName, byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = null;
        try {
            classReader = new ClassReader(bytes);
        }
        catch (NullPointerException e) {
            return bytes;
        }
        classReader.accept((ClassVisitor)classNode, 0);
        this.successful = false;
        this.patchClassNode(classNode);
        if (!this.successful) {
            if (!this.targetClassName.isEmpty()) {
                this.printMessage("Failed to apply transform!");
            }
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        if (!this.targetClassName.isEmpty()) {
            this.printMessage(this.successful ? "Applied transform!" : "Failed to apply transform!");
        }
        return writer.toByteArray();
    }

    public abstract InsnList buildNewInsns(AbstractInsnNode var1, Iterator<AbstractInsnNode> var2);

    public String getPatcherName() {
        return this.patcherName;
    }

    public void printMessage(String message) {
        BugfixModClassTransformer.instance.logger.info("[" + this.getPatcherName() + "] " + message);
    }
}

