/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.spongemixins;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import sun.misc.URLClassPath;

public final class MinecraftURLClassPath {
    private static final Path MOD_DIRECTORY_PATH = new File(Launch.minecraftHome, "mods/").toPath();
    private static final Field modClassLoaderField;
    private static final Field loaderinstanceField;
    private static final Field mainClassLoaderField;
    private static final Field ucpField;
    private static final ModClassLoader modClassLoader;
    private static final LaunchClassLoader mainClassLoader;
    private static final URLClassPath ucp;

    public static File getJarInModPath(String jarname) {
        try {
            return Files.walk(MOD_DIRECTORY_PATH, new FileVisitOption[0]).filter(p -> {
                String filename = p.toString();
                String extension = com.google.common.io.Files.getFileExtension((String)filename);
                return com.google.common.io.Files.getNameWithoutExtension((String)filename).contains(jarname) && ("jar".equals(extension) || "litemod".equals(extension));
            }).map(Path::toFile).findFirst().orElse(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean findJarInClassPath(String jarname) {
        for (URL url : ucp.getURLs()) {
            String filename = url.getFile();
            String extension = com.google.common.io.Files.getFileExtension((String)filename);
            if (!com.google.common.io.Files.getNameWithoutExtension((String)filename).contains(jarname) || !"jar".equals(extension) && !"litemod".equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static void addJar(File pathToJar) throws Exception {
        ucp.addURL(pathToJar.toURI().toURL());
    }

    private MinecraftURLClassPath() {
    }

    static {
        try {
            modClassLoaderField = Loader.class.getDeclaredField("modClassLoader");
            modClassLoaderField.setAccessible(true);
            loaderinstanceField = Loader.class.getDeclaredField("instance");
            loaderinstanceField.setAccessible(true);
            mainClassLoaderField = ModClassLoader.class.getDeclaredField("mainClassLoader");
            mainClassLoaderField.setAccessible(true);
            ucpField = LaunchClassLoader.class.getSuperclass().getDeclaredField("ucp");
            ucpField.setAccessible(true);
            Object loader = loaderinstanceField.get(null);
            modClassLoader = (ModClassLoader)modClassLoaderField.get(loader);
            mainClassLoader = (LaunchClassLoader)mainClassLoaderField.get(modClassLoader);
            ucp = (URLClassPath)ucpField.get(mainClassLoader);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

