/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.updates;

import com.falsepattern.lib.StableAPI;
import lombok.NonNull;
import org.apache.logging.log4j.Logger;

@StableAPI(since="0.8.0")
public class ModUpdateInfo {
    @StableAPI.Expose
    @NonNull
    public final String modID;
    @StableAPI.Expose
    @NonNull
    public final String currentVersion;
    @StableAPI.Expose
    @NonNull
    public final String latestVersion;
    @StableAPI.Expose
    @NonNull
    public final String updateURL;

    @StableAPI.Expose
    public void log(Logger logger) {
        logger.info("Updates are available for mod {}: Currently installed version is {}, latest available version is {}. Update URL: {}", new Object[]{this.modID, this.currentVersion, this.latestVersion, this.updateURL.isEmpty() ? "unavailable" : this.updateURL});
    }

    public ModUpdateInfo(@NonNull String modID, @NonNull String currentVersion, @NonNull String latestVersion, @NonNull String updateURL) {
        if (modID == null) {
            throw new NullPointerException("modID is marked non-null but is null");
        }
        if (currentVersion == null) {
            throw new NullPointerException("currentVersion is marked non-null but is null");
        }
        if (latestVersion == null) {
            throw new NullPointerException("latestVersion is marked non-null but is null");
        }
        if (updateURL == null) {
            throw new NullPointerException("updateURL is marked non-null but is null");
        }
        this.modID = modID;
        this.currentVersion = currentVersion;
        this.latestVersion = latestVersion;
        this.updateURL = updateURL;
    }

    @NonNull
    public String getModID() {
        return this.modID;
    }

    @NonNull
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @NonNull
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @NonNull
    public String getUpdateURL() {
        return this.updateURL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModUpdateInfo)) {
            return false;
        }
        ModUpdateInfo other = (ModUpdateInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modID = this.getModID();
        String other$modID = other.getModID();
        if (this$modID == null ? other$modID != null : !this$modID.equals(other$modID)) {
            return false;
        }
        String this$currentVersion = this.getCurrentVersion();
        String other$currentVersion = other.getCurrentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !this$currentVersion.equals(other$currentVersion)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$updateURL = this.getUpdateURL();
        String other$updateURL = other.getUpdateURL();
        return !(this$updateURL == null ? other$updateURL != null : !this$updateURL.equals(other$updateURL));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModUpdateInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modID = this.getModID();
        result = result * 59 + ($modID == null ? 43 : $modID.hashCode());
        String $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : $currentVersion.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $updateURL = this.getUpdateURL();
        result = result * 59 + ($updateURL == null ? 43 : $updateURL.hashCode());
        return result;
    }

    public String toString() {
        return "ModUpdateInfo(modID=" + this.getModID() + ", currentVersion=" + this.getCurrentVersion() + ", latestVersion=" + this.getLatestVersion() + ", updateURL=" + this.getUpdateURL() + ")";
    }
}

