/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.mixin.ITargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

@StableAPI(since="0.8.0")
public interface IMixin {
    @StableAPI.Expose
    public String getMixin();

    @StableAPI.Expose
    public Side getSide();

    @StableAPI.Expose
    public Predicate<List<ITargetedMod>> getFilter();

    default public boolean shouldLoad(List<ITargetedMod> loadedMods) {
        Side side = this.getSide();
        return (side == Side.COMMON || side == Side.SERVER && FMLLaunchHandler.side().isServer() || side == Side.CLIENT && FMLLaunchHandler.side().isClient()) && this.getFilter().test(loadedMods);
    }

    @StableAPI(since="0.10.0")
    public static final class PredicateHelpers {
        @StableAPI.Expose
        public static Predicate<List<ITargetedMod>> never() {
            return list -> false;
        }

        @StableAPI.Expose
        public static Predicate<List<ITargetedMod>> condition(Supplier<Boolean> condition) {
            return list -> (Boolean)condition.get();
        }

        @StableAPI.Expose
        public static Predicate<List<ITargetedMod>> always() {
            return list -> true;
        }

        @StableAPI.Expose
        public static Predicate<List<ITargetedMod>> require(ITargetedMod mod) {
            return list -> list.contains(mod);
        }

        @StableAPI.Expose
        public static Predicate<List<ITargetedMod>> avoid(ITargetedMod mod) {
            return list -> !list.contains(mod);
        }
    }

    @StableAPI(since="0.10.0")
    public static enum Side {
        COMMON,
        CLIENT,
        SERVER;

    }
}

