/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.proxy;

import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.event.ClientEventHandlerPost;
import com.falsepattern.lib.internal.impl.config.event.ClientEventHandlerPre;
import com.falsepattern.lib.internal.impl.toast.GuiToastImpl;
import com.falsepattern.lib.internal.proxy.CommonProxy;
import com.falsepattern.lib.updates.UpdateChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private CompletableFuture<List<IChatComponent>> chatFuture;

    @Override
    public void construct(FMLConstructionEvent e) {
        super.construct(e);
        GuiToastImpl.initialize(Minecraft.func_71410_x());
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        ClientEventHandlerPre.registerBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        ClientEventHandlerPost.registerBus();
        this.chatFuture = this.updatesFuture.handleAsync((updates, exception) -> {
            if (exception != null || updates.isEmpty()) {
                return Collections.emptyList();
            }
            return UpdateChecker.updateListToChatMessages("FalsePatternLib", updates);
        });
    }

    @SubscribeEvent
    public void onSinglePlayer(EntityJoinWorldEvent e) {
        if (this.chatFuture == null || !(e.entity instanceof EntityPlayerSP)) {
            return;
        }
        EntityPlayerSP player = (EntityPlayerSP)e.entity;
        try {
            for (IChatComponent line : this.chatFuture.get()) {
                player.func_145747_a(line);
            }
            this.chatFuture = null;
        }
        catch (Exception ex) {
            Share.LOG.warn((Object)ex);
        }
    }
}

