/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.impl.config.ConfigElementProxy;
import com.falsepattern.lib.internal.impl.config.ConfigurationManagerImpl;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import com.falsepattern.lib.internal.impl.config.fields.BooleanConfigField;
import com.falsepattern.lib.internal.impl.config.fields.BooleanListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.DoubleConfigField;
import com.falsepattern.lib.internal.impl.config.fields.DoubleListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.EnumConfigField;
import com.falsepattern.lib.internal.impl.config.fields.FloatConfigField;
import com.falsepattern.lib.internal.impl.config.fields.IntConfigField;
import com.falsepattern.lib.internal.impl.config.fields.IntListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.StringConfigField;
import com.falsepattern.lib.internal.impl.config.fields.StringListConfigField;
import cpw.mods.fml.client.config.IConfigElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ParsedConfiguration {
    private static final Map<Class<?>, FieldRefConstructor> constructors = new HashMap();
    public final Class<?> configClass;
    public final String modid;
    public final String category;
    public final Configuration rawConfig;
    public final boolean sync;
    private final Map<String, AConfigField<?>> fields = new HashMap();
    private final Map<String, IConfigElement<?>> elements = new HashMap();
    private int maxFieldNameLength;

    public static ParsedConfiguration parseConfig(Class<?> configClass) throws ConfigException {
        Config cfg = Optional.ofNullable(configClass.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + configClass.getName() + " does not have a @Config annotation!"));
        String category = Optional.of(cfg.category().trim()).map(cat -> cat.length() == 0 ? null : cat).orElseThrow(() -> new ConfigException("Config class " + configClass.getName() + " has an empty category!"));
        Configuration rawConfig = ConfigurationManagerImpl.getForgeConfig(cfg.modid());
        ParsedConfiguration parsedConfig = new ParsedConfiguration(configClass, cfg.modid(), category, rawConfig, configClass.isAnnotationPresent(Config.Synchronize.class));
        try {
            parsedConfig.reloadFields();
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(e);
        }
        return parsedConfig;
    }

    public void save() {
        for (AConfigField<?> field : this.fields.values()) {
            field.save();
        }
        this.rawConfig.save();
    }

    public void configChanged() {
        for (AConfigField<?> field : this.fields.values()) {
            field.load();
        }
        this.rawConfig.save();
    }

    public void load() throws ConfigException {
        ConfigurationManagerImpl.loadRawConfig(this.rawConfig);
        for (AConfigField<?> field : this.fields.values()) {
            field.load();
        }
    }

    public void receive(DataInput input) throws IOException {
        if (this.sync) {
            HashMap syncFields = new HashMap(this.fields);
            for (String key : this.fields.keySet()) {
                if (!syncFields.get((Object)key).noSync) continue;
                syncFields.remove(key);
            }
            while (syncFields.size() > 0) {
                String fieldName = StringConfigField.receiveString(input, this.maxFieldNameLength, "field name", this.configClass.getName());
                if (!syncFields.containsKey(fieldName)) {
                    throw new IOException("Invalid sync field name received: " + fieldName + " for config class " + this.configClass.getName());
                }
                syncFields.remove(fieldName).receive(input);
            }
        }
    }

    public void transmit(DataOutput output) throws IOException {
        if (this.sync) {
            HashMap syncFields = new HashMap(this.fields);
            for (String string : this.fields.keySet()) {
                if (!syncFields.get((Object)string).noSync) continue;
                syncFields.remove(string);
            }
            for (Map.Entry entry : syncFields.entrySet()) {
                StringConfigField.transmitString(output, (String)entry.getKey());
                ((AConfigField)entry.getValue()).transmit(output);
            }
        }
    }

    public void reloadFields() throws ConfigException, IllegalAccessException {
        this.fields.clear();
        this.maxFieldNameLength = 0;
        ConfigCategory cat = this.rawConfig.getCategory(this.category);
        if (this.configClass.isAnnotationPresent(Config.RequiresWorldRestart.class)) {
            cat.setRequiresWorldRestart(true);
        }
        if (this.configClass.isAssignableFrom(Config.RequiresMcRestart.class)) {
            cat.setRequiresMcRestart(true);
        }
        for (Field field : this.configClass.getDeclaredFields()) {
            AConfigField<?> configField;
            if (field.getAnnotation(Config.Ignore.class) != null && (field.getModifiers() & 0x10) != 0) continue;
            field.setAccessible(true);
            this.maxFieldNameLength = Math.max(this.maxFieldNameLength, field.getName().length());
            Class<?> fieldClass = field.getType();
            String name = field.getName();
            if (constructors.containsKey(fieldClass)) {
                configField = constructors.get(fieldClass).construct(field, this.rawConfig, this.category);
                this.fields.put(name, configField);
            } else if (fieldClass.isEnum()) {
                configField = new EnumConfigField(field, this.rawConfig, this.category);
                this.fields.put(name, configField);
            } else {
                throw new ConfigException("Illegal config field: " + field.getName() + " in " + this.configClass.getName() + ": Unsupported type " + fieldClass.getName() + "! Did you forget an @Ignore annotation?");
            }
            if (field.isAnnotationPresent(Config.RequiresMcRestart.class)) {
                cat.setRequiresMcRestart(true);
            }
            if (field.isAnnotationPresent(Config.RequiresWorldRestart.class)) {
                cat.setRequiresWorldRestart(true);
            }
            configField.init();
            this.elements.computeIfAbsent(name, name2 -> new ConfigElementProxy(configField.getProperty(), () -> {
                configField.load();
                this.save();
            }));
        }
    }

    public List<IConfigElement> getConfigElements() {
        return new ArrayList<IConfigElement>(this.elements.values());
    }

    public boolean validate(BiConsumer<Class<?>, Field> invalidFieldHandler, boolean resetInvalid) {
        boolean valid = true;
        for (AConfigField<?> field : this.fields.values()) {
            if (field.validateField()) continue;
            if (resetInvalid) {
                field.setToDefault();
            }
            invalidFieldHandler.accept(this.configClass, field.getJavaField());
            valid = false;
        }
        return valid;
    }

    private ParsedConfiguration(Class<?> configClass, String modid, String category, Configuration rawConfig, boolean sync) {
        this.configClass = configClass;
        this.modid = modid;
        this.category = category;
        this.rawConfig = rawConfig;
        this.sync = sync;
    }

    static {
        constructors.put(Boolean.class, BooleanConfigField::new);
        constructors.put(Boolean.TYPE, BooleanConfigField::new);
        constructors.put(Integer.class, IntConfigField::new);
        constructors.put(Integer.TYPE, IntConfigField::new);
        constructors.put(Float.class, FloatConfigField::new);
        constructors.put(Float.TYPE, FloatConfigField::new);
        constructors.put(Double.class, DoubleConfigField::new);
        constructors.put(Double.TYPE, DoubleConfigField::new);
        constructors.put(String.class, StringConfigField::new);
        constructors.put(boolean[].class, BooleanListConfigField::new);
        constructors.put(int[].class, IntListConfigField::new);
        constructors.put(double[].class, DoubleListConfigField::new);
        constructors.put(String[].class, StringListConfigField::new);
    }

    private static interface FieldRefConstructor {
        public AConfigField<?> construct(Field var1, Configuration var2, String var3) throws ConfigException;
    }
}

