/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm;

import com.falsepattern.lib.asm.IClassNodeTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ITypeDiscovererTransformer
implements IClassNodeTransformer {
    @Override
    public String getName() {
        return "ITypeDiscovererTransformer";
    }

    @Override
    public boolean shouldTransform(ClassNode cn, String transformedName, boolean obfuscated) {
        return "cpw.mods.fml.common.discovery.ITypeDiscoverer".equals(transformedName);
    }

    @Override
    public void transform(ClassNode cn, String transformedName, boolean obfuscated) {
        for (MethodNode method : cn.methods) {
            if (!method.name.equals("<clinit>")) continue;
            InsnList instructions = method.instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                AbstractInsnNode insn = instructions.get(i);
                if (!(insn instanceof LdcInsnNode)) continue;
                LdcInsnNode ldc = (LdcInsnNode)insn;
                if (!ldc.cst.equals("[^\\s\\$]+(\\$[^\\s]+)?\\.class$")) continue;
                ldc.cst = "(?!module-info)[^\\s\\$]+(\\$[^\\s]+)?\\.class$";
                return;
            }
        }
    }
}

