/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class Internet {
    public static void connect(URL URL2, Consumer<Exception> onError, Consumer<InputStream> onSuccess) {
        try {
            HttpURLConnection connection = (HttpURLConnection)URL2.openConnection();
            connection.setConnectTimeout(3500);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "FalsePatternLib 0.10.15 Internet Connector (https://github.com/FalsePattern/FalsePatternLib)");
            if (connection.getResponseCode() != 200) {
                onError.accept(new Exception("HTTP response code " + connection.getResponseCode()));
            } else {
                onSuccess.accept(connection.getInputStream());
            }
            connection.disconnect();
        }
        catch (Exception e) {
            onError.accept(e);
        }
    }

    public static CompletableFuture<byte[]> download(URL URL2) {
        return CompletableFuture.supplyAsync(() -> {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            AtomicReference caught = new AtomicReference();
            Internet.connect(URL2, caught::set, input -> {
                try {
                    Internet.transferAndClose(input, result);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            });
            return result.toByteArray();
        });
    }

    public static void transferAndClose(InputStream is, OutputStream target) throws IOException {
        int bytesRead = 0;
        byte[] smallBuffer = new byte[4096];
        while ((bytesRead = is.read(smallBuffer)) >= 0) {
            target.write(smallBuffer, 0, bytesRead);
        }
        target.close();
        is.close();
    }
}

