/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.util.MathUtil;
import javax.annotation.concurrent.Immutable;
import lombok.NonNull;

@StableAPI(since="0.6.0")
@Immutable
public class Vec3i
implements Comparable<Vec3i> {
    @StableAPI.Expose
    public static final Vec3i NULL_VECTOR = new Vec3i(0, 0, 0);
    @StableAPI.Expose
    protected final int x;
    @StableAPI.Expose
    protected final int y;
    @StableAPI.Expose
    protected final int z;

    @StableAPI.Expose
    public Vec3i(double x, double y, double z) {
        this(MathUtil.floor(x), MathUtil.floor(y), MathUtil.floor(z));
    }

    @Override
    public int compareTo(@NonNull Vec3i vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        return this.y == vec.getY() ? (this.z == vec.getZ() ? this.x - vec.getX() : this.z - vec.getZ()) : this.y - vec.getY();
    }

    @StableAPI.Expose
    public Vec3i crossProduct(@NonNull Vec3i vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        return new Vec3i(this.y * vec.getZ() - this.z * vec.getY(), this.z * vec.getX() - this.x * vec.getZ(), this.x * vec.getY() - this.y * vec.getX());
    }

    @StableAPI.Expose
    public double getDistance(int x, int y, int z) {
        return Math.sqrt(this.distanceSq(x, y, z));
    }

    @StableAPI.Expose
    public double distanceSq(int x, int y, int z) {
        int dX = this.x - x;
        int dY = this.y - y;
        int dZ = this.z - z;
        return dX * dX + dY * dY + dZ * dZ;
    }

    @StableAPI.Expose
    public double distanceSq(@NonNull Vec3i vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        return this.distanceSq(vec.getX(), vec.getY(), vec.getZ());
    }

    @StableAPI.Expose
    public double distanceSqToCenter(double x, double y, double z) {
        double dX = (double)this.x + 0.5 - x;
        double dY = (double)this.y + 0.5 - y;
        double dZ = (double)this.z + 0.5 - z;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vec3i)) {
            return false;
        }
        Vec3i other = (Vec3i)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vec3i;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        return result;
    }

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

