/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import ivorius.ivtoolkit.asm.IvDevRemapper;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class IvClassTransformer {
    public Logger logger;

    protected IvClassTransformer(Logger logger) {
        this.logger = logger;
    }

    public void printSubMethodError(String className, String methodID, String submethodID) {
        this.logger.error("Could not patch " + className + "." + methodID + " (" + submethodID + ")!");
    }

    public static String getMethodDescriptor(Object returnValue, Object ... params) {
        Type[] types = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = IvClassTransformer.getType(params[i]);
        }
        return Type.getMethodDescriptor((Type)IvClassTransformer.getType(returnValue), (Type[])types);
    }

    private static Type getType(Object obj) {
        if (obj instanceof Type) {
            return (Type)obj;
        }
        if (obj instanceof Class) {
            return Type.getType((Class)((Class)obj));
        }
        if (obj instanceof String) {
            return Type.getObjectType((String)((String)obj));
        }
        throw new IllegalArgumentException();
    }

    public static String getSRGDescriptor(String signature) {
        return FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(signature);
    }

    public static String getSrgName(MethodInsnNode node) {
        return IvDevRemapper.getSRGName(FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(node.owner, node.name, node.desc));
    }

    public static String getSrgName(String className, MethodNode node) {
        return IvDevRemapper.getSRGName(FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(className, node.name, node.desc));
    }

    public static String getSrgName(FieldInsnNode node) {
        return IvDevRemapper.getSRGName(FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(node.owner, node.name, node.desc));
    }

    public static String getSrgClassName(String className) {
        return FMLDeobfuscatingRemapper.INSTANCE.map(className);
    }

    public byte[] transform(String actualClassName, String srgClassName, byte[] data, boolean obf) {
        ClassNode classNode = null;
        boolean didChange = false;
        try {
            classNode = new ClassNode();
            ClassReader classReader = new ClassReader(data);
            classReader.accept((ClassVisitor)classNode, 0);
        }
        catch (Exception ex) {
            this.logger.error("Error patching class PRE " + actualClassName + " (" + srgClassName + ")!", (Throwable)ex);
            return data;
        }
        try {
            didChange = this.transform(actualClassName.replaceAll("\\.", "/"), classNode, obf);
        }
        catch (Exception ex) {
            this.logger.error("Error patching class MAIN " + actualClassName + " (" + srgClassName + ")!", (Throwable)ex);
            return data;
        }
        if (didChange) {
            try {
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            catch (Exception ex) {
                this.logger.error("Error patching class POST " + actualClassName + " (" + srgClassName + ")!", (Throwable)ex);
                return data;
            }
        }
        return data;
    }

    public abstract boolean transform(String var1, ClassNode var2, boolean var3);
}

