/*
 * Decompiled with CFR 0.152.
 */
package defense.common.potion;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import defense.api.IAntiPoisonArmor;
import defense.api.IAntiPoisonBlock;
import defense.common.Settings;
import java.util.EnumSet;
import java.util.HashMap;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class Poison {
    static HashMap<String, Poison> poisons = new HashMap();
    static BiMap<String, Integer> poisonIDs = HashBiMap.create();
    private static int maxID = 0;
    protected String name;
    protected EnumSet<ArmorType> armorRequired = EnumSet.range(ArmorType.HELM, ArmorType.BOOTS);
    protected final boolean isDisabled;

    public static Poison getPoison(String name) {
        return poisons.get(name);
    }

    public static Poison getPoison(int id) {
        return poisons.get(Poison.getName(id));
    }

    public static String getName(int fluidID) {
        return (String)poisonIDs.inverse().get((Object)fluidID);
    }

    public static int getID(String name) {
        return (Integer)poisonIDs.get((Object)name);
    }

    public Poison(String name) {
        this.name = name;
        poisons.put(name, this);
        poisonIDs.put((Object)name, (Object)(++maxID));
        this.isDisabled = Settings.CONFIGURATION.get("Disable Poison", "Disable " + this.name, false).getBoolean(false);
    }

    public String getName() {
        return this.name;
    }

    public final int getID() {
        return Poison.getID(this.getName());
    }

    public EnumSet<ArmorType> getArmorRequired() {
        return this.armorRequired;
    }

    public void poisonEntity(Pos3D emitPosition, EntityLivingBase entity, int amplifier) {
        if (!this.isEntityProtected(emitPosition, entity, amplifier)) {
            this.doPoisonEntity(emitPosition, entity, amplifier);
        }
    }

    public void poisonEntity(Pos3D emitPosition, EntityLivingBase entity) {
        this.poisonEntity(emitPosition, entity, 0);
    }

    public boolean isEntityProtected(Pos3D emitPosition, EntityLivingBase entity, int amplifier) {
        EnumSet<ArmorType> armorWorn = EnumSet.noneOf(ArmorType.class);
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            for (int i = 0; i < entityPlayer.field_71071_by.field_70460_b.length; ++i) {
                IAntiPoisonArmor armor;
                if (entityPlayer.field_71071_by.field_70460_b[i] == null || !(entityPlayer.field_71071_by.field_70460_b[i].func_77973_b() instanceof IAntiPoisonArmor) || !(armor = (IAntiPoisonArmor)entityPlayer.field_71071_by.field_70460_b[i].func_77973_b()).isProtectedFromPoison(entityPlayer.field_71071_by.field_70460_b[i], entity, this.getName())) continue;
                armorWorn.add(ArmorType.values()[armor.getArmorType() % ArmorType.values().length]);
                armor.onProtectFromPoison(entityPlayer.field_71071_by.field_70460_b[i], entity, this.getName());
            }
        }
        return armorWorn.containsAll(this.armorRequired);
    }

    public int getAntiPoisonBlockCount(World world, Pos3D startingPosition, Pos3D endingPosition) {
        Pos3D delta = endingPosition.clone().diff(startingPosition).normalize();
        Pos3D targetPosition = startingPosition.clone();
        double totalDistance = startingPosition.distance(endingPosition);
        int count = 0;
        if (totalDistance > 1.0) {
            while (targetPosition.distance(endingPosition) <= totalDistance) {
                Block block = targetPosition.getCoord(world.field_73011_w.field_76574_g).getBlock((IBlockAccess)world);
                if (!world.func_147437_c((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos) && block instanceof IAntiPoisonBlock && ((IAntiPoisonBlock)block).isPoisonPrevention(world, (int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos, this.getName())) {
                    ++count;
                }
                targetPosition.translate(delta);
            }
        }
        return count;
    }

    protected abstract void doPoisonEntity(Pos3D var1, EntityLivingBase var2, int var3);

    public static enum ArmorType {
        HELM,
        BODY,
        LEGGINGS,
        BOOTS;

    }
}

