/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import defense.api.IEMPBlock;
import defense.api.IEMPItem;
import defense.api.IMissile;
import defense.api.RadarRegistry;
import defense.common.DefenseTech;
import defense.common.Vector2;
import defense.common.entity.EntityExplosive;
import defense.common.explosive.blast.Blast;
import ic2.api.item.ISpecialElectricItem;
import ic2.api.tile.IEnergyStorage;
import java.util.List;
import mekanism.api.Pos3D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlastEMP
extends Blast {
    private boolean effectEntities = false;
    private boolean effectBlocks = false;

    public BlastEMP(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastEMP setEffectBlocks() {
        this.effectBlocks = true;
        return this;
    }

    public BlastEMP setEffectEntities() {
        this.effectEntities = true;
        return this;
    }

    @Override
    public void doExplode() {
        if (this.effectBlocks) {
            for (int x = (int)(-this.getRadius()); x < (int)this.getRadius(); ++x) {
                for (int y = (int)(-this.getRadius()); y < (int)this.getRadius(); ++y) {
                    for (int z = (int)(-this.getRadius()); z < (int)this.getRadius(); ++z) {
                        double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                        Pos3D searchPosition = this.position.clone().translate(new Pos3D((double)x, (double)y, (double)z));
                        if (dist > (double)this.getRadius()) continue;
                        if (Math.round(this.position.xPos + (double)y) == (long)((int)this.position.yPos)) {
                            this.field_77287_j.func_72869_a("largesmoke", searchPosition.xPos, searchPosition.yPos, searchPosition.zPos, 0.0, 0.0, 0.0);
                        }
                        Block block = searchPosition.getCoord(this.field_77287_j.field_73011_w.field_76574_g).getBlock((IBlockAccess)this.field_77287_j);
                        TileEntity tileEntity = searchPosition.getCoord(this.field_77287_j.field_73011_w.field_76574_g).getTileEntity((IBlockAccess)this.field_77287_j);
                        if (!this.field_77287_j.func_147437_c((int)searchPosition.xPos, (int)searchPosition.yPos, (int)searchPosition.zPos) && block instanceof IEMPBlock) {
                            ((IEMPBlock)block).onEMP(this.field_77287_j, (int)searchPosition.xPos, (int)searchPosition.yPos, (int)searchPosition.zPos, this);
                        }
                        if (tileEntity == null) continue;
                        try {
                            if (tileEntity instanceof IStrictEnergyStorage) {
                                ((IStrictEnergyStorage)tileEntity).setEnergy(0.0);
                            }
                            if (MekanismUtils.useIC2() && tileEntity instanceof IEnergyStorage) {
                                ((IEnergyStorage)tileEntity).setStored(0);
                                continue;
                            }
                            if (!MekanismUtils.useRF() || !(tileEntity instanceof IEnergyHandler)) continue;
                            ((IEnergyHandler)tileEntity).extractEnergy(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, false);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.effectEntities) {
            List<Entity> entitiesNearby = RadarRegistry.getEntitiesWithinRadius(new Vector2(this.position), (int)this.getRadius());
            for (Entity entity : entitiesNearby) {
                if (!(entity instanceof IMissile) || entity.func_70028_i((Entity)this.controller) || ((IMissile)entity).getTicksInAir() <= -1) continue;
                ((IMissile)entity).dropMissileAsItem();
            }
            int maxFx = 10;
            AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.xPos - (double)this.getRadius()), (double)(this.position.yPos - (double)this.getRadius()), (double)(this.position.zPos - (double)this.getRadius()), (double)(this.position.xPos + (double)this.getRadius()), (double)(this.position.yPos + (double)this.getRadius()), (double)(this.position.zPos + (double)this.getRadius()));
            List entities = this.field_77287_j.func_72872_a(Entity.class, bounds);
            for (Entity entity : entities) {
                if (entity instanceof EntityLivingBase) {
                    if (this.field_77287_j.field_72995_K && maxFx > 0) {
                        DefenseTech.proxy.spawnShock(this.field_77287_j, this.position, new Pos3D(entity), 20);
                        --maxFx;
                    }
                    if (entity instanceof EntityCreeper && !this.field_77287_j.field_72995_K) {
                        try {
                            ((EntityCreeper)entity).func_70096_w().func_75692_b(17, (Object)1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!(entity instanceof EntityPlayer)) continue;
                    InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack itemStack = inventory.func_70301_a(i);
                        if (itemStack == null) continue;
                        try {
                            if (itemStack.func_77973_b() instanceof IEMPItem) {
                                ((IEMPItem)itemStack.func_77973_b()).onEMP(itemStack, entity, this);
                                continue;
                            }
                            if (itemStack.func_77973_b() instanceof IEnergizedItem) {
                                ((IEnergizedItem)itemStack.func_77973_b()).setEnergy(itemStack, 0.0);
                                continue;
                            }
                            if (MekanismUtils.useRF() && itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                                ((IEnergyContainerItem)itemStack.func_77973_b()).extractEnergy(itemStack, ((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack), false);
                                continue;
                            }
                            if (!MekanismUtils.useIC2() || !(itemStack.func_77973_b() instanceof ISpecialElectricItem)) continue;
                            ((ISpecialElectricItem)itemStack.func_77973_b()).getManager(itemStack).discharge(itemStack, ((ISpecialElectricItem)itemStack.func_77973_b()).getMaxCharge(itemStack), 0, true, false, false);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!(entity instanceof EntityExplosive)) continue;
                entity.func_70106_y();
            }
        }
        DefenseTech.proxy.spawnParticle("shockwave", this.field_77287_j, this.position, 0.0, 0.0, 0.0, 0.0f, 0.0f, 255.0f, 10.0f, 3.0);
        this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:emp", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public long getEnergy() {
        return 3000L;
    }
}

