/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.common.DefenseTech;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.blast.BlastMutation;
import defense.common.potion.CustomPotionEffect;
import java.util.List;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlastChemical
extends Blast {
    private static final int CHECK_BAN_JING = 16;
    private static final float NENG_LIANG = 10.0f;
    private int duration;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private boolean playShortSoundFX;
    private boolean isContagious;
    private boolean isPoisonous;
    private boolean isConfuse;
    private boolean isMutate;

    public BlastChemical(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastChemical(World world, Entity entity, double x, double y, double z, float size, int duration, boolean playShortSoundFX) {
        this(world, entity, x, y, z, size);
        this.duration = duration / this.proceduralInterval();
        this.playShortSoundFX = playShortSoundFX;
    }

    public BlastChemical setRGB(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        return this;
    }

    public BlastChemical setConfuse() {
        this.isConfuse = true;
        return this;
    }

    public BlastChemical setPoison() {
        this.isPoisonous = true;
        return this;
    }

    public BlastChemical setContagious() {
        this.isContagious = true;
        this.isMutate = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        super.doPreExplode();
        if (!this.playShortSoundFX) {
            this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:debilitation", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @Override
    public void doExplode() {
        float radius = this.getRadius();
        if (this.field_77287_j.field_72995_K) {
            for (int i = 0; i < 200; ++i) {
                Pos3D diDian = new Pos3D();
                diDian.xPos = Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f);
                diDian.yPos = Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f);
                diDian.zPos = Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f);
                diDian.scale((double)(Math.min(radius, (float)this.callCount) / 10.0f));
                if (!(diDian.getMagnitude() <= (double)radius)) continue;
                diDian.translate(this.position);
                DefenseTech.proxy.spawnParticle("smoke", this.field_77287_j, diDian, (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0, this.red, this.green, this.blue, 7.0f, 8.0);
            }
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.xPos - (double)radius), (double)(this.position.yPos - (double)radius), (double)(this.position.zPos - (double)radius), (double)(this.position.xPos + (double)radius), (double)(this.position.yPos + (double)radius), (double)(this.position.zPos + (double)radius));
        List allEntities = this.field_77287_j.func_72872_a(EntityLivingBase.class, bounds);
        for (EntityLivingBase entity : allEntities) {
            if (this.isContagious) {
                DefenseTech.contagios_potion.poisonEntity(this.position, entity);
            }
            if (this.isPoisonous) {
                DefenseTech.poisonous_potion.poisonEntity(this.position, entity);
            }
            if (!this.isConfuse) continue;
            entity.func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76431_k.field_76415_H, 360, 0));
            entity.func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76419_f.field_76415_H, 1200, 0));
            entity.func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76421_d.field_76415_H, 1200, 2));
        }
        if (this.isMutate) {
            new BlastMutation(this.field_77287_j, this.field_77283_e, this.position.xPos, this.position.yPos, this.position.zPos, this.getRadius()).explode();
        }
        if (this.playShortSoundFX) {
            this.field_77287_j.func_72908_a(this.position.xPos + 0.5, this.position.yPos + 0.5, this.position.zPos + 0.5, "defense:gasleak", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 1.0f);
        }
        if (this.callCount > this.duration) {
            this.controller.endExplosion();
        }
    }

    @Override
    public long getEnergy() {
        return 20L;
    }

    @Override
    public int proceduralInterval() {
        return 5;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.duration = nbt.func_74762_e("duration");
        this.isContagious = nbt.func_74767_n("isContagious");
        this.isPoisonous = nbt.func_74767_n("isPoisonous");
        this.isConfuse = nbt.func_74767_n("isConfuse");
        this.isMutate = nbt.func_74767_n("isMutate");
        this.red = nbt.func_74760_g("red");
        this.green = nbt.func_74760_g("green");
        this.blue = nbt.func_74760_g("blue");
        this.playShortSoundFX = nbt.func_74767_n("playShortSoundFX");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74757_a("isContagious", this.isContagious);
        nbt.func_74757_a("isPoisonous", this.isPoisonous);
        nbt.func_74757_a("isConfuse", this.isConfuse);
        nbt.func_74757_a("isMutate", this.isMutate);
        nbt.func_74776_a("red", this.red);
        nbt.func_74776_a("green", this.green);
        nbt.func_74776_a("blue", this.blue);
        nbt.func_74757_a("playShortSoundFX", this.playShortSoundFX);
    }
}

