/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.client.model.missile.ModelChemicalMissile;
import defense.client.model.missile.ModelContagiousMissile;
import defense.client.model.missile.ModelMissileBase;
import defense.common.DefenseTechItems;
import defense.common.explosion.Explosion;
import defense.common.explosive.Explosive;
import defense.common.explosive.blast.BlastChemical;
import mekanism.common.recipe.ShapedMekanismRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ExChemical
extends Explosion {
    public ExChemical(String mingZi, int tier) {
        super(mingZi, tier);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        if (this.getTier() == 1) {
            return new ModelChemicalMissile();
        }
        return new ModelContagiousMissile();
    }

    @Override
    public void init() {
        if (this.getTier() == 1) {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(), new Object[]{"@@@", "@?@", "@@@", Character.valueOf('@'), DefenseTechItems.itemPoisonPowder, Character.valueOf('?'), Explosive.debilitation.getItemStack()}));
        } else if (this.getTier() == 2) {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(2), new Object[]{" @ ", "@?@", " @ ", Character.valueOf('?'), Items.field_151078_bh, Character.valueOf('@'), Explosive.chemical.getItemStack()}));
        }
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        if (this.getTier() == 1) {
            new BlastChemical(world, entity, x, y, z, 20.0f, 600, false).setPoison().setRGB(0.8f, 0.8f, 0.0f).explode();
        } else if (this.getTier() == 2) {
            new BlastChemical(world, entity, x, y, z, 20.0f, 600, false).setContagious().setRGB(0.3f, 0.8f, 0.0f).explode();
        }
    }
}

