/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.EnumUtils;
import org.apache.logging.log4j.Logger;

public class AnnotationBasedConfigHelper {
    private Logger logger;
    private Class<?> theConfigClass;

    public AnnotationBasedConfigHelper(Class<?> theConfigClass, Logger logger) {
        this.logger = logger;
        this.theConfigClass = theConfigClass;
    }

    public boolean loadFields(Configuration config) {
        return this.iterateOverConfigAnd(config, this::setConfigClassField);
    }

    private void setConfigClassField(Field field, Object newValue, Configuration config) {
        try {
            if (IWrappedEnum.class.isAssignableFrom(field.getType())) {
                IWrappedEnum instance = (IWrappedEnum)field.get(null);
                if (instance == null) {
                    instance = (IWrappedEnum)field.getType().newInstance();
                    field.set(null, instance);
                }
                instance.setValue(newValue, field, config);
            } else {
                field.set(null, newValue);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to set value of field " + field.getName());
            e.printStackTrace();
        }
    }

    private boolean iterateOverConfigAnd(Configuration config, TriConsumer<Field, Object, Configuration> callback) {
        boolean needReload = false;
        for (Field field : this.theConfigClass.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            NeedsReload needsReload = null;
            ConfigBoolean configBoolean = null;
            ConfigInt configInt = null;
            ConfigFloat configFloat = null;
            ConfigEnum configEnum = null;
            ConfigStringList configStringList = null;
            ConfigString configString = null;
            ConfigWrappedEnum configWrappedEnum = null;
            for (Annotation an : field.getAnnotations()) {
                if (an instanceof NeedsReload) {
                    needsReload = (NeedsReload)an;
                    continue;
                }
                if (an instanceof ConfigInt) {
                    configInt = (ConfigInt)an;
                    continue;
                }
                if (an instanceof ConfigFloat) {
                    configFloat = (ConfigFloat)an;
                    continue;
                }
                if (an instanceof ConfigBoolean) {
                    configBoolean = (ConfigBoolean)an;
                    continue;
                }
                if (an instanceof ConfigEnum) {
                    configEnum = (ConfigEnum)an;
                    continue;
                }
                if (an instanceof ConfigStringList) {
                    configStringList = (ConfigStringList)an;
                    continue;
                }
                if (an instanceof ConfigString) {
                    configString = (ConfigString)an;
                    continue;
                }
                if (!(an instanceof ConfigWrappedEnum)) continue;
                configWrappedEnum = (ConfigWrappedEnum)an;
            }
            if (configBoolean == null && configInt == null && configFloat == null && configEnum == null && configWrappedEnum == null && configStringList == null && configString == null) continue;
            Object currentValue = null;
            Object newValue = null;
            try {
                currentValue = field.get(null);
            }
            catch (Exception e) {
                this.logger.error("Failed to get value of field " + field.getName());
                e.printStackTrace();
                continue;
            }
            if (configBoolean != null) {
                newValue = config.getBoolean(field.getName(), AnnotationBasedConfigHelper.snakeifyCategory(configBoolean.cat()), configBoolean.def(), configBoolean.com());
            } else if (configInt != null) {
                newValue = config.getInt(field.getName(), AnnotationBasedConfigHelper.snakeifyCategory(configInt.cat()), configInt.def(), configInt.min(), configInt.max(), configInt.com());
            } else if (configFloat != null) {
                newValue = Float.valueOf(config.getFloat(field.getName(), AnnotationBasedConfigHelper.snakeifyCategory(configFloat.cat()), configFloat.def(), configFloat.min(), configFloat.max(), configFloat.com()));
            } else if (configEnum != null || configWrappedEnum != null) {
                String annDef = configEnum != null ? configEnum.def() : configWrappedEnum.def();
                String annCat = configEnum != null ? configEnum.cat() : configWrappedEnum.cat();
                String annCom = configEnum != null ? configEnum.com() : configWrappedEnum.com();
                String fieldName = field.getName();
                WrappedEnum loadableAnn = field.getType().getAnnotation(WrappedEnum.class);
                String categoryProperty = loadableAnn == null ? "" : loadableAnn.categoryProperty();
                String[] parts = fieldName.split("_");
                if (parts.length > 1) {
                    fieldName = parts[parts.length - 1];
                    annCat = annCat + "." + String.join((CharSequence)".", Arrays.copyOf(parts, parts.length - 1));
                }
                if (!categoryProperty.equals("")) {
                    annCat = annCat + "." + fieldName;
                    fieldName = categoryProperty;
                }
                annCat = AnnotationBasedConfigHelper.snakeifyCategory(annCat);
                boolean lowerCase = annDef.codePoints().anyMatch(cp -> Character.isLowerCase(cp));
                Class<Object> configClass = configEnum != null ? field.getType() : loadableAnn.enumClass();
                Map enumMap = EnumUtils.getEnumMap(configClass);
                String[] valuesStrUpper = (String[])enumMap.keySet().stream().toArray(String[]::new);
                String[] valuesStr = (String[])Arrays.stream(valuesStrUpper).map(s -> lowerCase ? s.toLowerCase() : s).toArray(String[]::new);
                ConfigCategory cat = config.getCategory(annCat.toLowerCase());
                String propName = fieldName;
                Property oldProp = cat.get(propName);
                String oldVal = null;
                if (oldProp != null && oldProp.getType() != Property.Type.STRING) {
                    oldVal = oldProp.getString();
                    cat.remove((Object)propName);
                }
                String newValueStr = config.getString(propName, annCat, lowerCase ? annDef.toLowerCase() : annDef.toUpperCase(), annCom, valuesStr);
                if (oldVal != null) {
                    newValueStr = oldVal;
                }
                if (!enumMap.containsKey(newValueStr.toUpperCase())) {
                    newValueStr = annDef.toUpperCase();
                    if (lowerCase) {
                        newValueStr = newValueStr.toLowerCase();
                    }
                }
                newValue = enumMap.get(newValueStr.toUpperCase());
                Property newProp = cat.get(propName);
                if (!newProp.getString().equals(newValueStr)) {
                    newProp.set(newValueStr);
                }
            } else if (configStringList != null) {
                newValue = config.getStringList(field.getName(), AnnotationBasedConfigHelper.snakeifyCategory(configStringList.cat()), configStringList.def(), configStringList.com());
            } else if (configString != null) {
                newValue = config.getString(field.getName(), AnnotationBasedConfigHelper.snakeifyCategory(configString.cat()), configString.def(), configString.com());
            }
            if (needsReload != null && !newValue.equals(currentValue)) {
                needReload = true;
            }
            callback.accept(field, newValue, config);
        }
        return needReload;
    }

    private static String camelCaseToSnakeCase(String s) {
        boolean[] spaceField = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            if (i > 0 && i < s.length() && Character.isLetter(s.charAt(i - 1)) && !Character.isUpperCase(s.charAt(i - 1)) && Character.isLetter(s.charAt(i)) && Character.isUpperCase(s.charAt(i))) {
                spaceField[i] = true;
                continue;
            }
            if (i <= 2 || !Character.isLetter(s.charAt(i - 2)) || !Character.isUpperCase(s.charAt(i - 2)) || !Character.isLetter(s.charAt(i - 1)) || !Character.isUpperCase(s.charAt(i - 1)) || !Character.isLetter(s.charAt(i)) || Character.isUpperCase(s.charAt(i))) continue;
            spaceField[i - 1] = true;
        }
        String out = "";
        for (int i = 0; i < s.length(); ++i) {
            if (spaceField[i]) {
                out = out + "_";
            }
            out = out + Character.toLowerCase(s.charAt(i));
        }
        return out;
    }

    private static String snakeifyCategory(String annCat) {
        return String.join((CharSequence)".", (CharSequence[])Arrays.stream(annCat.split("\\.")).map(s -> AnnotationBasedConfigHelper.camelCaseToSnakeCase(s)).toArray(String[]::new));
    }

    public void saveFields(Configuration config) {
        this.iterateOverConfigAnd(config, (field, newValue, conf) -> {
            block7: {
                try {
                    Object fieldValue = field.get(null);
                    if (fieldValue.equals(newValue)) break block7;
                    for (String catName : config.getCategoryNames()) {
                        ConfigCategory cat;
                        Property prop;
                        String propName = field.getName();
                        Object serializableFieldValue = fieldValue;
                        if (fieldValue instanceof IWrappedEnum) {
                            IWrappedEnum wrappedEnum = (IWrappedEnum)fieldValue;
                            WrappedEnum wrappedEnumAnn = wrappedEnum.getClass().getAnnotation(WrappedEnum.class);
                            if (!wrappedEnumAnn.categoryProperty().isEmpty()) {
                                propName = wrappedEnumAnn.categoryProperty();
                                catName = catName + "." + field.getName();
                            }
                            serializableFieldValue = wrappedEnum.getValue();
                        }
                        String snakeifiedCatName = AnnotationBasedConfigHelper.snakeifyCategory(catName);
                        if (!config.getCategoryNames().contains(snakeifiedCatName) || (prop = (cat = config.getCategory(snakeifiedCatName)).get(propName)) == null) continue;
                        try {
                            AnnotationBasedConfigHelper.setProperty(prop, serializableFieldValue);
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to save field " + field.getName());
                            e.printStackTrace();
                        }
                        return;
                    }
                    this.logger.error("Couldn't find property named " + field.getName() + ", can't save new value");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void setProperty(Property prop, Object newValue) {
        switch (prop.getType()) {
            case BOOLEAN: {
                prop.set(((Boolean)newValue).booleanValue());
                break;
            }
            case DOUBLE: {
                prop.set(((Double)newValue).doubleValue());
                break;
            }
            case INTEGER: {
                prop.set(((Integer)newValue).intValue());
                break;
            }
            case STRING: {
                if (newValue instanceof String[]) {
                    prop.set((String[])newValue);
                    break;
                }
                String val = String.valueOf(newValue);
                if (newValue instanceof Enum && prop.getDefault().toLowerCase().equals(prop.getDefault())) {
                    val = val.toLowerCase();
                }
                prop.set(val);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @FunctionalInterface
    private static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface WrappedEnum {
        public Class<? extends Enum<?>> enumClass();

        public String categoryProperty() default "";
    }

    public static interface IWrappedEnum {
        public Object getValue();

        public void setValue(Object var1, Field var2, Configuration var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigWrappedEnum {
        public String cat();

        public String def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigEnum {
        public String cat();

        public String def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigStringList {
        public String cat();

        public String[] def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigString {
        public String cat();

        public String def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigFloat {
        public String cat();

        public float min();

        public float max();

        public float def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigInt {
        public String cat();

        public int min();

        public int max();

        public int def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigBoolean {
        public String cat();

        public boolean def();

        public String com() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NeedsReload {
    }
}

