/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformercache.lite;

import makamys.coretweaks.optimization.transformercache.lite.TransformerCache;
import net.minecraft.launchwrapper.IClassTransformer;

public class CachedTransformerProxy
implements IClassTransformer {
    public int runs = 0;
    public int misses = 0;
    protected IClassTransformer original;
    private String transformerName;

    public CachedTransformerProxy(IClassTransformer original) {
        this.original = original;
        this.transformerName = original.getClass().getCanonicalName();
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ++this.runs;
        byte[] result = TransformerCache.instance.getCached(this.transformerName, name, transformedName, basicClass);
        if (result == null) {
            ++this.misses;
            TransformerCache.instance.prePutCached(this.transformerName, name, transformedName, basicClass);
            result = this.original.transform(name, transformedName, basicClass);
            TransformerCache.instance.putCached(this.transformerName, name, transformedName, result);
        }
        return result;
    }

    public String toString() {
        return "CachedTransformerProxy{" + this.transformerName + "}";
    }
}

