/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import makamys.coretweaks.CoreTweaks;
import net.minecraft.client.resources.DefaultResourcePack;

public class PrefixedClasspathResourceAccelerator {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("coretweaks.debugPrefixedClasspathResourceAccelerator", "false"));
    private final String basePath;
    private List<URL> assetsDirUrls;

    public PrefixedClasspathResourceAccelerator(String basePath) {
        this.basePath = basePath;
        if (!basePath.startsWith("/")) {
            throw new IllegalArgumentException("basePath must start with /");
        }
        this.initAssetsDirUrls();
    }

    private void initAssetsDirUrls() {
        if (this.assetsDirUrls == null || DEBUG) {
            try {
                ArrayList<URL> urls = Collections.list(DefaultResourcePack.class.getClassLoader().getResources(this.basePath.substring(1)));
                if (this.assetsDirUrls == null) {
                    this.assetsDirUrls = urls;
                } else if (!this.assetsDirUrls.equals(urls)) {
                    CoreTweaks.LOGGER.error("Mismatch detected in DefaultResourcePack optimization! (old assetsDirUrls=" + this.assetsDirUrls + ", new assetsDirUrls=" + urls + ") Please report the issue and disable the option (`fastDefaultTexturePack`) for now.");
                    this.assetsDirUrls = urls;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private InputStream getRelativeResourceAsStream(String relPath) {
        for (URL url : this.assetsDirUrls) {
            try {
                URL candidateUrl = new URL(url.toString() + relPath);
                try {
                    return candidateUrl.openStream();
                }
                catch (IOException iOException) {
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        this.initAssetsDirUrls();
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Argument must start with /");
        }
        InputStream vanillaResult = null;
        if (DEBUG) {
            vanillaResult = DefaultResourcePack.class.getResourceAsStream(path);
        }
        InputStream result = this.getRelativeResourceAsStream(path.substring(this.basePath.length()));
        if (DEBUG && vanillaResult == null != (result == null)) {
            CoreTweaks.LOGGER.error("Mismatch detected in DefaultResourcePack optimization! (path=" + path + ", vanillaResult=" + vanillaResult + ", result=" + result + ") Please report the issue and disable the option (`fastDefaultTexturePack`) for now.");
        }
        return result;
    }
}

