/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.mixin.optimization.jardiscoverercache;

import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.JarDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.optimization.JarDiscovererCache;
import net.minecraft.network.play.INetHandlerPlayClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JarDiscoverer.class}, remap=false)
abstract class MixinJarDiscoverer
implements INetHandlerPlayClient {
    private ZipEntry lastZipEntry;
    String lastHash;
    JarDiscovererCache.CachedModInfo lastCMI;

    MixinJarDiscoverer() {
    }

    @Inject(method={"discover"}, at={@At(value="HEAD")})
    public void preDiscover(ModCandidate candidate, ASMDataTable table, CallbackInfoReturnable cir) {
        String hash = null;
        File file = candidate.getModContainer();
        this.lastHash = hash = file.getPath() + "@" + file.lastModified();
        this.lastCMI = JarDiscovererCache.getCachedModInfo(this.lastHash);
        CoreTweaks.LOGGER.debug("preDiscover " + candidate.getModContainer() + "(hash " + this.lastHash + ")");
    }

    @Redirect(method={"discover"}, at=@At(value="INVOKE", target="Ljava/util/jar/JarFile;getInputStream(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;"))
    public InputStream redirectGetInputStream(JarFile jf, ZipEntry ze) throws IOException {
        this.lastZipEntry = ze;
        return jf.getInputStream(ze);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"discover"}, at=@At(value="NEW", target="cpw/mods/fml/common/discovery/asm/ASMModParser"))
    public ASMModParser redirectNewASMModParser(InputStream stream, ModCandidate candidate, ASMDataTable table) throws IOException {
        ASMModParser parser = this.lastCMI.getCachedParser(this.lastZipEntry);
        if (parser == null) {
            try {
                parser = new ASMModParser(stream);
            }
            finally {
                stream.close();
            }
            this.lastCMI.putParser(this.lastZipEntry, parser);
        }
        return parser;
    }

    @Redirect(method={"discover"}, at=@At(value="INVOKE", target="Lcpw/mods/fml/common/ModContainerFactory;build(Lcpw/mods/fml/common/discovery/asm/ASMModParser;Ljava/io/File;Lcpw/mods/fml/common/discovery/ModCandidate;)Lcpw/mods/fml/common/ModContainer;"))
    public ModContainer redirectBuild(ModContainerFactory factory, ASMModParser modParser, File modSource, ModCandidate container, ModCandidate candidate, ASMDataTable table) {
        int isModClass = this.lastCMI.getCachedIsModClass(this.lastZipEntry);
        ModContainer mc = null;
        if (isModClass != 0) {
            mc = factory.build(modParser, modSource, container);
            if (isModClass == -1) {
                this.lastCMI.putIsModClass(this.lastZipEntry, mc != null);
            }
        }
        return mc;
    }
}

