/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.mixin.optimization.foldertexturepack;

import java.io.File;
import java.util.HashSet;
import makamys.coretweaks.CoreTweaks;
import net.minecraft.client.resources.FolderResourcePack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FolderResourcePack.class})
public abstract class MixinFolderResourcePack {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("coretweaks.debugFolderResourcePackMixin", "false"));
    HashSet<String> filePaths = new HashSet();

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void afterConstructor(File folder, CallbackInfo ci) {
        if (DEBUG) {
            CoreTweaks.LOGGER.info("running after constructor, folder=" + folder);
        }
        this.explore(folder, folder.getPath());
    }

    private void explore(File folder, String path) {
        if (DEBUG) {
            CoreTweaks.LOGGER.info("exploring folder=" + folder + " path=" + path);
        }
        for (File f : folder.listFiles()) {
            String myPath = (path.isEmpty() ? "" : path + File.separator) + f.getName();
            this.filePaths.add(myPath);
            if (!f.isDirectory()) continue;
            this.explore(f, myPath);
        }
    }

    @Redirect(method={"hasResourceName(Ljava/lang/String;)Z"}, at=@At(value="INVOKE", target="Ljava/io/File;isFile()Z", remap=false))
    public boolean redirectIsFile(File file) {
        boolean result = this.filePaths.contains(file.getPath());
        if (DEBUG) {
            CoreTweaks.LOGGER.info("isFile " + file + " ? " + result);
        }
        return result;
    }
}

