/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLiquid;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import xaero.map.BlockPos;
import xaero.map.MapProcessor;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.misc.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;

public class OverlayBuilder {
    private static final int MAX_OVERLAYS = 10;
    private Overlay[] overlayBuildingSet;
    private int currentOverlayIndex;
    private OverlayManager overlayManager;
    private IIcon prevIcon;
    private int overlayBiome;

    public OverlayBuilder(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
        this.overlayBuildingSet = new Overlay[10];
        for (int i = 0; i < this.overlayBuildingSet.length; ++i) {
            this.overlayBuildingSet[i] = new Overlay(0, new int[3], 0, 0, false);
        }
        this.currentOverlayIndex = -1;
    }

    public void startBuilding() {
        this.currentOverlayIndex = -1;
        this.setOverlayBiome(-1);
    }

    public void build(int state, int[] biome, int opacity, byte light, World world, MapProcessor mapProcessor, BlockPos mutableBlockPos, int biomeId, BlockStateColorTypeCache colorTypeCache, BiomeInfoSupplier biomeSupplier) {
        Overlay currentOverlay = null;
        if (this.currentOverlayIndex >= 0) {
            currentOverlay = this.overlayBuildingSet[this.currentOverlayIndex];
        }
        Overlay nextOverlay = null;
        if (this.currentOverlayIndex < this.overlayBuildingSet.length - 1) {
            nextOverlay = this.overlayBuildingSet[this.currentOverlayIndex + 1];
        }
        IIcon icon = null;
        boolean changed = false;
        Block b = Block.func_149729_e((int)Misc.getIdFromStateId(state));
        if (currentOverlay == null || currentOverlay.getState() != state) {
            icon = Misc.getTopIconForBlock(b, Misc.getMetaFromStateId(state));
            boolean bl = changed = icon != this.prevIcon;
        }
        if (nextOverlay != null && (currentOverlay == null || changed)) {
            float transparency = b instanceof BlockLiquid ? 0.66f : (b instanceof BlockIce ? 0.83f : 0.5f);
            boolean glowing = false;
            try {
                glowing = mapProcessor.getMapWriter().isGlowing(b);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (biomeSupplier != null) {
                biomeSupplier.getBiomeInfo(colorTypeCache, world, state, b, Misc.getMetaFromStateId(state), mutableBlockPos, biome, biomeId);
                biomeId = biome[1];
            }
            if (this.getOverlayBiome() == -1) {
                this.setOverlayBiome(biomeId);
            }
            nextOverlay.write(state, biome, transparency, light, glowing);
            currentOverlay = nextOverlay;
            ++this.currentOverlayIndex;
        }
        currentOverlay.increaseOpacity(opacity);
        if (changed) {
            this.prevIcon = icon;
        }
    }

    public void finishBuilding(MapBlock block) {
        for (int i = 0; i <= this.currentOverlayIndex; ++i) {
            Overlay o = this.overlayBuildingSet[i];
            Overlay original = this.overlayManager.getOriginal(o);
            if (o == original) {
                this.overlayBuildingSet[i] = new Overlay(0, new int[3], 0, 0, false);
            }
            block.addOverlay(original);
        }
    }

    public int getOverlayBiome() {
        return this.overlayBiome;
    }

    public void setOverlayBiome(int overlayBiome) {
        this.overlayBiome = overlayBiome;
    }
}

