/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuElement;
import xaero.map.mods.gui.WaypointMenuHitbox;
import xaero.map.mods.gui.WaypointMenuScroll;

public class WaypointMenuRenderer {
    private static final int WAYPOINT_MENU_RIGHT_PADDING = 27;
    public static final int MAX_WAYPOINT_MENU_SIZE = 10;
    public static final int MIN_WAYPOINT_MENU_SIZE = 2;
    private final WaypointMenuScroll scrollUp = new WaypointMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    private final WaypointMenuScroll scrollDown = new WaypointMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    private final WaypointMenuHitbox extraHitbox = new WaypointMenuHitbox(-150, 0, 177, 0);
    private Minecraft mc = Minecraft.func_71410_x();

    public void onMapInit(final GuiMap screen, List<GuiDropDown> dropdowns, Minecraft mc, final int width, final int height, final WaypointWorld waypointWorld, final IXaeroMinimap modMain, final XaeroMinimapSession minimapSession) {
        if (screen.waypointMenu) {
            GuiDropDown setsDropdown;
            final boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
            final GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
            IDropDownCallback setsDropdownCallback = null;
            if (sets != null) {
                setsDropdownCallback = new IDropDownCallback(){

                    @Override
                    public boolean onSelected(GuiDropDown menu, int selected) {
                        if (canCreate && selected == menu.size() - 1) {
                            GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (GuiScreen)screen, (GuiScreen)screen, waypointWorld);
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)guiNewSet);
                            return false;
                        }
                        sets.setCurrentSet(selected);
                        waypointWorld.setCurrent(sets.getCurrentSetKey());
                        minimapSession.getWaypointsManager().updateWaypoints();
                        try {
                            modMain.getSettings().saveWaypoints(waypointWorld);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                };
            }
            GuiDropDown guiDropDown = setsDropdown = sets == null ? null : new GuiDropDown(sets.getOptions(), width - 173, height - 56, 151, sets.getCurrentSet(), true, setsDropdownCallback, true);
            if (setsDropdown != null) {
                dropdowns.add(setsDropdown);
            }
            screen.addGuiButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    WaypointMenuRenderer.this.onFullMenuButton(b, screen);
                }
            }, new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_full_waypoints_menu", (Object[])new Object[]{Misc.getKeyName(ModSettings.keyWaypoints)}), "", true)));
            screen.addGuiButton(new GuiTexturedButton(width - 153, height - 20, 20, 20, !modMain.getSettings().renderAllSets ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    WaypointMenuRenderer.this.onRenderAllSetsButton(b, screen, width, height);
                }
            }, new CursorBox(I18n.func_135052_a((String)(!modMain.getSettings().renderAllSets ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets"), (Object[])new Object[]{Misc.getKeyName(ModSettings.keyAllSets)}), "", true)));
            screen.addGuiButton(new GuiTexturedButton(width - 133, height - 20, 20, 20, WorldMap.settings.showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    WaypointMenuRenderer.this.onShowDisabledButton(b, screen, width, height);
                }
            }, new CursorBox(WorldMap.settings.showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", "", true)));
        }
    }

    public WaypointMenuElement renderWaypointsMenu(GuiMap gui, ArrayList<Waypoint> sideWaypoints, double scale, int width, int height, int offset, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, Minecraft mc) {
        int menuStartPos;
        WaypointMenuElement viewed = null;
        int yPos = menuStartPos = WaypointMenuRenderer.menuStartPos(height);
        int elementCount = WaypointMenuRenderer.getMenuElementCount(yPos);
        viewed = this.renderWaypointMenuElement(this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < sideWaypoints.size(); ++i) {
            viewed = this.renderWaypointMenuElement(sideWaypoints.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderWaypointMenuElement(this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset < sideWaypoints.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof WaypointMenuScroll) {
            int direction = ((WaypointMenuScroll)viewed).scroll();
            gui.waypointMenuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderWaypointMenuElement(this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
        }
        return viewed;
    }

    public static int menuStartPos(int height) {
        return height - 59;
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private WaypointMenuElement renderWaypointMenuElement(WaypointMenuElement element, int width, int yPos, int mouseX, int mouseY, WaypointMenuElement viewed, boolean leftMousePressed, GuiScreen gui, boolean enabled, Minecraft mc) {
        boolean hovered;
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && element.isMouseOverElement(xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        element.renderInMenu(gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        return viewed;
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void onFullMenuButton(GuiButton b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(GuiButton b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
    }

    private void onShowDisabledButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMap.settings.showDisabledWaypoints = !WorldMap.settings.showDisabledWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        screen.func_146280_a(this.mc, width, height);
    }
}

