/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import makeo.gadomancy.common.utils.Injector;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileJarFillableVoid;

public class TileStickyJar
extends TileJarFillable {
    private Block parentBlock;
    private Integer parentMetadata = 0;
    private TileJarFillable parent = null;
    public ForgeDirection placedOn;
    private final Injector injector = new Injector(null, TileJarFillable.class);
    private Field fieldCount = Injector.getField("count", TileJarFillable.class);
    private boolean needsRenderUpdate = false;
    private int count;

    public Block getParentBlock() {
        return this.parentBlock;
    }

    public TileJarFillable getParent() {
        return this.parent;
    }

    public boolean isValid() {
        return this.parentBlock != null && this.parent != null;
    }

    public void init(TileJarFillable parent, Block parentBlock, int parentMetadata, ForgeDirection placedOn) {
        this.parent = parent;
        this.placedOn = placedOn;
        parent.field_145851_c = this.field_145851_c;
        parent.field_145848_d = this.field_145848_d;
        parent.field_145849_e = this.field_145849_e;
        this.syncFromParent();
        this.parent.func_145834_a(this.func_145831_w());
        this.parentBlock = parentBlock;
        this.parentMetadata = parentMetadata;
        this.injector.setObject(this.parent);
        this.func_70296_d();
        this.needsRenderUpdate = true;
    }

    private void sync(TileJarFillable from, TileJarFillable to) {
        to.aspect = from.aspect;
        to.aspectFilter = from.aspectFilter;
        to.amount = from.amount;
        to.maxAmount = from.maxAmount;
        to.facing = from.facing;
        to.forgeLiquid = from.forgeLiquid;
        to.lid = from.lid;
    }

    public void syncToParent() {
        this.sync(this, this.parent);
    }

    public void syncFromParent() {
        this.sync(this.parent, this);
    }

    public Integer getParentMetadata() {
        return this.parentMetadata;
    }

    public void func_145845_h() {
        boolean canTakeEssentia;
        if (!this.isValid()) {
            if (!this.func_145831_w().field_72995_K) {
                this.func_145831_w().func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
            }
            return;
        }
        if (this.func_145831_w().field_72995_K && this.needsRenderUpdate) {
            this.needsRenderUpdate = false;
            Minecraft.func_71410_x().field_71438_f.func_147586_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.syncToParent();
        boolean bl = canTakeEssentia = this.amount < this.maxAmount;
        if (this.parent instanceof TileJarFillableVoid) {
            canTakeEssentia = true;
        }
        if (!this.field_145850_b.field_72995_K && ++this.count % 5 == 0 && canTakeEssentia) {
            this.fillJar();
        }
        this.injector.setField(this.fieldCount, (Object)1);
        this.parent.func_145845_h();
        this.syncFromParent();
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.parent != null) {
            this.parent.func_145834_a(this.field_145850_b);
        }
    }

    private void fillJar() {
        ForgeDirection inputDir = this.placedOn.getOpposite();
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.parent.func_145831_w(), (int)this.parent.field_145851_c, (int)this.parent.field_145848_d, (int)this.parent.field_145849_e, (ForgeDirection)inputDir);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.DOWN)) {
                return;
            }
            Aspect ta = null;
            if (this.parent.aspectFilter != null) {
                ta = this.parent.aspectFilter;
            } else if (this.parent.aspect != null && this.parent.amount > 0) {
                ta = this.parent.aspect;
            } else if (ic.getEssentiaAmount(inputDir.getOpposite()) > 0 && ic.getSuctionAmount(inputDir.getOpposite()) < this.getSuctionAmount(ForgeDirection.UP) && this.getSuctionAmount(ForgeDirection.UP) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(inputDir.getOpposite());
            }
            if (ta != null && ic.getSuctionAmount(inputDir.getOpposite()) < this.getSuctionAmount(ForgeDirection.UP)) {
                this.addToContainer(ta, ic.takeEssentia(ta, 1, inputDir.getOpposite()));
            }
        }
    }

    public void readCustomNBT(NBTTagCompound compound) {
        Block block;
        String parentType = compound.func_74779_i("parentType");
        if (parentType.length() > 0 && (block = (Block)GameData.getBlockRegistry().func_82594_a(parentType)) != null && compound.func_74764_b("parent") && compound.func_74764_b("parentMetadata")) {
            NBTTagCompound data = compound.func_74775_l("parent");
            int metadata = compound.func_74762_e("parentMetadata");
            TileEntity tile = block.createTileEntity(this.func_145831_w(), metadata);
            if (tile instanceof TileJarFillable) {
                this.placedOn = ForgeDirection.getOrientation((int)compound.func_74762_e("placedOn"));
                tile.func_145839_a(data);
                this.init((TileJarFillable)tile, block, metadata, this.placedOn);
            }
        }
        if (!this.isValid() && !this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        if (this.isValid()) {
            compound.func_74778_a("parentType", GameData.getBlockRegistry().func_148750_c((Object)this.parentBlock));
            compound.func_74768_a("parentMetadata", this.parentMetadata.intValue());
            this.syncToParent();
            NBTTagCompound data = new NBTTagCompound();
            this.parent.func_145841_b(data);
            compound.func_74782_a("parent", (NBTBase)data);
            compound.func_74768_a("placedOn", this.placedOn.ordinal());
        }
    }

    public AspectList getAspects() {
        if (this.isValid()) {
            this.syncToParent();
            AspectList result = this.parent.getAspects();
            this.syncFromParent();
            return result;
        }
        return new AspectList();
    }

    public void setAspects(AspectList paramAspectList) {
        if (this.isValid()) {
            this.syncToParent();
            this.parent.getAspects();
            this.syncFromParent();
        }
    }

    public boolean doesContainerAccept(Aspect paramAspect) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.doesContainerAccept(paramAspect);
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public int addToContainer(Aspect paramAspect, int paramInt) {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.addToContainer(paramAspect, paramInt);
            this.syncFromParent();
            return result;
        }
        return paramInt;
    }

    public boolean takeFromContainer(Aspect paramAspect, int paramInt) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.takeFromContainer(paramAspect, paramInt);
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList paramAspectList) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.takeFromContainer(paramAspectList);
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect paramAspect, int paramInt) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.doesContainerContainAmount(paramAspect, paramInt);
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public boolean doesContainerContain(AspectList paramAspectList) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.doesContainerContain(paramAspectList);
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public int containerContains(Aspect paramAspect) {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.containerContains(paramAspect);
            this.syncFromParent();
            return result;
        }
        return 0;
    }

    public boolean isConnectable(ForgeDirection face) {
        if (this.isValid()) {
            this.syncToParent();
            return this.parent.isConnectable(this.changeDirection(face));
        }
        return false;
    }

    public boolean canInputFrom(ForgeDirection face) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.canInputFrom(this.changeDirection(face));
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public boolean canOutputTo(ForgeDirection face) {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.canOutputTo(this.changeDirection(face));
            this.syncFromParent();
            return result;
        }
        return false;
    }

    public ForgeDirection changeDirection(ForgeDirection face) {
        if (this.placedOn == ForgeDirection.UP) {
            if (face == ForgeDirection.UP || face == ForgeDirection.DOWN) {
                return face.getOpposite();
            }
            return face;
        }
        if (this.placedOn == ForgeDirection.DOWN) {
            return face;
        }
        if (face == ForgeDirection.UP) {
            return ForgeDirection.NORTH;
        }
        if (face == ForgeDirection.DOWN) {
            return ForgeDirection.SOUTH;
        }
        if (face == this.placedOn) {
            return ForgeDirection.DOWN;
        }
        if (face == this.placedOn.getOpposite()) {
            return ForgeDirection.UP;
        }
        switch (this.placedOn) {
            case EAST: {
                return face == ForgeDirection.NORTH ? ForgeDirection.WEST : ForgeDirection.EAST;
            }
            case SOUTH: {
                return face.getOpposite();
            }
            case WEST: {
                return face == ForgeDirection.SOUTH ? ForgeDirection.WEST : ForgeDirection.EAST;
            }
        }
        return face;
    }

    public void setSuction(Aspect paramAspect, int paramInt) {
        if (this.isValid()) {
            this.syncToParent();
            this.parent.setSuction(paramAspect, paramInt);
            this.syncFromParent();
        }
    }

    public Aspect getSuctionType(ForgeDirection paramForgeDirection) {
        if (this.isValid()) {
            this.syncToParent();
            Aspect result = this.parent.getSuctionType(this.changeDirection(paramForgeDirection));
            this.syncFromParent();
            return result;
        }
        return null;
    }

    public int getSuctionAmount(ForgeDirection paramForgeDirection) {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.getSuctionAmount(this.changeDirection(paramForgeDirection));
            this.syncFromParent();
            return result;
        }
        return 0;
    }

    public int takeEssentia(Aspect paramAspect, int paramInt, ForgeDirection paramForgeDirection) {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.takeEssentia(paramAspect, paramInt, this.changeDirection(paramForgeDirection));
            this.syncFromParent();
            return result;
        }
        return paramInt;
    }

    public int addEssentia(Aspect paramAspect, int paramInt, ForgeDirection paramForgeDirection) {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.addEssentia(paramAspect, paramInt, this.changeDirection(paramForgeDirection));
            this.syncFromParent();
            return result;
        }
        return paramInt;
    }

    public Aspect getEssentiaType(ForgeDirection paramForgeDirection) {
        if (this.isValid()) {
            this.syncToParent();
            Aspect result = this.parent.getEssentiaType(this.changeDirection(paramForgeDirection));
            this.syncFromParent();
            return result;
        }
        return null;
    }

    public int getEssentiaAmount(ForgeDirection paramForgeDirection) {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.getEssentiaAmount(this.changeDirection(paramForgeDirection));
            this.syncFromParent();
            return result;
        }
        return 0;
    }

    public int getMinimumSuction() {
        if (this.isValid()) {
            this.syncToParent();
            int result = this.parent.getMinimumSuction();
            this.syncFromParent();
            return result;
        }
        return 0;
    }

    public boolean renderExtendedTube() {
        if (this.isValid()) {
            this.syncToParent();
            boolean result = this.parent.renderExtendedTube();
            this.syncFromParent();
            return result;
        }
        return false;
    }
}

