/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import java.util.ArrayList;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.utils.ItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.tiles.TileJarFillable;

public class TileArcanePackager
extends TileJarFillable
implements IInventory,
ISidedInventory {
    private static final Aspect ASPECT = Aspect.CLOTH;
    private ItemStack[] contents = new ItemStack[12];
    public byte progress = (byte)-1;
    public boolean autoStart = false;
    public boolean useEssentia = false;
    public boolean disguise = false;
    private Boolean redstoneState = null;
    private int count = 0;
    private static final int[] ORIENTATION_MAPPING = new int[]{-1, -1, 0, 2, 1, 3};

    public TileArcanePackager() {
        this.aspectFilter = ASPECT;
        this.maxAmount = 8;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.contents = new ItemStack[this.func_70302_i_()];
        NBTTagList list = compound.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound slot = list.func_150305_b(i);
            int j = slot.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)slot);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(slot);
            list.func_74742_a((NBTBase)slot);
        }
        compound.func_74782_a("Items", (NBTBase)list);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.progress >= 0 && this.progress < 46) {
                this.progress = (byte)(this.progress + 1);
            }
        } else {
            if (this.redstoneState == null) {
                this.redstoneState = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.progress >= 47) {
                this.doPack();
                this.progress = (byte)-1;
                this.markForUpdate();
                this.count = 1;
            }
            if (this.progress >= 0) {
                this.progress = (byte)(this.progress + 1);
            } else if (this.count++ % 5 == 0 && this.autoStart && this.canPack()) {
                this.progress = 0;
                this.markForUpdate();
            }
        }
    }

    public void updateRedstone(boolean state) {
        if (this.redstoneState != null && state && !this.redstoneState.booleanValue() && this.canPack()) {
            this.progress = 0;
            this.markForUpdate();
        }
        this.redstoneState = state;
    }

    private boolean canPack() {
        if (this.func_70301_a(11) != null) {
            return false;
        }
        boolean check = false;
        for (int i = 0; i < 9; ++i) {
            if (this.func_70301_a(i) == null) continue;
            check = true;
            break;
        }
        if (!check) {
            return false;
        }
        if (this.useEssentia) {
            if (this.amount < 4) {
                return false;
            }
        } else {
            ItemStack leather = this.func_70301_a(9);
            if (leather == null || leather.field_77994_a < 1 || leather.func_77973_b() != Items.field_151116_aA) {
                return false;
            }
            ItemStack string = this.func_70301_a(10);
            if (string == null || string.field_77994_a < 1 || string.func_77973_b() != Items.field_151007_F) {
                return false;
            }
        }
        return true;
    }

    private void doPack() {
        if (this.canPack()) {
            ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null) continue;
                contents.add(stack);
            }
            ItemStack pack = new ItemStack((Item)(this.disguise ? RegisteredItems.itemFakeLootbag : RegisteredItems.itemPackage), 1, this.useEssentia ? 1 : 0);
            boolean success = RegisteredItems.itemPackage.setContents(pack, contents);
            if (success) {
                if (this.useEssentia) {
                    this.amount -= 4;
                } else {
                    this.func_70298_a(9, 1);
                    this.func_70298_a(10, 1);
                }
                this.func_70299_a(11, pack);
                for (int i = 0; i < 9; ++i) {
                    this.func_70299_a(i, null);
                }
            } else {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.0f, false, false);
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = this.contents[i];
                    if (stack == null) continue;
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)((float)this.field_145848_d + 0.8125f), (double)this.field_145849_e + 0.5, stack);
                    ItemUtils.applyRandomDropOffset(entityItem, this.field_145850_b.field_73012_v);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                    this.contents[i] = null;
                }
                this.progress = (byte)-1;
                this.markForUpdate();
            }
        }
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.aspectFilter = ASPECT;
        this.progress = compound.func_74771_c("progress");
        byte settings = compound.func_74771_c("settings");
        this.autoStart = (settings & 1) == 1;
        this.useEssentia = (settings & 2) == 2;
        this.disguise = (settings & 4) == 4;
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_82580_o("AspectFilter");
        compound.func_74774_a("progress", this.progress);
        byte settings = (byte)(this.autoStart ? 1 : 0);
        settings = (byte)(settings | (this.useEssentia ? 2 : 0));
        settings = (byte)(settings | (this.disguise ? 4 : 0));
        compound.func_74774_a("settings", settings);
    }

    public void markForUpdate() {
        this.func_70296_d();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int func_70302_i_() {
        return 12;
    }

    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.contents[slot] != null) {
            if (this.contents[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.contents[slot];
                this.contents[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.contents[slot].func_77979_a(amount);
            if (this.contents[slot].field_77994_a == 0) {
                this.contents[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.contents[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int getMinimumSuction() {
        return super.getMinimumSuction() * 2;
    }

    public int getSuctionAmount(ForgeDirection loc) {
        return super.getSuctionAmount(loc) * 2;
    }

    public String func_145825_b() {
        return "blub";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 9) {
            return stack.func_77973_b() == Items.field_151116_aA;
        }
        if (slot == 10) {
            return stack.func_77973_b() == Items.field_151007_F;
        }
        return slot != 11;
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{11};
        }
        if (ORIENTATION_MAPPING[side] == this.facing) {
            return new int[]{9, 10, 0, 1, 2, 3, 4, 5, 6, 7, 8};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return !this.useEssentia || slot != 9 && slot != 10;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }
}

