/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.renderers.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.EntityRenderer;

public class PlayerCameraRenderer
extends EntityRenderer {
    private final Minecraft minecraft;
    private boolean isMarkedForRemoval;
    private boolean isRemoved;
    private EntityRenderer prevRenderer;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    public float zOffset = 0.0f;

    public PlayerCameraRenderer(Minecraft minecraft, EntityRenderer prevRenderer) {
        super(minecraft, minecraft.func_110442_L());
        this.minecraft = minecraft;
        this.isMarkedForRemoval = false;
        this.isRemoved = false;
        this.prevRenderer = prevRenderer;
    }

    public EntityRenderer getPrevRenderer() {
        return this.prevRenderer;
    }

    public boolean isMarkedForRemoval() {
        return this.isMarkedForRemoval;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void markForRemoval() {
        this.isMarkedForRemoval = true;
    }

    private boolean canChangeView() {
        return !this.isMarkedForRemoval && this.minecraft.field_71439_g != null && !this.minecraft.field_71439_g.func_70115_ae() && !this.minecraft.field_71439_g.func_70608_bn();
    }

    private void removeIfMarked() {
        if (this.isMarkedForRemoval && ((Object)((Object)this)).equals(Minecraft.func_71410_x().field_71460_t)) {
            Minecraft.func_71410_x().field_71460_t = this.prevRenderer;
            this.isRemoved = true;
        }
    }

    public void func_78480_b(float partialTicks) {
        this.removeIfMarked();
        if (this.canChangeView()) {
            this.moveCam(-1);
            super.func_78480_b(partialTicks);
            this.moveCam(1);
            return;
        }
        super.func_78480_b(partialTicks);
    }

    private void moveCam(int mod) {
        EntityClientPlayerMP player = this.minecraft.field_71439_g;
        player.field_70165_t += (double)(this.xOffset * (float)mod);
        player.field_70142_S += (double)(this.xOffset * (float)mod);
        player.field_70169_q += (double)(this.xOffset * (float)mod);
        player.field_70163_u += (double)(this.yOffset * (float)mod);
        player.field_70137_T += (double)(this.yOffset * (float)mod);
        player.field_70167_r += (double)(this.yOffset * (float)mod);
        player.field_70161_v += (double)(this.zOffset * (float)mod);
        player.field_70136_U += (double)(this.zOffset * (float)mod);
        player.field_70166_s += (double)(this.zOffset * (float)mod);
    }

    public void func_78473_a(float partialTicks) {
        this.removeIfMarked();
        if (this.canChangeView()) {
            this.moveCam(-1);
            super.func_78473_a(partialTicks);
            this.moveCam(1);
            return;
        }
        super.func_78473_a(partialTicks);
    }
}

