/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.effect;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import makeo.gadomancy.client.effect.fx.FXFlow;
import makeo.gadomancy.client.effect.fx.FXVortex;
import makeo.gadomancy.client.effect.fx.Orbital;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class EffectHandler {
    public static final EffectHandler instance = new EffectHandler();
    public static List<Orbital> orbitals = new LinkedList<Orbital>();
    public static List<FXFlow> fxFlows = new LinkedList<FXFlow>();
    public static List<FXVortex> fxVortexes = new LinkedList<FXVortex>();
    public static final Object lockEffects = new Object();

    public static EffectHandler getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        Tessellator tessellator = Tessellator.field_78398_a;
        FXFlow.FXFlowBase.sheduleRender(tessellator);
        Orbital.sheduleRenders(orbitals, event.partialTicks);
        FXVortex.sheduleRender(fxVortexes, tessellator, event.partialTicks);
    }

    public FXFlow effectFlow(World world, Vector3 origin, FXFlow.EntityFlowProperties properties) {
        FXFlow flow = new FXFlow(world);
        flow.applyProperties(properties).setPosition(origin);
        this.registerFlow(flow);
        return flow;
    }

    public void registerVortex(final FXVortex vortex) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    fxVortexes.add(vortex);
                    vortex.registered = true;
                }
            }
        }).start();
    }

    public void unregisterVortex(final FXVortex vortex) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    fxVortexes.remove(vortex);
                    vortex.registered = false;
                }
            }
        }).start();
    }

    public void registerFlow(final FXFlow flow) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    fxFlows.add(flow);
                }
            }
        }).start();
    }

    public void unregisterFlow(final FXFlow flow) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    fxFlows.remove(flow);
                }
            }
        }).start();
    }

    public void registerOrbital(final Orbital orbital) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    orbitals.add(orbital);
                    orbital.registered = true;
                }
            }
        }).start();
    }

    public void unregisterOrbital(final Orbital orbital) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    orbitals.remove(orbital);
                    orbital.registered = false;
                }
            }
        }).start();
    }

    public void tick() {
        Orbital.tickOrbitals(orbitals);
        FXFlow.tickFlows(fxFlows);
        FXVortex.tickVortexes(fxVortexes);
    }

    public void clear() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lockEffects;
                synchronized (object) {
                    orbitals.clear();
                    fxFlows.clear();
                    fxVortexes.clear();
                }
            }
        }).start();
    }

    public static class NonReentrantReentrantLock
    extends ReentrantLock {
        @Override
        public boolean isHeldByCurrentThread() {
            return false;
        }

        @Override
        public void lock() {
            super.lock();
        }

        @Override
        public void unlock() {
            super.unlock();
        }
    }
}

