/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.animfix.stitching.packing2d;

import com.falsepattern.animfix.stitching.Rect2D;

class StripLevel {
    private final int width;
    private final int top;
    private int availableWidth;
    private int tallest = -1;

    StripLevel(int width, int top) {
        this.width = width;
        this.availableWidth = width;
        this.top = top;
    }

    boolean checkFitRectangle(Rect2D r) {
        return (this.tallest < 0 || r.height <= this.tallest) && r.width <= this.availableWidth;
    }

    StripLevel fitRectangle(Rect2D r) {
        if (this.tallest >= 0 && r.height > this.tallest) {
            return null;
        }
        StripLevel newStrip = null;
        int leftOver = this.availableWidth - r.width;
        if (leftOver >= 0) {
            r.x = this.width - this.availableWidth;
            r.y = this.top;
            if (this.tallest == -1) {
                this.tallest = r.height;
            }
            if (r.height < this.tallest) {
                newStrip = new StripLevel(this.width, this.top + r.height);
                newStrip.availableWidth = this.availableWidth;
                newStrip.tallest = this.tallest - r.height;
                this.tallest = r.height;
            }
            this.availableWidth = leftOver;
        }
        return newStrip;
    }

    int availableWidth() {
        return this.availableWidth;
    }

    boolean canFit(Rect2D r) {
        return this.availableWidth - r.width >= 0 && (this.tallest < 0 || r.height <= this.tallest);
    }

    public int getTallest() {
        return this.tallest;
    }
}

